/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public class Options
extends AbstractSet<OptionEntry>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String EMPTY_STRING = "";
    private final ArrayList<OptionEntry> list;

    public Options() {
        this.list = new ArrayList();
    }

    public Options(Options other) {
        this.list = new ArrayList(other.size());
        this.addAll(other);
    }

    public Options(OptionEntry[] entries) {
        this.list = new ArrayList(entries.length);
        for (int i = 0; i < entries.length; ++i) {
            this.add(entries[i]);
        }
    }

    public Options(Class<?> enumType) {
        if (enumType == null || !enumType.isEnum()) {
            throw new InvalidArgumentException("enumType", enumType);
        }
        Enum[] items = (Enum[])enumType.getEnumConstants();
        this.list = new ArrayList(items.length);
        for (int i = 0; i < items.length; ++i) {
            Enum item = items[i];
            this.add(item, item.toString(), true);
        }
    }

    public Options clone() {
        return new Options(this);
    }

    protected int getIndex(Object value) {
        OptionEntry oe;
        if (value instanceof OptionEntry) {
            int index = this.list.indexOf(value);
            if (index >= 0) {
                return index;
            }
            value = ((OptionEntry)value).getValue();
        }
        return (oe = this.getEntry(value)) != null ? this.list.indexOf(oe) : -1;
    }

    protected OptionEntry createOptionEntry(Object value, String text, boolean active) {
        return new OptionEntry(value, text, active);
    }

    public OptionEntry getEntry(Object value) {
        if (value instanceof Map.Entry) {
            value = ((Map.Entry)value).getKey();
        }
        if (value instanceof OptionEntry) {
            value = ((OptionEntry)value).getValue();
        }
        for (OptionEntry oe : this.list) {
            if (!oe.valueEquals(value)) continue;
            return oe;
        }
        return null;
    }

    public String get(Object value) {
        OptionEntry oe = this.getEntry(value);
        return oe != null ? oe.getText() : EMPTY_STRING;
    }

    public boolean isActive(Object value) {
        OptionEntry oe = this.getEntry(value);
        return oe != null ? oe.isActive() : false;
    }

    public Object getValueAt(int i) {
        return i >= 0 && i < this.list.size() ? this.list.get(i).getValue() : null;
    }

    public String getTextAt(int i) {
        return i >= 0 && i < this.list.size() ? this.list.get(i).getText() : EMPTY_STRING;
    }

    public Set<Object> getValues() {
        HashSet<Object> set = new HashSet<Object>(this.list.size());
        for (OptionEntry e : this.list) {
            set.add(e.getValue());
        }
        return set;
    }

    public void set(Object value, String text, boolean active, InsertPos pos) {
        if (text == null) {
            return;
        }
        OptionEntry oe = this.getEntry(value);
        if (oe != null) {
            oe.setText(text);
            oe.setActive(active);
        } else {
            int index = pos == InsertPos.Top ? 0 : (pos == InsertPos.Sort ? this.findInsertPos(text) : this.list.size());
            this.list.add(index, this.createOptionEntry(value, text, active));
        }
    }

    public void set(Object value, String text, InsertPos pos) {
        this.set(value, text, true, pos);
    }

    public void set(Object value, String text) {
        this.set(value, text, InsertPos.Bottom);
    }

    public void add(Object value, String text, boolean active) {
        OptionEntry oe = this.getEntry(value);
        if (oe != null) {
            oe.setText(text);
            oe.setActive(active);
        } else {
            this.list.add(this.createOptionEntry(value, text, active));
        }
    }

    @Override
    public boolean add(OptionEntry option) {
        if (option.getText() == null) {
            return false;
        }
        OptionEntry oe = this.getEntry(option.getValue());
        if (oe != null) {
            this.list.set(this.getIndex(oe), option);
        } else {
            this.list.add(option);
        }
        return true;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object value) {
        return this.getEntry(value) != null;
    }

    public boolean containsNull() {
        return this.getEntry(EMPTY_STRING) != null;
    }

    public boolean has(Object value) {
        return this.getEntry(value) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.list.size() == 0;
    }

    @Override
    public Iterator<OptionEntry> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean remove(Object value) {
        OptionEntry oe = this.getEntry(value);
        if (oe == null) {
            return false;
        }
        this.list.remove(this.getIndex(oe));
        return true;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{");
        boolean first = true;
        for (OptionEntry e : this.list) {
            b.append(first ? "\"" : ",\r\n \"");
            b.append(StringUtils.toString(e.getValue()));
            b.append("\":\"");
            b.append(e.getText());
            b.append("\":");
            b.append(e.isActive() ? "1" : "0");
            first = false;
        }
        b.append("}");
        return b.toString();
    }

    public void addXml(Element element, DataType dataType) {
        for (OptionEntry e : this.list) {
            Object value = e.getValue();
            if (value instanceof Enum) {
                value = ObjectUtils.getEnumValue((Enum)value, dataType.isNumeric());
            }
            Element opt = XMLUtil.addElement(element, "option", e.getText());
            opt.setAttribute("value", String.valueOf(value));
            if (e.isActive()) continue;
            opt.setAttribute("disabled", "true");
        }
    }

    private int findInsertPos(String text) {
        OptionEntry e;
        int i;
        for (i = 0; i < this.list.size() && text.compareToIgnoreCase((e = this.list.get(i)).getText()) > 0; ++i) {
        }
        return i;
    }

    public static enum InsertPos {
        Top,
        Bottom,
        Sort;

    }
}

