/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.EmpireException;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);

    private ClassUtils() {
    }

    public static <T> T testSerialization(Class<T> clazz, T objToSerialize) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(objToSerialize);
            ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            Object unserializedObject = oin.readObject();
            return (T)unserializedObject;
        }
        catch (IOException e) {
            log.error("Serialization failed: " + e.getMessage(), (Throwable)e);
            throw new InternalException(e);
        }
        catch (ClassNotFoundException e) {
            log.error("Class not Found: " + e.getMessage(), (Throwable)e);
            throw new InternalException(e);
        }
    }

    public static <T> T copy(T obj) {
        return ClassUtils.copy(obj, 32);
    }

    public static <T> T copy(T obj, int flags) {
        Constructor<?> ctor;
        if (obj == null) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isInterface() || clazz.isAnnotation()) {
            log.warn("Unable to copy Interface or Annotation {}", (Object)clazz.getName());
            return Copy.has(flags, 1) ? null : (T)obj;
        }
        if (clazz.isPrimitive() || clazz.isEnum()) {
            return obj;
        }
        if (obj instanceof Cloneable && !Copy.has(flags, 16)) {
            try {
                return (T)ClassUtils.invokeSimpleMethod(Object.class, obj, "clone", true);
            }
            catch (Exception e) {
                log.error("Copy through Cloning failed for : " + clazz.getName(), (Throwable)e);
            }
        }
        if (obj instanceof Serializable && !Copy.has(flags, 32)) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
                Object copy = oin.readObject();
                return (T)copy;
            }
            catch (IOException | ClassNotFoundException e) {
                log.error("Copy through Serialization failed for : " + clazz.getName(), (Throwable)e);
            }
        }
        Constructor<?> constructor = ctor = Copy.has(flags, 64) ? null : ClassUtils.findMatchingConstructor(clazz, 0, clazz);
        if (ctor != null) {
            try {
                if (ctor.getParameterCount() == 1) {
                    return (T)ctor.newInstance(obj);
                }
                Object copy = ctor.newInstance(new Object[0]);
                for (Class<?> cl = clazz; cl != null && cl != Object.class; cl = cl.getSuperclass()) {
                    Field[] fields;
                    for (Field field : fields = cl.getDeclaredFields()) {
                        boolean accessible = field.isAccessible();
                        if (!accessible) {
                            field.setAccessible(true);
                        }
                        Object value = field.get(obj);
                        if (!Copy.has(flags, 2)) {
                            value = ClassUtils.copy(value, flags & 0xFFFFFFFE | 2);
                        }
                        field.set(copy, value);
                        if (accessible) continue;
                        field.setAccessible(false);
                    }
                }
                return (T)copy;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                log.error("Copy through Instantiation failed for : " + clazz.getName(), (Throwable)e);
            }
        }
        return Copy.has(flags, 1) ? null : (T)obj;
    }

    public static synchronized Object getFieldValue(Class<?> clazz, Object object, String property, boolean includePrivateFields) {
        if (clazz == null || object != null && !clazz.isInstance(object)) {
            throw new InvalidArgumentException("clazz", clazz);
        }
        if (StringUtils.isEmpty(property)) {
            throw new InvalidArgumentException("property", property);
        }
        boolean accessible = true;
        Field field = null;
        try {
            field = includePrivateFields ? clazz.getDeclaredField(property) : clazz.getField(property);
            accessible = field.isAccessible();
            if (includePrivateFields && !accessible) {
                field.setAccessible(true);
            }
            Object object2 = field.get(object);
            return object2;
        }
        catch (NoSuchFieldException e) {
            if (includePrivateFields && (clazz = clazz.getSuperclass()) != null && !clazz.equals(Object.class)) {
                Object object3 = ClassUtils.getFieldValue(clazz, object, property, true);
                return object3;
            }
            Object var7_10 = null;
            return var7_10;
        }
        catch (IllegalAccessException e) {
            throw new NotSupportedException(object, property, e);
        }
        finally {
            if (field != null && !accessible) {
                field.setAccessible(false);
            }
        }
    }

    public static Object getFieldValue(Object object, String property) {
        if (object == null) {
            throw new InvalidArgumentException("object", object);
        }
        return ClassUtils.getFieldValue(object.getClass(), object, property, false);
    }

    public static Object getPrivateFieldValue(Object object, String property) {
        if (object == null) {
            throw new InvalidArgumentException("object", object);
        }
        return ClassUtils.getFieldValue(object.getClass(), object, property, true);
    }

    public static synchronized void setPrivateFieldValue(Class<?> clazz, Object object, String property, Object value) {
        try {
            Field field = clazz.getDeclaredField(property);
            field.setAccessible(true);
            field.set(object, value);
            field.setAccessible(false);
        }
        catch (Exception e) {
            log.error("Unable to modify private field '" + property + "* on class '" + clazz.getName() + "'", (Throwable)e);
            throw new InternalException(e);
        }
    }

    public static <T> Constructor<T> findMatchingConstructor(Class<T> clazz, int minParams, Class<?> ... parameterTypes) {
        int paramSize;
        int n = paramSize = parameterTypes != null ? parameterTypes.length : 0;
        if (minParams < 0 || minParams > paramSize) {
            minParams = paramSize;
        }
        Constructor<?>[] ctors = clazz.getConstructors();
        for (int pLen = paramSize; pLen >= minParams; --pLen) {
            int size = ctors.length;
            for (int i = 0; i < size; ++i) {
                Constructor ctor;
                if (ctors[i].getParameterCount() != pLen) continue;
                boolean match = true;
                if (pLen > 0) {
                    Class<?>[] ctorParams = ctors[i].getParameterTypes();
                    for (int n2 = 0; n2 < pLen; ++n2) {
                        if (ObjectUtils.isAssignmentCompatible(ctorParams[n2], parameterTypes[n2])) continue;
                        match = false;
                        break;
                    }
                }
                if (!match || (ctor = ConstructorUtils.getAccessibleConstructor(ctors[i])) == null) continue;
                try {
                    ctor.setAccessible(true);
                }
                catch (SecurityException n2) {
                    // empty catch block
                }
                Constructor typedCtor = ctor;
                return typedCtor;
            }
        }
        return null;
    }

    public static synchronized Object invokeSimpleMethod(Class<?> clazz, Object object, String methodName, boolean includePrivateMethods) {
        if (object == null) {
            throw new InvalidArgumentException("object", object);
        }
        if (clazz == null || !clazz.isInstance(object)) {
            throw new InvalidArgumentException("clazz", clazz);
        }
        if (StringUtils.isEmpty(methodName)) {
            throw new InvalidArgumentException("methodName", methodName);
        }
        boolean accessible = true;
        Method method = null;
        try {
            method = includePrivateMethods ? clazz.getDeclaredMethod(methodName, new Class[0]) : clazz.getMethod(methodName, new Class[0]);
            accessible = method.isAccessible();
            if (includePrivateMethods && !accessible) {
                method.setAccessible(true);
            }
            Object object2 = method.invoke(object, new Object[0]);
            return object2;
        }
        catch (NoSuchMethodException e) {
            if (includePrivateMethods && (clazz = clazz.getSuperclass()) != null && !clazz.equals(Object.class)) {
                Object object3 = ClassUtils.invokeSimpleMethod(clazz, object, methodName, true);
                return object3;
            }
            Object var7_13 = null;
            return var7_13;
        }
        catch (SecurityException e) {
            throw new NotSupportedException(object, methodName, e);
        }
        catch (IllegalAccessException e) {
            throw new NotSupportedException(object, methodName, e);
        }
        catch (IllegalArgumentException e) {
            throw new NotSupportedException(object, methodName, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EmpireException) {
                throw (EmpireException)cause;
            }
            throw new InternalException(cause);
        }
        finally {
            if (method != null && !accessible) {
                method.setAccessible(false);
            }
        }
    }

    public static Object invokeSimpleMethod(Object object, String methodName) {
        if (object == null) {
            throw new InvalidArgumentException("object", object);
        }
        return ClassUtils.invokeSimpleMethod(object.getClass(), object, methodName, false);
    }

    public static Object invokeSimplePrivateMethod(Object object, String methodName) {
        if (object == null) {
            throw new InvalidArgumentException("object", object);
        }
        return ClassUtils.invokeSimpleMethod(object.getClass(), object, methodName, true);
    }

    public static class Copy {
        public static final int RET_SELF = 0;
        public static final int RET_NULL = 1;
        public static final int RECURSE_SHALLOW = 2;
        public static final int SKIP_CLONE = 16;
        public static final int SKIP_SERIAL = 32;
        public static final int SKIP_INST = 64;

        public static boolean has(int flags, int flag) {
            return (flags & flag) != 0;
        }
    }
}

