/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pageelements;

import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.exceptions.EmpireException;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.jsf2.pages.Page;
import org.apache.empire.jsf2.pages.PageDefinition;
import org.apache.empire.jsf2.pages.PageElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordPageElement<T extends DBRecord>
extends PageElement {
    private static final Logger log = LoggerFactory.getLogger(RecordPageElement.class);
    protected DBRowSet rowset;
    protected T record;

    public RecordPageElement(Page page, DBRowSet rowset, T record, String propertyName) {
        super(page, propertyName);
        this.rowset = rowset;
        this.record = record;
        log.debug("RecordPageSupport for {} created.", (Object)rowset.getName());
    }

    public RecordPageElement(Page page, DBRowSet rowset, T record) {
        this(page, rowset, record, RecordPageElement.getDefaultPropertyName(rowset));
    }

    public T getRecord() {
        return this.record;
    }

    public DBRowSet getRowSet() {
        return this.record.getRowSet();
    }

    public String getRecordIdParam() {
        if (!this.record.isValid()) {
            return null;
        }
        Object[] key = this.record.getKey();
        return this.getPage().getIdParamForKey(this.rowset, key);
    }

    @Override
    protected void onInitPage() {
        if (!this.record.isValid()) {
            this.reloadRecord();
        }
    }

    public boolean canReloadRecord(boolean newRecord) {
        if (newRecord) {
            return this.getSessionObject(DBRecord.class) != null;
        }
        return this.getSessionObject(Object[].class) != null;
    }

    public void reloadRecord() {
        Object[] recKey = this.getSessionObject(Object[].class);
        if (recKey == null || recKey.length == 0) {
            DBRecord rec = this.getSessionObject(DBRecord.class);
            if (rec != null) {
                this.record = rec;
                return;
            }
            throw new ObjectNotValidException(this.record);
        }
        this.record.read(recKey);
    }

    public void loadRecord(Object[] recKey) {
        if (recKey == null || recKey.length == 0) {
            throw new InvalidArgumentException("recKey", recKey);
        }
        this.removeSessionObject(DBRecord.class);
        this.setSessionObject(Object[].class, recKey);
        this.record.read(recKey);
    }

    public void loadRecord(String idParam) {
        Object[] key = this.getPage().getKeyFromParam(this.rowset, idParam);
        this.loadRecord(key);
    }

    public void loadRecord(PageDefinition page, String idParam) {
        Object[] key = this.getPage().getKeyFromParam(page, this.rowset, idParam);
        this.loadRecord(key);
    }

    public void createRecord() {
        this.record.create();
        this.removeSessionObject(Object[].class);
        this.setSessionObject(DBRecord.class, this.record);
    }

    public boolean updateRecord() {
        try {
            if (!this.record.isValid()) {
                throw new ObjectNotValidException(this.record);
            }
            if (!this.record.isModified()) {
                return true;
            }
            this.record.update();
            this.removeSessionObject(DBRecord.class);
            this.setSessionObject(Object[].class, this.record.getKey());
            return true;
        }
        catch (Exception e2) {
            InternalException e2;
            if (!(e2 instanceof EmpireException)) {
                e2 = new InternalException((Throwable)e2);
            }
            this.getPage().setErrorMessage((Throwable)e2);
            return false;
        }
    }

    public void deleteRecord() {
        if (!this.record.isValid()) {
            throw new ObjectNotValidException(this.record);
        }
        this.record.delete();
        this.removeSessionObject(Object[].class);
        this.removeSessionObject(DBRecord.class);
    }

    public void closeRecord() {
        this.record.close();
        this.removeSessionObject(Object[].class);
        this.removeSessionObject(DBRecord.class);
    }
}

