/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.ClassUtils;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.context.DBContextBase;
import org.apache.empire.db.context.DBRollbackManager;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.jsf2.app.WebApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDBContext<DB extends DBDatabase>
extends DBContextBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(WebDBContext.class);
    protected final transient WebApplication app = WebApplication.getInstance();
    protected final transient DB database;
    protected final transient DBMSHandler dbms;

    private void writeObject(ObjectOutputStream strm) throws IOException {
        strm.writeObject(this.database != null ? this.database.getIdentifier() : "");
        strm.defaultWriteObject();
    }

    private void readObject(ObjectInputStream strm) throws IOException, ClassNotFoundException {
        Object app = WebApplication.getInstance();
        ClassUtils.setPrivateFieldValue(WebDBContext.class, (Object)this, (String)"app", app);
        String dbid = String.valueOf(strm.readObject());
        DBDatabase database = DBDatabase.findByIdentifier((String)dbid);
        if (database == null) {
            throw new ItemNotFoundException((Object)dbid);
        }
        ClassUtils.setPrivateFieldValue(WebDBContext.class, (Object)this, (String)"database", (Object)database);
        ClassUtils.setPrivateFieldValue(WebDBContext.class, (Object)this, (String)"dbms", (Object)database.getDbms());
        strm.defaultReadObject();
    }

    public WebDBContext(DB db) {
        this.dbms = db.getDbms();
        this.database = db;
        if (db.getDbms() == null) {
            log.warn("Database {} has no dbms attached.", (Object)db.getClass().getSimpleName());
        }
    }

    public DB getDatabase() {
        return this.database;
    }

    public DBMSHandler getDbms() {
        return this.dbms;
    }

    public boolean isPreparedStatementsEnabled() {
        return this.database.isPreparedStatementsEnabled();
    }

    public boolean isRollbackHandlingEnabled() {
        return true;
    }

    public void discard() {
    }

    protected Connection getConnection(boolean create) {
        return this.app.getConnectionForRequest(this.getFacesContext(), (DBDatabase)this.database, create);
    }

    protected DBRollbackManager getRollbackManager(boolean create) {
        return this.app.getRollbackManagerForRequest(this.getFacesContext(), create);
    }

    public FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }
}

