/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import java.beans.FeatureDescriptor;
import java.lang.reflect.Field;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.RecordData;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBELResolver
extends ELResolver {
    private static final Logger log = LoggerFactory.getLogger(DBELResolver.class);

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            log.warn("DBELResolver:getCommonPropertyType is not implemented!");
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base instanceof DBRowSet || base instanceof DBDatabase || base == null && property.equals("db")) {
            log.warn("DBELResolver:getType is not implemented!");
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext arg0, Object arg1) {
        log.warn("DBELResolver:getFeatureDescriptors is not implemented!");
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base instanceof DBRowSet) {
            String name = StringUtils.toString((Object)property);
            DBColumn column = ((DBRowSet)base).getColumn(name);
            if (column == null) {
                column = DBELResolver.findExpressionField(base, name);
            }
            if (column != null) {
                context.setPropertyResolved(true);
            } else {
                log.error("ELResolver error: Column '{}' cannot be resolved for table/view '{}'.", (Object)name.toUpperCase(), (Object)((DBRowSet)base).getName());
            }
            return column;
        }
        if (base instanceof DBDatabase) {
            String name = StringUtils.toString((Object)property);
            DBRowSet rset = ((DBDatabase)base).getRowSet(name);
            if (rset != null) {
                context.setPropertyResolved(true);
            } else {
                log.error("ELResolver error: Table/View '{}' cannot be resolved.", (Object)name.toUpperCase());
            }
            return rset;
        }
        if (base instanceof RecordData) {
            String field = StringUtils.toString((Object)property);
            if (field == null || field.length() == 0 || field.charAt(0) < 'A' || field.charAt(0) > 'Z') {
                return null;
            }
            int index = ((RecordData)base).getFieldIndex(field);
            if (index < 0) {
                log.warn("ELResolver warning: field '{}' not found in record .", (Object)field);
                return null;
            }
            context.setPropertyResolved(true);
            return ((RecordData)base).getValue(index);
        }
        if (base == null) {
            String name = StringUtils.toString((Object)property);
            DBDatabase db = DBDatabase.findByIdentifier((String)name);
            if (db != null) {
                context.setPropertyResolved(true);
            }
            return db;
        }
        return null;
    }

    public static DBColumnExpr findExpressionField(Object rowset, String property) {
        Class<?> c = rowset.getClass();
        try {
            Field f = c.getField(property);
            if (f == null) {
                return null;
            }
            Object v = f.get(rowset);
            if (v == null) {
                log.error("ELResolver error: Field '{}.{}' is null.", (Object)c.getSimpleName(), (Object)property);
                return null;
            }
            if (!(v instanceof DBColumnExpr)) {
                log.error("ELResolver error: Field '{}.{}' is not a DBColumnExpr.", (Object)c.getSimpleName(), (Object)property);
                return null;
            }
            return (DBColumnExpr)v;
        }
        catch (SecurityException e) {
            log.error("ELResolver error: Unable to access field " + c.getSimpleName() + "." + property, (Throwable)e);
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            log.error("ELResolver error: Unable to access field " + c.getSimpleName() + "." + property, (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            log.error("ELResolver error: Unable to access field " + c.getSimpleName() + "." + property, (Throwable)e);
            return null;
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base instanceof DBRowSet || base instanceof DBDatabase || base == null && property.equals("db")) {
            log.info("ELResolver: property {} is read only.", property);
            return true;
        }
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (this.isReadOnly(context, base, property)) {
            NotSupportedException e = new NotSupportedException((Object)this, "setValue");
            FacesContext.getCurrentInstance().getExternalContext().log(e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

