/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.view.AttachedObjectHandler;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.db.DBRecordBase;
import org.apache.empire.db.exceptions.FieldIllegalValueException;
import org.apache.empire.exceptions.EmpireException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagEncodingHelperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputTag
extends UIInput
implements NamingContainer {
    private static final Logger log = LoggerFactory.getLogger(InputTag.class);
    protected static final String readOnlyState = "readOnlyState";
    protected final TagEncodingHelper helper = TagEncodingHelperFactory.create((UIOutput)this, "eInput");
    protected InputControl control = null;
    protected InputControl.InputInfo inpInfo = null;
    protected boolean hasRequiredFlagSet = false;
    private String treeClientId = null;

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    protected void saveState() {
        this.getStateHelper().put((Serializable)((Object)readOnlyState), (Object)(this.inpInfo == null ? 1 : 0));
    }

    protected boolean initState(FacesContext context) {
        this.helper.prepareData();
        if (!this.helper.isVisible()) {
            return false;
        }
        Boolean ros = (Boolean)this.getStateHelper().get((Serializable)((Object)readOnlyState));
        if (ros != null && ros.booleanValue()) {
            return false;
        }
        if (this.getChildCount() == 0) {
            log.warn("InputTag '{}' has no children. encodeBegin may not have been called yet.", (Object)this.getClientId());
            return false;
        }
        this.control = this.helper.getInputControl();
        this.inpInfo = this.helper.getInputInfo(context);
        return this.control != null && this.inpInfo != null;
    }

    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        FacesContext context = visitContext.getFacesContext();
        this.treeClientId = this.getClientId(context);
        return super.visitTree(visitContext, callback);
    }

    public String getClientId(FacesContext context) {
        if (this.treeClientId != null && this.control != null && this.control.isCreatingComponents()) {
            return this.treeClientId;
        }
        return super.getClientId(context);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.helper.encodeBegin();
        if (!this.helper.isVisible()) {
            this.setRendered(false);
            Column column = this.helper.getColumn();
            if (column == null) {
                throw new InvalidArgumentException("column", null);
            }
            Object record = this.helper.getRecord();
            if (record != null && record instanceof DBRecordBase && ((DBRecordBase)record).isValid()) {
                if (((DBRecordBase)record).getFieldIndex((ColumnExpr)column) < 0) {
                    throw new InvalidArgumentException("column", (Object)column.getName());
                }
                log.info("Column {} is not visible for record of {} and will not be rendered!", (Object)column.getName(), (Object)((DBRecordBase)record).getRowSet().getName());
            } else {
                log.warn("Invalid Record provided for column {}. Input will not be rendered!", (Object)column.getName());
            }
            return;
        }
        this.control = this.helper.getInputControl();
        this.inpInfo = this.helper.getInputInfo(context);
        if (!this.hasRequiredFlagSet) {
            super.setRequired(this.helper.isValueRequired());
        }
        if (this.getChildCount() == 0) {
            this.control.createInput((UIComponent)this, this.inpInfo, context);
            this.attachEvents(context);
        } else {
            this.control.updateInputState((UIComponent)this, this.inpInfo, context, context.getCurrentPhaseId());
        }
        boolean renderValue = this.helper.isRenderValueComponent();
        this.setRenderInput(!renderValue);
        if (renderValue) {
            String tagName = "span";
            String styleClass = this.helper.getTagStyleClass("eInpDis");
            String tooltip = this.helper.getValueTooltip(this.helper.getTagAttributeValue("title"));
            this.control.renderValue((UIComponent)this, tagName, styleClass, tooltip, this.inpInfo, context);
        } else {
            this.control.renderInput((UIComponent)this, this.inpInfo, context);
        }
        this.saveState();
    }

    public void setId(String id) {
        id = this.helper.completeInputTagId(id);
        super.setId(id);
    }

    public String getId() {
        String compId = super.getId();
        if ("null".equals(compId)) {
            compId = this.helper.completeInputTagId(null);
        }
        return compId;
    }

    public void setRequired(boolean required) {
        super.setRequired(required);
        this.hasRequiredFlagSet = true;
    }

    public Object getValue() {
        if (this.helper.getRecord() != null) {
            return this.helper.getDataValue(true);
        }
        Object value = super.getValue();
        return value;
    }

    public Object getSubmittedValue() {
        if (this.control == null || this.inpInfo == null || this.helper.isReadOnly()) {
            return null;
        }
        return this.control.getInputValue((UIComponent)this, this.inpInfo, true);
    }

    protected Object getConvertedValue(FacesContext context, Object newSubmittedValue) throws ConverterException {
        if (this.control == null || this.inpInfo == null || this.helper.isReadOnly()) {
            return null;
        }
        return this.control.getConvertedValue((UIComponent)this, this.inpInfo, newSubmittedValue);
    }

    public void processDecodes(FacesContext context) {
        if (this.helper.isInsideUIData() && this.getChildCount() > 0) {
            this.updateControlInputState(context);
            boolean readOnly = this.helper.isRecordReadOnly();
            this.setRenderInput(!readOnly);
        }
        super.processDecodes(context);
    }

    public void processValidators(FacesContext context) {
        if (this.helper.isInsideUIData() && this.getChildCount() > 0) {
            this.updateControlInputState(context);
        }
        super.processValidators(context);
    }

    public void validate(FacesContext context) {
        if (!this.initState(context)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating input for {}.", (Object)this.inpInfo.getColumn().getName());
        }
        try {
            super.validate(context);
        }
        catch (Exception e2) {
            FieldIllegalValueException e2;
            if (!(e2 instanceof EmpireException)) {
                e2 = new FieldIllegalValueException(this.helper.getColumn(), "", (Throwable)e2);
            }
            this.helper.addErrorMessage(context, (Exception)e2);
            this.setValid(false);
        }
    }

    public void validateValue(FacesContext context, Object value) {
        if (this.inpInfo == null) {
            return;
        }
        if (UIInput.isEmpty((Object)value) && this.isPartialSubmit(context)) {
            log.debug("Skipping validation for {} due to Null value.", (Object)this.inpInfo.getColumn().getName());
            return;
        }
        this.inpInfo.validate(value);
        this.setValid(true);
    }

    public void updateModel(FacesContext context) {
        if (!this.initState(context)) {
            return;
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        Object value = this.getLocalValue();
        if (UIInput.isEmpty((Object)value) && this.isPartialSubmit(context) && !this.helper.isTempoaryNullable()) {
            log.debug("Skipping model update for {} due to Null value.", (Object)this.inpInfo.getColumn().getName());
            return;
        }
        log.debug("Updating model input for {}.", (Object)this.inpInfo.getColumn().getName());
        this.inpInfo.setValue(value);
        this.setValue(null);
        this.setLocalValueSet(false);
        this.control.postUpdateModel((UIComponent)this, this.inpInfo, context);
    }

    public Column getInputColumn() {
        return this.helper.getColumn();
    }

    public boolean isInputReadOnly() {
        return this.helper.isRecordReadOnly();
    }

    public boolean isInputRequired() {
        return this.helper.isValueRequired();
    }

    protected void updateControlInputState(FacesContext context) {
        this.helper.prepareData();
        if (this.control == null) {
            this.control = this.helper.getInputControl();
        }
        if (this.inpInfo == null) {
            this.inpInfo = this.helper.getInputInfo(context);
        }
        this.control.updateInputState((UIComponent)this, this.inpInfo, context, context.getCurrentPhaseId());
    }

    protected void setRenderInput(boolean renderInput) {
        for (UIComponent child : this.getChildren()) {
            if (child.isRendered() == renderInput) continue;
            if (log.isDebugEnabled()) {
                log.debug("Changing UIInput rendered state for {} to {}", (Object)this.helper.getColumnName(), (Object)renderInput);
            }
            child.setRendered(renderInput);
        }
    }

    protected boolean isPartialSubmit(FacesContext context) {
        if (this.hasRequiredFlagSet && !this.isRequired()) {
            return true;
        }
        return this.helper.isPartialSubmit(context);
    }

    protected void attachEvents(FacesContext context) {
        List result = (List)this.getAttributes().get("javax.faces.RetargetableHandlers");
        if (result == null) {
            return;
        }
        UIInput inputComponent = null;
        for (UIComponent c : this.getChildren()) {
            if (!(c instanceof UIInput)) continue;
            inputComponent = (UIInput)c;
            break;
        }
        if (inputComponent == null) {
            return;
        }
        for (AttachedObjectHandler aoh : result) {
            aoh.applyAttachedObject(context, (UIComponent)inputComponent);
        }
        result.clear();
        this.getAttributes().remove("javax.faces.RetargetableHandlers");
    }
}

