/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.oracle;

import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.dbms.oracle.DBMSHandlerOracle;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class OracleRowNumExpr
extends DBColumnExpr {
    private static final Logger log = LoggerFactory.getLogger(OracleRowNumExpr.class);
    public final DBDatabase db;

    public OracleRowNumExpr(DBDatabase db) {
        this.db = db;
    }

    public final DBDatabase getDatabase() {
        return this.db;
    }

    @Override
    public DataType getDataType() {
        return DataType.INTEGER;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return null;
    }

    @Override
    public String getName() {
        return "rownum";
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.getName());
        elem.setAttribute("function", "rownum");
        return elem;
    }

    @Override
    public DBColumn getSourceColumn() {
        return null;
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        if (!(this.db.getDbms() instanceof DBMSHandlerOracle)) {
            log.warn("Oracle RowNumExpression can be used with Oracle databases only!");
        }
        buf.append("rownum");
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }

    public boolean equals(Object other) {
        return other instanceof OracleRowNumExpr;
    }
}

