/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.mysql;

import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBCombinedCmd;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.DBView;
import org.apache.empire.dbms.DBMSHandlerBase;
import org.apache.empire.dbms.mysql.DBMSHandlerMySQL;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLDDLGenerator
extends DBDDLGenerator<DBMSHandlerMySQL> {
    private static final Logger log = LoggerFactory.getLogger(MySQLDDLGenerator.class);
    protected String DATATYPE_INT_TINY = "TINYINT";
    protected String DATATYPE_INT_MEDIUM = "MEDIUMINT";

    public MySQLDDLGenerator(DBMSHandlerMySQL dbms) {
        super(dbms);
        this.alterColumnPhrase = " MODIFY ";
        this.initDataTypes();
    }

    private void initDataTypes() {
        this.DATATYPE_TIMESTAMP = "DATETIME";
        this.DATATYPE_CLOB = "LONGTEXT";
    }

    @Override
    protected boolean appendColumnDataType(DataType type, double size, DBTableColumn c, StringBuilder sql) {
        switch (type) {
            case AUTOINC: {
                super.appendColumnDataType(type, size, c, sql);
                if (((DBMSHandlerMySQL)this.dbms).isUseSequenceTable()) break;
                sql.append(" AUTO_INCREMENT");
                break;
            }
            case INTEGER: {
                int bytes = Math.abs((int)size);
                if (bytes > 0 && bytes <= 1) {
                    sql.append(this.DATATYPE_INT_TINY);
                    break;
                }
                if (bytes > 0 && bytes <= 2) {
                    sql.append(this.DATATYPE_INT_SMALL);
                    break;
                }
                if (bytes > 0 && bytes <= 3) {
                    sql.append(this.DATATYPE_INT_MEDIUM);
                    break;
                }
                if (bytes > 0 && bytes <= 4) {
                    sql.append(this.DATATYPE_INTEGER);
                    break;
                }
                if (bytes > 0 && bytes <= 8) {
                    sql.append(this.DATATYPE_INT_BIG);
                    break;
                }
                sql.append(this.DATATYPE_INTEGER);
                break;
            }
            default: {
                return super.appendColumnDataType(type, size, c, sql);
            }
        }
        return true;
    }

    @Override
    protected void createDatabase(DBDatabase db, DBSQLScript script) {
        String databaseName = ((DBMSHandlerMySQL)this.dbms).getDatabaseName();
        if (StringUtils.isNotEmpty(databaseName)) {
            script.addStmt("CREATE DATABASE IF NOT EXISTS " + databaseName + " CHARACTER SET " + ((DBMSHandlerMySQL)this.dbms).getCharacterSet());
            script.addStmt("USE " + databaseName);
            if (((DBMSHandlerMySQL)this.dbms).isUseSequenceTable() && db.getTable(((DBMSHandlerMySQL)this.dbms).getSequenceTableName()) == null) {
                new DBMSHandlerBase.DBSeqTable(((DBMSHandlerMySQL)this.dbms).getSequenceTableName(), db);
            }
        }
        super.createDatabase(db, script);
    }

    @Override
    protected void createTable(DBTable t, DBSQLScript script) {
        StringBuilder sql = new StringBuilder();
        sql.append("-- creating table ");
        sql.append(t.getName());
        sql.append(" --\r\n");
        sql.append("CREATE TABLE ");
        t.addSQL(sql, 2L);
        sql.append(" (");
        boolean addSeparator = false;
        for (DBTableColumn dBTableColumn : t.getColumns()) {
            sql.append(addSeparator ? ",\r\n   " : "\r\n   ");
            this.appendColumnDesc(dBTableColumn, false, sql);
            addSeparator = true;
        }
        DBIndex dBIndex = t.getPrimaryKey();
        if (dBIndex != null) {
            sql.append(",\r\n PRIMARY KEY (");
            addSeparator = false;
            DBColumn[] keyColumns = dBIndex.getColumns();
            for (int i = 0; i < keyColumns.length; ++i) {
                sql.append(addSeparator ? ", " : "");
                keyColumns[i].addSQL(sql, 1L);
                addSeparator = true;
            }
            sql.append(")");
        }
        sql.append(")");
        addSeparator = false;
        if (StringUtils.isNotEmpty(((DBMSHandlerMySQL)this.dbms).getEngine())) {
            sql.append("\r\n ENGINE = ");
            sql.append(((DBMSHandlerMySQL)this.dbms).getEngine());
            addSeparator = true;
        }
        if (StringUtils.isNotEmpty(t.getComment())) {
            if (addSeparator) {
                sql.append(",");
            }
            sql.append("\r\n COMMENT = '");
            sql.append(t.getComment());
            sql.append("'");
        }
        this.addCreateTableStmt(t, sql, script);
        this.createTableIndexes(t, dBIndex, script);
    }

    @Override
    protected void createView(DBView v, DBSQLScript script) {
        DBCommandExpr cmd = v.createCommand();
        if (cmd == null) {
            log.error("No command has been supplied for view " + v.getName());
            throw new NotSupportedException(this, v.getName() + ".createCommand");
        }
        cmd.clearOrderBy();
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE VIEW ");
        v.addSQL(sql, 2L);
        sql.append(" (");
        boolean addSeparator = false;
        for (DBColumn c : v.getColumns()) {
            if (addSeparator) {
                sql.append(", ");
            }
            c.addSQL(sql, 1L);
            addSeparator = true;
        }
        sql.append(")\r\nAS\r\n");
        if (cmd instanceof DBCombinedCmd) {
            sql.append(cmd.getSelect());
        } else {
            cmd.addSQL(sql, 7L);
        }
        this.addCreateViewStmt(v, sql, script);
    }
}

