/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.hsql;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.exceptions.QueryNoResultException;
import org.apache.empire.db.validation.DBModelChecker;
import org.apache.empire.dbms.DBMSFeature;
import org.apache.empire.dbms.DBMSHandlerBase;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.dbms.hsql.DBCommandHSql;
import org.apache.empire.dbms.hsql.HSqlDDLGenerator;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMSHandlerHSql
extends DBMSHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(DBMSHandlerHSql.class);
    private DBDDLGenerator<?> ddlGenerator = null;

    public DBMSHandlerHSql() {
        this.reservedSQLKeywords.add("count");
    }

    @Override
    public boolean isSupported(DBMSFeature type) {
        switch (type) {
            case CREATE_SCHEMA: {
                return false;
            }
            case SEQUENCES: {
                return true;
            }
            case QUERY_LIMIT_ROWS: {
                return true;
            }
            case QUERY_SKIP_ROWS: {
                return true;
            }
        }
        return false;
    }

    @Override
    public DBCommand createCommand(boolean autoPrepareStmt) {
        return new DBCommandHSql(autoPrepareStmt);
    }

    @Override
    public String getSQLPhrase(DBSqlPhrase phrase) {
        switch (phrase) {
            case SQL_NULL: {
                return "null";
            }
            case SQL_PARAMETER: {
                return " ? ";
            }
            case SQL_RENAME_TABLE: {
                return " ";
            }
            case SQL_RENAME_COLUMN: {
                return " AS ";
            }
            case SQL_DATABASE_LINK: {
                return "@";
            }
            case SQL_QUOTES_OPEN: {
                return "\"";
            }
            case SQL_QUOTES_CLOSE: {
                return "\"";
            }
            case SQL_CONCAT_EXPR: {
                return "concat(?, {0})";
            }
            case SQL_BOOLEAN_TRUE: {
                return String.valueOf(Boolean.TRUE);
            }
            case SQL_BOOLEAN_FALSE: {
                return String.valueOf(Boolean.FALSE);
            }
            case SQL_CURRENT_DATE: {
                return "CURRENT_DATE";
            }
            case SQL_DATE_PATTERN: {
                return "yyyy-MM-dd";
            }
            case SQL_DATE_TEMPLATE: {
                return "TO_DATE('{0}', 'YYYY-MM-DD')";
            }
            case SQL_CURRENT_TIME: {
                return "CURRENT_TIME";
            }
            case SQL_TIME_PATTERN: {
                return "HH:mm:ss";
            }
            case SQL_TIME_TEMPLATE: {
                return "'{0}'";
            }
            case SQL_DATETIME_PATTERN: {
                return "yyyy-MM-dd HH:mm:ss.S";
            }
            case SQL_DATETIME_TEMPLATE: {
                return "TO_DATE('{0}', 'YYYY-MM-DD HH24:MI:SS')";
            }
            case SQL_CURRENT_TIMESTAMP: {
                return "CURRENT_TIMESTAMP";
            }
            case SQL_TIMESTAMP_PATTERN: {
                return "yyyy-MM-dd HH:mm:ss.S";
            }
            case SQL_TIMESTAMP_TEMPLATE: {
                return "TO_TIMESTAMP('{0}', 'YYYY-MM-DD HH24:MI:SS.FF')";
            }
            case SQL_FUNC_COALESCE: {
                return "coalesce(?, {0})";
            }
            case SQL_FUNC_SUBSTRING: {
                return "substr(?, {0})";
            }
            case SQL_FUNC_SUBSTRINGEX: {
                return "substr(?, {0}, {1})";
            }
            case SQL_FUNC_REPLACE: {
                return "replace(?, {0}, {1})";
            }
            case SQL_FUNC_REVERSE: {
                return "?";
            }
            case SQL_FUNC_STRINDEX: {
                return "locate({0}, ?)";
            }
            case SQL_FUNC_STRINDEXFROM: {
                return "locate({0}, ?, {1})";
            }
            case SQL_FUNC_UPPER: {
                return "ucase(?)";
            }
            case SQL_FUNC_LOWER: {
                return "lcase(?)";
            }
            case SQL_FUNC_LENGTH: {
                return "length(?)";
            }
            case SQL_FUNC_TRIM: {
                return "trim(?)";
            }
            case SQL_FUNC_LTRIM: {
                return "ltrim(?)";
            }
            case SQL_FUNC_RTRIM: {
                return "rtrim(?)";
            }
            case SQL_FUNC_ESCAPE: {
                return "? escape {0:VARCHAR}";
            }
            case SQL_FUNC_ABS: {
                return "abs(?)";
            }
            case SQL_FUNC_ROUND: {
                return "round(?,{0})";
            }
            case SQL_FUNC_TRUNC: {
                return "truncate(?,{0})";
            }
            case SQL_FUNC_CEILING: {
                return "ceiling(?)";
            }
            case SQL_FUNC_FLOOR: {
                return "floor(?)";
            }
            case SQL_FUNC_MOD: {
                return "mod(?,{0})";
            }
            case SQL_FUNC_FORMAT: {
                return "TO_CHAR(?, {0:VARCHAR})";
            }
            case SQL_FUNC_DAY: {
                return "day(?)";
            }
            case SQL_FUNC_MONTH: {
                return "month(?)";
            }
            case SQL_FUNC_YEAR: {
                return "year(?)";
            }
            case SQL_FUNC_SUM: {
                return "sum(?)";
            }
            case SQL_FUNC_MAX: {
                return "max(?)";
            }
            case SQL_FUNC_MIN: {
                return "min(?)";
            }
            case SQL_FUNC_AVG: {
                return "avg(?)";
            }
            case SQL_FUNC_STRAGG: {
                return "GROUP_CONCAT(DISTINCT ? ORDER BY {1} SEPARATOR {0})";
            }
            case SQL_FUNC_DECODE: {
                return "case ?{0} end";
            }
            case SQL_FUNC_DECODE_SEP: {
                return " ";
            }
            case SQL_FUNC_DECODE_PART: {
                return "when {0} then {1}";
            }
            case SQL_FUNC_DECODE_ELSE: {
                return "else {0}";
            }
        }
        return phrase.getSqlDefault();
    }

    @Override
    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case VARCHAR: 
            case CHAR: {
                if (format instanceof String) {
                    if (srcType == DataType.INTEGER || srcType == DataType.AUTOINC) {
                        log.error("getConvertPhrase: unknown type " + (Object)((Object)destType));
                        return "?";
                    }
                    return "to_char(?, '" + format.toString() + "')";
                }
                if (format instanceof Number) {
                    int size = ((Number)format).intValue();
                    return "convert(?, " + destType.name() + "(" + String.valueOf(size) + "))";
                }
                return "convert(?, " + destType.name() + "(255))";
            }
            case INTEGER: {
                return "convert(?, BIGINT)";
            }
            case DECIMAL: {
                return "convert(?, DECIMAL)";
            }
            case FLOAT: {
                return "convert(?, DOUBLE)";
            }
        }
        log.error("getConvertPhrase: unknown type (" + String.valueOf((Object)destType));
        return "?";
    }

    @Override
    public Object getNextSequenceValue(DBDatabase db, String seqName, int minValue, Connection conn) {
        Object val;
        StringBuilder sql = new StringBuilder(80);
        sql.append("SELECT ");
        sql.append("NEXT VALUE FOR ");
        db.appendQualifiedName(sql, seqName, null);
        sql.append(" FROM INFORMATION_SCHEMA.SYSTEM_SEQUENCES WHERE SEQUENCE_NAME='").append(seqName).append("'");
        String sqlCmd = sql.toString();
        if (log.isDebugEnabled()) {
            log.debug("Executing: " + sqlCmd);
        }
        if (ObjectUtils.isEmpty(val = this.querySingleValue(sqlCmd, null, DataType.INTEGER, conn))) {
            log.error("getNextSequenceValue: Invalid sequence value for sequence " + seqName);
            throw new QueryNoResultException(sqlCmd);
        }
        return val;
    }

    @Override
    public DBColumnExpr getNextSequenceValueExpr(DBTableColumn column) {
        throw new NotSupportedException(this, "getNextSequenceValueExpr");
    }

    @Override
    public Timestamp getUpdateTimestamp(Connection conn) {
        GregorianCalendar cal = new GregorianCalendar();
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public void getDDLScript(DBDDLGenerator.DDLActionType type, DBObject dbo, DBSQLScript script) {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new HSqlDDLGenerator(this);
        }
        this.ddlGenerator.getDDLScript(type, dbo, script);
    }

    @Override
    public DBModelChecker createModelChecker(DBDatabase db) {
        return new DBModelChecker(this.createModelParser("PUBLIC", "PUBLIC"));
    }
}

