/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.hsql;

import java.util.ArrayList;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.expr.column.DBAliasExpr;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.db.expr.set.DBSetExpr;

public class DBCommandHSql
extends DBCommand {
    protected int limitRows = -1;
    protected int skipRows = 0;

    public DBCommandHSql(boolean autoPrepareStmt) {
        super(autoPrepareStmt);
    }

    @Override
    public DBCommandHSql limitRows(int limitRows) {
        this.limitRows = limitRows;
        return this;
    }

    @Override
    public DBCommandHSql skipRows(int skipRows) {
        this.skipRows = skipRows;
        return this;
    }

    @Override
    public void clearLimit() {
        this.limitRows = -1;
        this.skipRows = 0;
    }

    @Override
    public void getSelect(StringBuilder buf) {
        super.getSelect(buf);
        if (this.limitRows >= 0) {
            buf.append("\r\nLIMIT ");
            buf.append(String.valueOf(this.limitRows));
            if (this.skipRows > 0) {
                buf.append(" OFFSET ");
                buf.append(String.valueOf(this.skipRows));
            }
        }
    }

    @Override
    protected void addUpdateWithJoins(StringBuilder buf, DBRowSet table) {
        DBColumn[] keyColumns = table.getKeyColumns();
        if (keyColumns == null || keyColumns.length == 0) {
            throw new NoPrimaryKeyException(table);
        }
        buf.setLength(0);
        buf.append("MERGE INTO ");
        table.addSQL(buf, 10L);
        buf.append("\r\nUSING (");
        ArrayList<DBColumnExpr> using = new ArrayList<DBColumnExpr>();
        for (DBColumn col : keyColumns) {
            using.add(col);
        }
        ArrayList<DBSetExpr> mergeSet = new ArrayList<DBSetExpr>(this.set.size());
        for (DBSetExpr sex : this.set) {
            Object val = sex.getValue();
            if (val instanceof DBColumnExpr) {
                DBColumnExpr expr = (DBColumnExpr)val;
                if (!(expr instanceof DBColumn) && !(expr instanceof DBAliasExpr)) {
                    String name = "COL_" + String.valueOf(mergeSet.size());
                    expr = expr.as(name);
                }
                using.add(expr);
                DBValueExpr NAME_EXPR = this.getDatabase().getValueExpr("q0." + expr.getName(), DataType.UNKNOWN);
                mergeSet.add(sex.getColumn().to(NAME_EXPR));
                continue;
            }
            mergeSet.add(sex);
        }
        buf.append("SELECT ");
        this.addListExpr(buf, using, 15L, ", ");
        this.addFrom(buf);
        this.addWhere(buf);
        this.addGrouping(buf);
        buf.append(") q0\r\nON (");
        for (DBColumn col : keyColumns) {
            buf.append(" q0.");
            col.addSQL(buf, 1L);
            buf.append("=");
            buf.append(table.getAlias());
            buf.append(".");
            col.addSQL(buf, 1L);
        }
        buf.append(")\r\nWHEN MATCHED THEN UPDATE ");
        buf.append("\r\nSET ");
        this.addListExpr(buf, mergeSet, 7L, ", ");
    }
}

