/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.empire.commons.DateUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBBlobData;
import org.apache.empire.db.DBClobData;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCombinedCmd;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.exceptions.EmpireSQLException;
import org.apache.empire.db.exceptions.QueryFailedException;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.validation.DBModelChecker;
import org.apache.empire.db.validation.DBModelParser;
import org.apache.empire.dbms.DBMSFeature;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBMSHandlerBase
implements DBMSHandler {
    private static final Logger log = LoggerFactory.getLogger(DBMSHandler.class);
    protected static final char[] ILLEGAL_NAME_CHARS = new char[]{'@', '?', '>', '=', '<', ';', ':', '/', '.', '-', ',', '+', '*', ')', '(', '\'', '&', '%', '!', ' '};
    protected static final String[] GENERAL_SQL_KEYWORDS = new String[]{"user", "group", "table", "column", "view", "index", "constraint", "select", "udpate", "insert", "alter", "delete", "order"};
    protected final Set<String> reservedSQLKeywords = new HashSet<String>(GENERAL_SQL_KEYWORDS.length);
    protected String SEQUENCE_NAME_SUFFIX = "_SEQ";

    protected DBMSHandlerBase() {
        for (String keyWord : GENERAL_SQL_KEYWORDS) {
            this.reservedSQLKeywords.add(keyWord);
        }
    }

    @Override
    public boolean checkExists(DBDatabase db, Connection conn) {
        List<DBTable> tables = db.getTables();
        DBRowSet any = tables.isEmpty() ? (DBRowSet)db.getViews().get(0) : (DBRowSet)tables.get(0);
        String schema = db.getSchema();
        String linkName = db.getLinkName();
        StringBuilder sql = new StringBuilder("SELECT count(*) from ");
        if (schema != null) {
            sql.append(schema);
            sql.append(".");
        }
        this.appendObjectName(sql, any.getName(), null);
        if (linkName != null) {
            sql.append(this.getSQLPhrase(DBSqlPhrase.SQL_DATABASE_LINK));
            sql.append(linkName);
        }
        try {
            this.querySingleValue(sql.toString(), null, DataType.INTEGER, conn);
            return true;
        }
        catch (QueryFailedException e) {
            return false;
        }
    }

    @Override
    public void attachDatabase(DBDatabase db, Connection conn) {
    }

    @Override
    public void detachDatabase(DBDatabase db, Connection conn) {
    }

    @Override
    public DBCommand createCommand(boolean autoPrepareStmt) {
        return new DBMSCommand(autoPrepareStmt);
    }

    @Override
    public DBCommandExpr createCombinedCommand(DBCommandExpr left, String keyWord, DBCommandExpr right) {
        return new DBCombinedCmd(left, keyWord, right);
    }

    @Override
    public abstract boolean isSupported(DBMSFeature var1);

    public boolean detectQuoteName(String name) {
        if (this.reservedSQLKeywords.contains(name.toLowerCase())) {
            return true;
        }
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ic;
            char c = name.charAt(i);
            for (int j = 0; j < ILLEGAL_NAME_CHARS.length && c <= (ic = ILLEGAL_NAME_CHARS[j]); ++j) {
                if (c != ic) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void appendObjectName(StringBuilder sql, String name, Boolean useQuotes) {
        if (useQuotes == null) {
            useQuotes = this.detectQuoteName(name);
        }
        if (useQuotes.booleanValue()) {
            sql.append(this.getSQLPhrase(DBSqlPhrase.SQL_QUOTES_OPEN));
        }
        sql.append(name);
        if (useQuotes.booleanValue()) {
            sql.append(this.getSQLPhrase(DBSqlPhrase.SQL_QUOTES_CLOSE));
        }
    }

    @Override
    public Timestamp getUpdateTimestamp(Connection conn) {
        Date date = new Date();
        return new Timestamp(date.getTime());
    }

    public abstract Object getNextSequenceValue(DBDatabase var1, String var2, int var3, Connection var4);

    public abstract DBColumnExpr getNextSequenceValueExpr(DBTableColumn var1);

    public String getColumnSequenceName(DBTableColumn column) {
        if (column.getDataType() != DataType.AUTOINC) {
            throw new InvalidArgumentException("column", column);
        }
        Object seqName = column.getDefaultValue();
        if (seqName != null) {
            return seqName.toString();
        }
        StringBuilder b = new StringBuilder(column.getRowSet().getName());
        b.append("_");
        b.append(column.getName());
        b.append(this.SEQUENCE_NAME_SUFFIX);
        seqName = b.toString();
        column.setDefaultValue(seqName);
        return (String)seqName;
    }

    @Override
    public Object getColumnAutoValue(DBDatabase db, DBTableColumn column, Connection conn) {
        DataType type = column.getDataType();
        if (type == DataType.AUTOINC) {
            if (!this.isSupported(DBMSFeature.SEQUENCES)) {
                return null;
            }
            String sequenceName = this.getColumnSequenceName(column);
            return this.getNextSequenceValue(db, sequenceName, 1, conn);
        }
        if (type == DataType.UNIQUEID) {
            return UUID.randomUUID();
        }
        if (type == DataType.DATE || type == DataType.TIME || type == DataType.DATETIME || type == DataType.TIMESTAMP) {
            if (conn == null) {
                return null;
            }
            Timestamp ts = this.getUpdateTimestamp(conn);
            if (type == DataType.DATE) {
                return DateUtils.getDateOnly(ts);
            }
            if (type == DataType.TIME) {
                return DateUtils.getTimeOnly(ts);
            }
            return ts;
        }
        throw new NotSupportedException(this, "getColumnAutoValue() for " + (Object)((Object)type));
    }

    @Override
    public Object getResultValue(ResultSet rset, int columnIndex, DataType dataType) throws SQLException {
        if (dataType == DataType.DATETIME || dataType == DataType.TIMESTAMP) {
            return rset.getTimestamp(columnIndex);
        }
        if (dataType == DataType.CLOB) {
            Clob clob = rset.getClob(columnIndex);
            return clob != null ? clob.getSubString(1L, (int)clob.length()) : null;
        }
        if (dataType == DataType.BLOB) {
            Blob blob = rset.getBlob(columnIndex);
            return blob != null ? blob.getBytes(1L, (int)blob.length()) : null;
        }
        return rset.getObject(columnIndex);
    }

    @Override
    public String getValueString(Object value, DataType type) {
        if (value instanceof Enum) {
            log.warn("Enum of type {} supplied for getValueString. Converting value...", (Object)value.getClass().getName());
            value = ObjectUtils.getEnumValue((Enum)value, type.isNumeric());
        }
        if (ObjectUtils.isEmpty(value)) {
            return this.getSQLPhrase(DBSqlPhrase.SQL_NULL);
        }
        switch (type) {
            case DATE: {
                return this.getSQLDateTimeString(value, DBSqlPhrase.SQL_DATE_TEMPLATE, DBSqlPhrase.SQL_DATE_PATTERN, DBSqlPhrase.SQL_CURRENT_DATE);
            }
            case TIME: {
                return this.getSQLDateTimeString(value, DBSqlPhrase.SQL_TIME_TEMPLATE, DBSqlPhrase.SQL_TIME_PATTERN, DBSqlPhrase.SQL_CURRENT_TIME);
            }
            case DATETIME: {
                if (!DBDatabase.SYSDATE.equals(value) && !(value instanceof Date) && ObjectUtils.lengthOf(value) <= 10) {
                    return this.getSQLDateTimeString(value, DBSqlPhrase.SQL_DATE_TEMPLATE, DBSqlPhrase.SQL_DATE_PATTERN, DBSqlPhrase.SQL_CURRENT_TIMESTAMP);
                }
                return this.getSQLDateTimeString(value, DBSqlPhrase.SQL_DATETIME_TEMPLATE, DBSqlPhrase.SQL_DATETIME_PATTERN, DBSqlPhrase.SQL_CURRENT_TIMESTAMP);
            }
            case TIMESTAMP: {
                return this.getSQLDateTimeString(value, DBSqlPhrase.SQL_TIMESTAMP_TEMPLATE, DBSqlPhrase.SQL_TIMESTAMP_PATTERN, DBSqlPhrase.SQL_CURRENT_TIMESTAMP);
            }
            case VARCHAR: 
            case CHAR: 
            case CLOB: 
            case UNIQUEID: {
                return this.getSQLTextString(type, value);
            }
            case BOOL: {
                boolean boolVal = false;
                boolVal = value instanceof Boolean ? ((Boolean)value).booleanValue() : this.stringToBoolean(value.toString());
                return this.getSQLPhrase(boolVal ? DBSqlPhrase.SQL_BOOLEAN_TRUE : DBSqlPhrase.SQL_BOOLEAN_FALSE);
            }
            case INTEGER: 
            case DECIMAL: 
            case FLOAT: {
                return this.getSQLNumberString(value, type);
            }
            case BLOB: {
                throw new NotSupportedException(this, "getValueString(?, DataType.BLOB)");
            }
            case AUTOINC: 
            case UNKNOWN: {
                return value.toString();
            }
        }
        log.warn("Unknown DataType {} for getValueString().", (Object)type);
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeSQL(String sqlCmd, Object[] sqlParams, Connection conn, DBMSHandler.DBSetGenKeys genKeys) throws SQLException {
        Statement stmt = null;
        try {
            int count = 0;
            if (sqlParams != null) {
                PreparedStatement pstmt = genKeys != null ? conn.prepareStatement(sqlCmd, 1) : conn.prepareStatement(sqlCmd);
                stmt = pstmt;
                this.prepareStatement(pstmt, sqlParams);
                count = pstmt.executeUpdate();
            } else {
                stmt = conn.createStatement();
                int n = count = genKeys != null ? stmt.executeUpdate(sqlCmd, 1) : stmt.executeUpdate(sqlCmd);
            }
            if (genKeys != null && count > 0) {
                try (ResultSet rs = stmt.getGeneratedKeys();){
                    int rownum = 0;
                    while (rs.next()) {
                        genKeys.set(rownum++, rs.getObject(1));
                    }
                }
            }
            int n = count;
            this.closeStatement(stmt);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch(String[] sqlCmd, Object[][] sqlCmdParams, Connection conn) throws SQLException {
        if (sqlCmdParams != null) {
            PreparedStatement pstmt = null;
            try {
                int pos = 0;
                String lastCmd = null;
                int[] result = new int[sqlCmd.length];
                for (int i = 0; i <= sqlCmd.length; ++i) {
                    String cmd;
                    String string = cmd = i < sqlCmd.length ? sqlCmd[i] : null;
                    if (!StringUtils.compareEqual(cmd, lastCmd, true)) {
                        if (pstmt != null) {
                            log.debug("Executing batch containing {} statements", (Object)(i - pos));
                            int[] res = pstmt.executeBatch();
                            for (int j = 0; j < res.length; ++j) {
                                result[pos + j] = res[j];
                            }
                            pos += res.length;
                            this.closeStatement(pstmt);
                            pstmt = null;
                        }
                        if (cmd == null) break;
                        if (log.isTraceEnabled()) {
                            log.trace("Creating prepared statement for batch: {}", (Object)cmd);
                        }
                        pstmt = conn.prepareStatement(cmd);
                        lastCmd = cmd;
                    }
                    if (sqlCmdParams[i] != null) {
                        this.prepareStatement(pstmt, sqlCmdParams[i]);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Adding batch with {} params.", (Object)(sqlCmdParams[i] != null ? sqlCmdParams[i].length : 0));
                    }
                    pstmt.addBatch();
                }
                int[] nArray = result;
                return nArray;
            }
            finally {
                this.closeStatement(pstmt);
            }
        }
        Statement stmt = conn.createStatement();
        try {
            int[] result;
            for (int i = 0; i < sqlCmd.length; ++i) {
                String cmd = sqlCmd[i];
                if (log.isTraceEnabled()) {
                    log.trace("Adding statement to batch: {}", (Object)cmd);
                }
                stmt.addBatch(cmd);
            }
            log.debug("Executing batch containing {} statements", (Object)sqlCmd.length);
            int[] nArray = result = stmt.executeBatch();
            return nArray;
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    @Override
    public ResultSet executeQuery(String sqlCmd, Object[] sqlParams, boolean scrollable, Connection conn) throws SQLException {
        Statement stmt = null;
        try {
            int type;
            int n = type = scrollable ? 1004 : 1003;
            if (sqlParams != null) {
                PreparedStatement pstmt = conn.prepareStatement(sqlCmd, type, 1007);
                stmt = pstmt;
                this.prepareStatement(pstmt, sqlParams);
                return pstmt.executeQuery();
            }
            stmt = conn.createStatement(type, 1007);
            return stmt.executeQuery(sqlCmd);
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error executeQuery '" + sqlCmd + "' --> " + e.getMessage(), (Throwable)e);
            }
            this.closeStatement(stmt);
            throw e;
        }
    }

    @Override
    public Object querySingleValue(String sqlCmd, Object[] sqlParams, DataType dataType, Connection conn) {
        ResultSet rs;
        block6: {
            rs = null;
            rs = this.executeQuery(sqlCmd, sqlParams, false, conn);
            if (rs == null) {
                throw new UnexpectedReturnValueException(rs, "dbms.executeQuery()");
            }
            if (rs.next()) break block6;
            log.trace("querySingleValue for {} returned no result", (Object)sqlCmd);
            ObjectUtils.NoValue noValue = ObjectUtils.NO_VALUE;
            this.closeResultSet(rs);
            return noValue;
        }
        try {
            Object object = this.getResultValue(rs, 1, dataType);
            this.closeResultSet(rs);
            return object;
        }
        catch (SQLException sqle) {
            try {
                throw new QueryFailedException(this, sqlCmd, sqle);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    @Override
    public void appendEnableRelationStmt(DBRelation r, boolean enable, DBSQLScript script) {
        if (enable) {
            this.getDDLScript(DBDDLGenerator.DDLActionType.CREATE, r, script);
        } else {
            this.getDDLScript(DBDDLGenerator.DDLActionType.DROP, r, script);
        }
    }

    @Override
    public DBModelParser createModelParser(String catalog, String schema) {
        return new DBModelParser(catalog, schema);
    }

    @Override
    public DBModelChecker createModelChecker(DBDatabase db) {
        log.warn("A general and possibly untested DBModelChecker is used for DBMSHandler {}. Please override to inklude DBMS specific features.", (Object)this.getClass().getSimpleName());
        DBModelParser modelParser = this.createModelParser(null, db.getSchema());
        return new DBModelChecker(modelParser);
    }

    @Override
    public String extractErrorMessage(SQLException e) {
        return e.getMessage();
    }

    @Override
    public void closeResultSet(ResultSet rset) {
        try {
            if (rset == null) {
                return;
            }
            Statement stmt = rset.getStatement();
            rset.close();
            if (stmt == null) {
                return;
            }
            stmt.close();
            return;
        }
        catch (SQLException sqle) {
            throw new EmpireSQLException(this, sqle);
        }
    }

    protected void closeStatement(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
            return;
        }
        catch (SQLException sqle) {
            throw new EmpireSQLException(this, sqle);
        }
    }

    protected void prepareStatement(PreparedStatement pstmt, Object[] sqlParams) throws SQLException {
        for (int i = 0; i < sqlParams.length; ++i) {
            Object value = sqlParams[i];
            try {
                this.addStatementParam(pstmt, i + 1, value);
                continue;
            }
            catch (SQLException e) {
                log.error("SQLException: Unable to set prepared statement parameter {} to '{}'", (Object)(i + 1), (Object)StringUtils.toString(value));
                throw e;
            }
        }
    }

    protected void addStatementParam(PreparedStatement pstmt, int paramIndex, Object value) throws SQLException {
        if (value instanceof DBBlobData) {
            DBBlobData blobData = (DBBlobData)value;
            pstmt.setBinaryStream(paramIndex, blobData.getInputStream(), blobData.getLength());
            if (log.isTraceEnabled()) {
                log.trace("Statement param {} set to BLOB data", (Object)paramIndex);
            }
        } else if (value instanceof DBClobData) {
            DBClobData clobData = (DBClobData)value;
            pstmt.setCharacterStream(paramIndex, clobData.getReader(), clobData.getLength());
            if (log.isTraceEnabled()) {
                log.trace("Statement param {} set to CLOB data", (Object)paramIndex);
            }
        } else if (value instanceof Date && !(value instanceof Timestamp)) {
            Timestamp ts = new Timestamp(((Date)value).getTime());
            pstmt.setObject(paramIndex, ts);
            if (log.isTraceEnabled()) {
                log.trace("Statement param {} set to date '{}'", (Object)paramIndex, (Object)ts);
            }
        } else if (value instanceof Character || value instanceof Enum) {
            String strval = value.toString();
            pstmt.setObject(paramIndex, strval);
            if (log.isTraceEnabled()) {
                log.trace("Statement param {} set to '{}'", (Object)paramIndex, (Object)strval);
            }
        } else {
            pstmt.setObject(paramIndex, value);
            if (log.isTraceEnabled()) {
                log.trace("Statement param {} set to '{}'", (Object)paramIndex, value);
            }
        }
    }

    protected String getSQLNumberString(Object value, DataType type) {
        if (value instanceof Number) {
            return value.toString();
        }
        String s = value.toString();
        boolean integerOnly = type == DataType.INTEGER;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c == '-' || c == '+') continue;
            if (c == ' ' && i > 0) {
                return s.substring(0, i);
            }
            if (!integerOnly && (c == '.' || c == ',')) continue;
            throw new NumberFormatException(s);
        }
        return s;
    }

    protected String getSQLDateTimeString(Object value, DBSqlPhrase sqlTemplate, DBSqlPhrase sqlPattern, DBSqlPhrase sqlCurrentDate) {
        Timestamp ts;
        if (DBDatabase.SYSDATE.equals(value)) {
            return this.getSQLPhrase(sqlCurrentDate);
        }
        if (value instanceof Timestamp) {
            ts = (Timestamp)value;
        } else if (value instanceof Date) {
            ts = new Timestamp(((Date)value).getTime());
        } else if (value instanceof LocalDate) {
            ts = Timestamp.valueOf(((LocalDate)value).atStartOfDay());
        } else if (value instanceof LocalDateTime) {
            ts = Timestamp.valueOf((LocalDateTime)value);
        } else {
            String dtValue = value.toString().trim();
            try {
                ts = Timestamp.valueOf(dtValue);
            }
            catch (Throwable e) {
                log.error("Unable to parse date value " + dtValue, e);
                throw new InvalidArgumentException("value", value);
            }
        }
        String pattern = this.getSQLPhrase(sqlPattern);
        SimpleDateFormat sqlFormat = new SimpleDateFormat(this.getSQLPhrase(sqlPattern));
        String datetime = sqlFormat.format(ts);
        int nanos = ts.getNanos() % 1000000;
        if (pattern.endsWith(".SSS") && nanos > 0) {
            datetime = nanos % 100 > 0 ? datetime + String.format("%06d", nanos) : datetime + String.format("%04d", nanos / 100);
        }
        String template = this.getSQLPhrase(sqlTemplate);
        return StringUtils.replace(template, "{0}", datetime);
    }

    protected String getSQLTextString(DataType type, Object value) {
        StringBuilder valBuf = new StringBuilder();
        valBuf.append("'");
        if (!"\u0000".equals(value)) {
            this.appendSQLTextValue(valBuf, value.toString());
        }
        valBuf.append("'");
        return valBuf.toString();
    }

    protected void appendSQLTextValue(StringBuilder buf, String value) {
        if (value.indexOf(39) >= 0) {
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                if (value.charAt(i) == '\'') {
                    buf.append("''");
                    continue;
                }
                buf.append(value.charAt(i));
            }
        } else {
            buf.append(value);
        }
    }

    protected boolean stringToBoolean(String value) {
        return "1".equals(value) || "true".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value);
    }

    public static class DBSeqTable
    extends DBTable {
        public DBColumn C_SEQNAME = this.addColumn("SeqName", DataType.VARCHAR, 40.0, true);
        public DBColumn C_SEQVALUE = this.addColumn("SeqValue", DataType.INTEGER, 0.0, true);
        public DBColumn C_TIMESTAMP = this.addColumn("SeqTime", DataType.DATETIME, 0.0, true);

        public DBSeqTable(String tableName, DBDatabase db) {
            super(tableName, db);
            this.setPrimaryKey(this.C_SEQNAME);
        }

        public Object getNextValue(String SeqName, long minValue, Connection conn) {
            Object dbms = this.db.getDbms();
            PreparedStatement stmt = null;
            try {
                DBCommand cmd = dbms.createCommand(this.db.isPreparedStatementsEnabled());
                DBCmdParam nameParam = cmd.addParam(SeqName);
                cmd.select((DBColumnExpr)this.C_SEQVALUE);
                cmd.select((DBColumnExpr)this.C_TIMESTAMP);
                cmd.where((DBCompareExpr)this.C_SEQNAME.is(nameParam));
                String selectCmd = cmd.getSelect();
                long seqValue = 0L;
                while (seqValue == 0L) {
                    stmt = conn.prepareStatement(selectCmd, 1004, 1007);
                    stmt.setString(1, SeqName);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        seqValue = Math.max(rs.getLong(1) + 1L, minValue);
                        Timestamp current = rs.getTimestamp(2);
                        dbms.closeResultSet(rs);
                        cmd.clear();
                        DBCmdParam name = cmd.addParam(SeqName);
                        DBCmdParam time = cmd.addParam(current);
                        cmd.set(this.C_SEQVALUE.to(seqValue));
                        cmd.set(this.C_TIMESTAMP.to(DBDatabase.SYSDATE));
                        cmd.where((DBCompareExpr)this.C_SEQNAME.is(name));
                        cmd.where((DBCompareExpr)this.C_TIMESTAMP.is(time));
                        if (dbms.executeSQL(cmd.getUpdate(), cmd.getParamValues(), conn, null) < 1) {
                            seqValue = 0L;
                        }
                    } else {
                        dbms.closeResultSet(rs);
                        seqValue = minValue;
                        log.warn("Sequence {} does not exist! Creating sequence with start-value of {}", (Object)SeqName, (Object)seqValue);
                        cmd.clear();
                        cmd.set(this.C_SEQNAME.to(SeqName));
                        cmd.set(this.C_SEQVALUE.to(seqValue));
                        cmd.set(this.C_TIMESTAMP.to(DBDatabase.SYSDATE));
                        if (dbms.executeSQL(cmd.getInsert(), cmd.getParamValues(), conn, null) < 1) {
                            seqValue = 0L;
                        }
                    }
                    if (seqValue == 0L) {
                        log.warn("Failed to increment sequence {}. Trying again!", (Object)SeqName);
                    }
                    this.closeStatement(stmt);
                    cmd.clear();
                    rs = null;
                }
                if (log.isInfoEnabled()) {
                    log.info("Sequence {} incremented to {}.", (Object)SeqName, (Object)seqValue);
                }
                Long l = new Long(seqValue);
                this.closeStatement(stmt);
                return l;
            }
            catch (SQLException e) {
                try {
                    throw new EmpireSQLException(this, e);
                }
                catch (Throwable throwable) {
                    this.closeStatement(stmt);
                    throw throwable;
                }
            }
        }

        private void closeStatement(Statement stmt) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                return;
            }
            catch (SQLException sqle) {
                throw new EmpireSQLException(this, sqle);
            }
        }
    }

    public static final class DBMSCommand
    extends DBCommand {
        protected DBMSCommand(boolean autoPrepareStmt) {
            super(autoPrepareStmt);
        }
    }
}

