/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.compare;

import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBCmpType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.expr.column.DBAliasExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;

public class DBCompareColExpr
extends DBCompareExpr {
    protected final DBColumnExpr expr;
    protected final DBCmpType cmpop;
    protected Object value;

    public DBCompareColExpr(DBColumnExpr expr, DBCmpType op, Object value) {
        if (expr instanceof DBAliasExpr) {
            expr = ((DBAliasExpr)expr).unwrap();
        }
        this.expr = expr;
        this.cmpop = op;
        this.value = value;
    }

    public final DBDatabase getDatabase() {
        return this.expr.getDatabase();
    }

    public DBColumnExpr getColumnExpr() {
        return this.expr;
    }

    public DBCmpType getCmpOperator() {
        return this.cmpop;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void prepareCommand(DBCommand cmd) {
        if (this.value == null || this.value instanceof DBCmdParam || this.value instanceof DBExpr || this.value instanceof DBDatabase.DBSystemDate) {
            return;
        }
        switch (this.cmpop) {
            case EQUAL: 
            case NOTEQUAL: 
            case LESSTHAN: 
            case MOREOREQUAL: 
            case GREATERTHAN: 
            case LESSOREQUAL: 
            case LIKE: 
            case NOTLIKE: {
                this.value = cmd.addParam(this.expr.getDataType(), this.value);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public DBCompareExpr copy(DBCommand newCmd) {
        Object valueCopy = this.value;
        if (this.value instanceof DBCmdParam) {
            valueCopy = newCmd.addParam(DataType.UNKNOWN, ((DBCmdParam)this.value).getValue());
        }
        return new DBCompareColExpr(this.expr, this.cmpop, valueCopy);
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.expr.addReferencedColumns(list);
        if (this.value instanceof DBExpr) {
            ((DBExpr)this.value).addReferencedColumns(list);
        }
    }

    public void addCompareExpr(StringBuilder buf, long context) {
        String arraySep = "+";
        DBCmpType op = this.cmpop;
        switch (op) {
            case BETWEEN: 
            case NOTBETWEEN: {
                arraySep = " AND ";
                break;
            }
            case IN: 
            case NOTIN: {
                arraySep = ", ";
                break;
            }
        }
        String valsql = this.getObjectValue(this.expr.getDataType(), this.value, context, arraySep);
        if (valsql == null || valsql.equalsIgnoreCase("null")) {
            op = DBCmpType.getNullType(op);
        }
        switch (op) {
            case EQUAL: {
                buf.append("=");
                break;
            }
            case NOTEQUAL: {
                buf.append("<>");
                break;
            }
            case LESSTHAN: {
                buf.append("<");
                break;
            }
            case MOREOREQUAL: {
                buf.append(">=");
                break;
            }
            case GREATERTHAN: {
                buf.append(">");
                break;
            }
            case LESSOREQUAL: {
                buf.append("<=");
                break;
            }
            case LIKE: {
                buf.append(" LIKE ");
                break;
            }
            case NOTLIKE: {
                buf.append(" NOT LIKE ");
                break;
            }
            case NULL: {
                buf.append(" IS NULL");
                valsql = null;
                break;
            }
            case NOTNULL: {
                buf.append(" IS NOT NULL");
                valsql = null;
                break;
            }
            case BETWEEN: {
                buf.append(" BETWEEN ");
                break;
            }
            case NOTBETWEEN: {
                buf.append(" NOT BETWEEN ");
                break;
            }
            case IN: {
                buf.append(" IN (");
                buf.append(valsql);
                buf.append(")");
                valsql = null;
                break;
            }
            case NOTIN: {
                buf.append(" NOT IN (");
                buf.append(valsql);
                buf.append(")");
                valsql = null;
                break;
            }
            default: {
                buf.append(" ");
            }
        }
        if (valsql != null) {
            buf.append(valsql);
        }
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        if ((context & 4L) == 0L) {
            this.expr.addSQL(buf, context);
            return;
        }
        if ((context & 1L) == 0L) {
            String valsql = this.getObjectValue(this.expr.getDataType(), this.value, context, "+");
            buf.append(valsql != null ? valsql : "null");
            return;
        }
        this.expr.addSQL(buf, context);
        this.addCompareExpr(buf, context);
    }

    @Override
    public boolean isMutuallyExclusive(DBCompareExpr other) {
        if (other instanceof DBCompareColExpr) {
            DBCompareColExpr o = (DBCompareColExpr)other;
            DBColumnExpr oexpr = o.getColumnExpr();
            return ObjectUtils.compareEqual(this.expr, oexpr);
        }
        return this.equals(other);
    }
}

