/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.compare;

import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.compare.DBCompareParenthesisExpr;

public class DBCompareAndOrExpr
extends DBCompareExpr {
    protected final DBCompareExpr left;
    protected final DBCompareExpr right;
    protected final boolean or;

    public DBCompareAndOrExpr(DBCompareExpr left, DBCompareExpr right, boolean or) {
        this.left = left;
        this.right = right;
        this.or = or;
    }

    public DBCompareExpr getLeft() {
        return this.left;
    }

    public DBCompareExpr getRight() {
        return this.right;
    }

    public boolean isOr() {
        return this.or;
    }

    public final DBDatabase getDatabase() {
        return this.left.getDatabase();
    }

    @Override
    public void prepareCommand(DBCommand cmd) {
        this.left.prepareCommand(cmd);
        this.right.prepareCommand(cmd);
    }

    @Override
    public DBCompareExpr copy(DBCommand newCmd) {
        return new DBCompareAndOrExpr(this.left.copy(newCmd), this.right.copy(newCmd), this.or);
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.left.addReferencedColumns(list);
        this.right.addReferencedColumns(list);
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        boolean nested;
        if ((context & 1L) == 0L || (context & 4L) == 0L) {
            this.left.addSQL(buf, context);
            buf.append(",");
            this.right.addSQL(buf, context);
            return;
        }
        boolean parenthesis = (context & 0x10L) == 0L && this.or;
        boolean bl = nested = this.left instanceof DBCompareAndOrExpr && !((DBCompareAndOrExpr)this.left).or;
        if (parenthesis) {
            buf.append("(");
        }
        if (parenthesis && nested) {
            buf.append("(");
        }
        this.left.addSQL(buf, context);
        if (parenthesis && nested) {
            buf.append(")");
        }
        buf.append(this.or ? " OR " : " AND ");
        boolean bl2 = nested = this.right instanceof DBCompareAndOrExpr && !((DBCompareAndOrExpr)this.right).or;
        if (parenthesis && nested) {
            buf.append("(");
        }
        this.right.addSQL(buf, context);
        if (parenthesis && nested) {
            buf.append(")");
        }
        if (parenthesis) {
            buf.append(")");
        }
    }

    @Override
    public boolean isMutuallyExclusive(DBCompareExpr other) {
        if (ObjectUtils.isWrapper(other)) {
            other = ObjectUtils.unwrap(other);
        }
        if (other instanceof DBCompareAndOrExpr) {
            DBCompareAndOrExpr otherExpr = (DBCompareAndOrExpr)other;
            if (this.left.isMutuallyExclusive(otherExpr.left) && this.right.isMutuallyExclusive(otherExpr.right)) {
                return this.or == otherExpr.or;
            }
        }
        return false;
    }

    public DBCompareExpr parenthesis() {
        return new DBCompareParenthesisExpr(this);
    }
}

