/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Map;
import java.util.Set;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.expr.column.DBAbstractFuncExpr;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.dbms.DBSqlPhrase;

public class DBDecodeExpr
extends DBAbstractFuncExpr {
    private final Map<?, ?> valueMap;
    private final Object elseExpr;

    public DBDecodeExpr(DBColumnExpr expr, Map<?, ?> valueMap, Object elseExpr, DataType dataType) {
        super(expr, false, dataType);
        this.valueMap = valueMap;
        this.elseExpr = elseExpr;
    }

    @Override
    protected String getFunctionName() {
        return "DECODE";
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        DBColumnExpr firstExpr = this.getFirstColumnExpr();
        if (firstExpr != null) {
            return firstExpr.getEnumType();
        }
        return super.getEnumType();
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.expr.addReferencedColumns(list);
        for (Map.Entry<?, ?> e : this.valueMap.entrySet()) {
            if (e.getKey() instanceof DBExpr) {
                ((DBExpr)e.getKey()).addReferencedColumns(list);
            }
            if (!(e.getValue() instanceof DBExpr)) continue;
            ((DBExpr)e.getValue()).addReferencedColumns(list);
        }
        if (this.elseExpr instanceof DBExpr) {
            ((DBExpr)this.elseExpr).addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(StringBuilder sql, long context) {
        Object dbms = this.getDatabase().getDbms();
        StringBuilder inner = new StringBuilder();
        for (Object key : this.valueMap.keySet()) {
            Object val = this.valueMap.get(key);
            String part = dbms.getSQLPhrase(DBSqlPhrase.SQL_FUNC_DECODE_PART);
            part = StringUtils.replaceAll(part, "{0}", this.getObjectValue(this.expr.getDataType(), key, 7L, ""));
            part = StringUtils.replaceAll(part, "{1}", this.getObjectValue(this.getDataType(), val, 7L, ""));
            inner.append(dbms.getSQLPhrase(DBSqlPhrase.SQL_FUNC_DECODE_SEP));
            inner.append(part);
        }
        if (this.elseExpr != null) {
            String other = dbms.getSQLPhrase(DBSqlPhrase.SQL_FUNC_DECODE_ELSE);
            other = StringUtils.replaceAll(other, "{0}", this.getObjectValue(this.getDataType(), this.elseExpr, 7L, ""));
            inner.append(dbms.getSQLPhrase(DBSqlPhrase.SQL_FUNC_DECODE_SEP));
            inner.append(other);
        }
        DBValueExpr param = new DBValueExpr(this.getDatabase(), inner, DataType.UNKNOWN);
        String template = dbms.getSQLPhrase(DBSqlPhrase.SQL_FUNC_DECODE);
        super.addSQL(sql, template, new Object[]{param}, context);
    }

    private DBColumnExpr getFirstColumnExpr() {
        for (Object val : this.valueMap.values()) {
            if (!(val instanceof DBColumnExpr)) continue;
            return (DBColumnExpr)val;
        }
        if (this.elseExpr instanceof DBColumnExpr) {
            return (DBColumnExpr)this.elseExpr;
        }
        return null;
    }
}

