/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.expr.column.DBAbstractFuncExpr;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.dbms.DBSqlPhrase;

public class DBConcatFuncExpr
extends DBAbstractFuncExpr {
    private final DBColumnExpr first;
    private final String separator;
    private final DBColumnExpr[] others;

    public DBConcatFuncExpr(DBColumnExpr first, String separator, DBColumnExpr ... others) {
        super(first, false, DataType.VARCHAR);
        this.first = first;
        this.separator = separator;
        this.others = others;
    }

    public DBConcatFuncExpr(DBColumnExpr first, DBColumnExpr ... others) {
        this(first, (String)null, others);
    }

    @Override
    public String getName() {
        String name = this.first.getName();
        for (int i = 0; i < this.others.length; ++i) {
            if (this.others[i] instanceof DBValueExpr) continue;
            name = name + "_";
            name = name + this.others[i].getName();
        }
        return name;
    }

    @Override
    protected String getFunctionName() {
        return "CONCAT";
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DBConcatFuncExpr) {
            DBConcatFuncExpr otherFunc = (DBConcatFuncExpr)other;
            if (!this.first.equals(otherFunc.first)) {
                return false;
            }
            for (int i = 0; i < this.others.length; ++i) {
                if (this.others[i].equals(otherFunc.others[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        String template = this.getDatabase().getDbms().getSQLPhrase(DBSqlPhrase.SQL_FUNC_CONCAT);
        int placeholder = template.indexOf(63);
        if (placeholder >= 0) {
            buf.append(template.substring(0, placeholder));
        }
        this.first.addSQL(buf, context);
        for (int i = 0; i < this.others.length; ++i) {
            if (placeholder >= 0) {
                buf.append(", ");
            } else {
                buf.append(template);
            }
            if (this.separator != null && this.separator.length() > 0) {
                buf.append("'");
                buf.append(this.separator);
                buf.append("', ");
            }
            this.others[i].addSQL(buf, context);
        }
        if (placeholder >= 0) {
            buf.append(template.substring(placeholder + 1));
        }
    }
}

