/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.text.MessageFormat;
import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public class DBConcatExpr
extends DBColumnExpr {
    protected final DBColumnExpr left;
    protected final Object right;

    public DBConcatExpr(DBColumnExpr left, Object right) {
        this.left = left;
        this.right = right;
    }

    public final DBDatabase getDatabase() {
        return this.left.getDatabase();
    }

    @Override
    public DataType getDataType() {
        return DataType.VARCHAR;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return null;
    }

    @Override
    public String getName() {
        String name = this.left.getName();
        if (this.right instanceof DBColumnExpr) {
            name = name + "_";
            name = name + ((DBColumnExpr)this.right).getName();
        }
        return name;
    }

    @Override
    public DBColumn getSourceColumn() {
        return this.left.getSourceColumn();
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof DBConcatExpr) {
            return this.left.equals(((DBConcatExpr)other).left) && this.right.equals(((DBConcatExpr)other).right);
        }
        return false;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.left.addReferencedColumns(list);
        if (this.right instanceof DBExpr) {
            ((DBExpr)this.right).addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        String template = this.getDatabase().getDbms().getSQLPhrase(DBSqlPhrase.SQL_CONCAT_EXPR);
        context &= 0xFFFFFFFFFFFFFFF7L;
        int sep = template.indexOf(63);
        if (sep >= 0) {
            buf.append(template.substring(0, sep));
            this.left.addSQL(buf, context);
            String value = this.getObjectValue(this.getDataType(), this.right, context, ", ");
            buf.append(MessageFormat.format(template.substring(sep + 1), value));
        } else {
            this.left.addSQL(buf, context);
            buf.append(template);
            buf.append(this.getObjectValue(this.getDataType(), this.right, context, template));
        }
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.getName());
        elem.setAttribute("function", "concat");
        DBColumn source = this.getSourceColumn();
        if (source != null) {
            Element elemSource = XMLUtil.addElement(elem, "source");
            source.addXml(elemSource, flags);
            Object with = this.right;
            while (with instanceof DBExpr) {
                if (with instanceof DBConcatExpr) {
                    ((DBConcatExpr)with).getSourceColumn().addXml(elemSource, flags);
                    with = ((DBConcatExpr)with).right;
                    continue;
                }
                if (with instanceof DBColumnExpr) {
                    ((DBColumnExpr)with).addXml(elemSource, flags);
                }
                with = null;
            }
        }
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        if (this.options != null) {
            this.options.addXml(elem, this.getDataType());
        }
        return elem;
    }
}

