/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Date;
import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.w3c.dom.Element;

public class DBCalcExpr
extends DBColumnExpr {
    private final DBColumnExpr expr;
    private final String op;
    private final Object value;

    public DBCalcExpr(DBColumnExpr expr, String op, Object value) {
        this.expr = expr;
        this.value = value;
        this.op = op;
    }

    public final DBDatabase getDatabase() {
        return this.expr.getDatabase();
    }

    @Override
    public DataType getDataType() {
        DataType type2;
        DataType type = this.expr.getDataType();
        if (type.isDate()) {
            if (this.value instanceof Date || this.value instanceof DBDatabase.DBSystemDate || this.value instanceof DBColumnExpr && ((DBColumnExpr)this.value).getDataType().isDate()) {
                return DataType.DECIMAL;
            }
        } else if (this.value instanceof DBColumnExpr && (type2 = ((DBColumnExpr)this.value).getDataType()).isNumeric() && type2.ordinal() > type.ordinal()) {
            return type2;
        }
        return type;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return null;
    }

    @Override
    public String getName() {
        String valName;
        String exprName = this.expr.getName();
        String string = valName = this.value instanceof DBColumnExpr ? ((DBColumnExpr)this.value).getName() : null;
        if (StringUtils.isNotEmpty(exprName)) {
            return valName != null ? exprName + "_" + valName : exprName;
        }
        return StringUtils.coalesce(valName, "CALC");
    }

    @Override
    public Element addXml(Element parent, long flags) {
        this.expr.addXml(parent, flags);
        if (this.value instanceof DBColumnExpr) {
            ((DBColumnExpr)this.value).addXml(parent, flags);
        }
        return parent;
    }

    @Override
    public DBColumn getSourceColumn() {
        return this.expr.getSourceColumn();
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DBCalcExpr) {
            DBCalcExpr otherCalc = (DBCalcExpr)other;
            if (!this.expr.equals(otherCalc.expr)) {
                return false;
            }
            if (!StringUtils.compareEqual(this.op, otherCalc.op)) {
                return false;
            }
            return ObjectUtils.compareEqual(this.value, otherCalc.value);
        }
        return false;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.expr.addReferencedColumns(list);
        if (this.value instanceof DBExpr) {
            ((DBExpr)this.value).addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        this.expr.addSQL(buf, context);
        buf.append(this.op);
        DataType type = this.expr.getDataType();
        if (!type.isNumeric() && this.value instanceof Number) {
            type = DataType.DECIMAL;
        }
        buf.append(this.getObjectValue(type, this.value, context, this.op));
    }

    @Override
    public String toString() {
        String name = this.expr.toString();
        name = name + "_X_";
        name = name + this.value.toString();
        return name;
    }
}

