/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.empire.commons.Options;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRecordBase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemExistsException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public abstract class DBView
extends DBRowSet {
    private static AtomicInteger viewCount = new AtomicInteger(0);
    private String name;
    private String alias;
    private DBViewColumn[] keyColumns;
    private boolean updateable;
    private Boolean quoteName = null;

    public DBView(String name, DBDatabase db, boolean isUpdateable) {
        super(db);
        this.name = name;
        this.alias = "v" + String.valueOf(viewCount.incrementAndGet());
        this.updateable = isUpdateable;
        if (db != null && name != null) {
            db.addView(this);
        }
    }

    public DBView(String name, DBDatabase db) {
        this(name, db, false);
    }

    @Override
    public DBColumn[] getKeyColumns() {
        return this.keyColumns;
    }

    protected void setKeyColumns(DBViewColumn ... keyColumns) {
        this.keyColumns = keyColumns;
    }

    protected void setKeyColumn(DBViewColumn keyColumn) {
        if (keyColumn != null) {
            this.setKeyColumns(keyColumn);
        } else {
            this.setKeyColumns(null);
        }
    }

    protected DBCommand newCommand() {
        return this.db.getDbms().createCommand(false);
    }

    public abstract DBCommandExpr createCommand();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        String schema = this.db.getSchema();
        return schema != null ? schema + "." + this.name : this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    protected void addColumn(DBViewColumn col) {
        if (col == null || col.getRowSet() != this) {
            throw new InvalidArgumentException("col", col);
        }
        if (this.getColumn(col.getName()) != null) {
            throw new ItemExistsException((Object)col.getName());
        }
        this.columns.add(col);
    }

    protected final DBViewColumn addColumn(String columnName, DataType dataType, double size) {
        return new DBViewColumn(this, columnName, new DBValueExpr(this.db, null, dataType), size);
    }

    protected final DBViewColumn addColumn(String columnName, DataType dataType) {
        return new DBViewColumn(this, columnName, new DBValueExpr(this.db, null, dataType), 0.0);
    }

    protected final DBViewColumn addColumn(String columnName, DBColumnExpr columnExpr) {
        return new DBViewColumn(this, columnName, columnExpr, 0.0);
    }

    protected final DBViewColumn addColumn(DBTableColumn sourceColumn) {
        return new DBViewColumn(this, sourceColumn.getName(), sourceColumn, 0.0);
    }

    public DBViewColumn findViewColumn(DBColumnExpr expr) {
        for (int i = 0; i < this.columns.size(); ++i) {
            DBViewColumn vc = (DBViewColumn)this.columns.get(i);
            if (!vc.expr.equals(expr)) continue;
            return vc;
        }
        return null;
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        if ((context & 1L | 2L) != 0L) {
            this.db.appendQualifiedName(buf, this.name, this.quoteName);
        }
        if ((context & 8L) != 0L && this.alias != null) {
            buf.append(this.getRenameTablePhrase());
            buf.append(this.alias);
        }
    }

    public void updateRecord(DBRecordBase rec) {
        if (!this.updateable) {
            throw new NotSupportedException(this, "updateRecord");
        }
        super.updateRecord(rec);
    }

    @Override
    public void createRecord(DBRecordBase record, Object[] initalKey, boolean deferredInit) {
        throw new NotSupportedException(this, "createRecord");
    }

    @Override
    public void deleteRecord(Object[] key, DBContext context) {
        throw new NotSupportedException(this, "deleteRecord");
    }

    public static class DBViewColumn
    extends DBColumn {
        protected final DBColumnExpr expr;
        protected final DataType dataType;
        protected final DBColumn sourceColumn;
        protected final double size;

        protected DBViewColumn(DBView view, String name, DBColumnExpr expr, double size) {
            super(view, name);
            this.expr = expr;
            DataType exprType = expr.getDataType();
            if (exprType == DataType.AUTOINC) {
                exprType = DataType.INTEGER;
            }
            this.dataType = exprType;
            this.sourceColumn = expr.getSourceColumn();
            this.size = this.sourceColumn != null ? this.sourceColumn.getSize() : size;
            Class<Enum<?>> enumType = expr.getEnumType();
            if (enumType != null) {
                this.setAttribute("enumType", enumType);
            }
            if (view != null) {
                view.addColumn(this);
            }
        }

        public DBColumnExpr getSourceColumnExpr() {
            return this.expr;
        }

        public DBView getView() {
            return (DBView)this.getRowSet();
        }

        @Override
        public DataType getDataType() {
            return this.dataType;
        }

        @Override
        public double getSize() {
            return this.size;
        }

        @Override
        public boolean isAutoGenerated() {
            if (this.sourceColumn == null) {
                return false;
            }
            return this.sourceColumn.isAutoGenerated();
        }

        @Override
        public boolean isReadOnly() {
            if (!this.getView().isUpdateable()) {
                return true;
            }
            if (this.sourceColumn != null) {
                return this.sourceColumn.isReadOnly();
            }
            return this.isAutoGenerated();
        }

        @Override
        public boolean isRequired() {
            if (!this.getView().isUpdateable()) {
                return false;
            }
            if (this.sourceColumn == null) {
                return false;
            }
            return this.sourceColumn.isRequired();
        }

        @Override
        public Object validateValue(Object value) {
            if (this.sourceColumn == null) {
                return value;
            }
            return this.sourceColumn.validateValue(value);
        }

        @Override
        public Object getAttribute(String name) {
            if (this.attributes != null && this.attributes.contains(name)) {
                return this.attributes.get(name);
            }
            if (this.sourceColumn == null) {
                return null;
            }
            return this.sourceColumn.getAttribute(name);
        }

        @Override
        public Options getOptions() {
            if (this.options != null) {
                return this.options;
            }
            if (this.sourceColumn == null) {
                return null;
            }
            return this.sourceColumn.getOptions();
        }

        @Override
        public Element addXml(Element parent, long flags) {
            Options fieldOptions;
            double size;
            Element elem = XMLUtil.addElement(parent, "column");
            elem.setAttribute("name", this.name);
            if (this.sourceColumn != null) {
                elem.setAttribute("source", this.sourceColumn.getFullName());
            }
            if ((size = this.getSize()) > 0.0) {
                elem.setAttribute("size", String.valueOf(size));
            }
            if (this.attributes != null) {
                this.attributes.addXml(elem, flags);
            }
            if ((fieldOptions = this.getOptions()) != null) {
                fieldOptions.addXml(elem, this.dataType);
            }
            return elem;
        }
    }
}

