/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataType;
import org.apache.empire.data.list.DataListEntry;
import org.apache.empire.data.list.DataListFactory;
import org.apache.empire.data.list.DataListFactoryImpl;
import org.apache.empire.data.list.DataListHead;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBReader;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRecordBase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.context.DBContextAware;
import org.apache.empire.db.exceptions.CommandWithoutSelectException;
import org.apache.empire.db.exceptions.ConstraintViolationException;
import org.apache.empire.db.exceptions.QueryFailedException;
import org.apache.empire.db.exceptions.QueryNoResultException;
import org.apache.empire.db.exceptions.StatementFailedException;
import org.apache.empire.db.exceptions.UnknownBeanTypeException;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.list.DBBeanFactoryCache;
import org.apache.empire.db.list.DBBeanListFactory;
import org.apache.empire.db.list.DBBeanListFactoryImpl;
import org.apache.empire.db.list.DBRecordListFactory;
import org.apache.empire.db.list.DBRecordListFactoryImpl;
import org.apache.empire.db.list.DataBean;
import org.apache.empire.dbms.DBMSFeature;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUtils
implements DBContextAware {
    protected static final Logger log = LoggerFactory.getLogger(DBUtils.class);
    protected long longRunndingStmtThreshold = 30000L;
    protected int DEFAULT_LIST_CAPACITY = 10;
    protected int MAX_QUERY_ROWS = 999;
    protected int LOG_MAX_STRING_LENGTH = 40;
    protected String LOG_NEW_LINE = "\r\n";
    protected final DBContext context;
    protected final DBMSHandler dbms;

    public DBUtils(DBContext context) {
        this.context = context;
        this.dbms = context.getDbms();
    }

    @Override
    public DBContext getContext() {
        return this.context;
    }

    protected String paramValueToString(Object param) {
        if (param == null) {
            return "NULL";
        }
        DataType dataType = DataType.fromJavaType(param.getClass());
        if (dataType.isText()) {
            String str = param.toString();
            if (str.length() > this.LOG_MAX_STRING_LENGTH) {
                StringBuilder b = new StringBuilder(this.LOG_MAX_STRING_LENGTH + 10);
                b.append(str.substring(0, this.LOG_MAX_STRING_LENGTH));
                b.append("~(");
                b.append(String.valueOf(str.length()));
                b.append(")");
                str = b.toString();
            }
            if (str.indexOf(124) >= 0) {
                str = str.replace('|', '?');
            }
            return str;
        }
        if (dataType == DataType.UNKNOWN || dataType == DataType.BLOB || dataType == DataType.CLOB) {
            return param.getClass().getName();
        }
        return String.valueOf(param);
    }

    protected String paramsToString(Object[] params) {
        if (params == null || params.length < 1) {
            return null;
        }
        if (params.length > 1) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    buf.append('|');
                }
                buf.append(this.paramValueToString(params[i]));
            }
            return buf.toString();
        }
        return this.paramValueToString(params[0]);
    }

    protected void logQueryStatement(String sqlCmd, Object[] sqlParams) {
        if (log.isDebugEnabled()) {
            if (sqlParams != null && sqlParams.length > 0) {
                log.debug("Executing DQL: {}{}{}Parameters: [{}]", new Object[]{this.LOG_NEW_LINE, sqlCmd, this.LOG_NEW_LINE, this.paramsToString(sqlParams)});
            } else {
                log.debug("Executing DQL: {}{}", (Object)this.LOG_NEW_LINE, (Object)sqlCmd);
            }
        }
    }

    protected void logUpdateStatement(String sqlCmd, Object[] sqlParams) {
        if (log.isInfoEnabled()) {
            if (sqlParams != null && sqlParams.length > 0) {
                log.info("Executing DML: {}{}{}Parameters: [{}]", new Object[]{this.LOG_NEW_LINE, sqlCmd, this.LOG_NEW_LINE, this.paramsToString(sqlParams)});
            } else {
                log.info("Executing DML: {}{}", (Object)this.LOG_NEW_LINE, (Object)sqlCmd);
            }
        }
    }

    public int executeSQL(String sqlCmd, Object[] sqlParams, DBMSHandler.DBSetGenKeys setGenKeys) {
        try {
            this.logUpdateStatement(sqlCmd, sqlParams);
            long start = System.currentTimeMillis();
            int affected = this.dbms.executeSQL(sqlCmd, sqlParams, this.context.getConnection(), setGenKeys);
            if (affected < 0) {
                log.warn("Unexpected return value {} from dbms.executeSQL(\"{}\")", (Object)affected, (Object)sqlCmd);
            }
            long execTime = System.currentTimeMillis() - start;
            if (log.isInfoEnabled()) {
                log.info("executeSQL affected {} Records in {} ms ", (Object)affected, (Object)execTime);
            } else if (execTime >= this.longRunndingStmtThreshold) {
                log.warn("Long running statement took {} seconds for statement {}.", (Object)(execTime / 1000L), (Object)sqlCmd);
            }
            return affected;
        }
        catch (SQLIntegrityConstraintViolationException sqle) {
            throw new ConstraintViolationException(this.dbms, sqlCmd, sqle);
        }
        catch (SQLException sqle) {
            throw new StatementFailedException(this.dbms, sqlCmd, sqle);
        }
    }

    public ResultSet executeQuery(String sqlCmd, Object[] sqlParams, boolean scrollable) {
        try {
            this.logQueryStatement(sqlCmd, sqlParams);
            long start = System.currentTimeMillis();
            ResultSet rs = this.dbms.executeQuery(sqlCmd, sqlParams, scrollable, this.context.getConnection());
            if (rs == null) {
                throw new UnexpectedReturnValueException(rs, "dbms.executeQuery()");
            }
            long queryTime = System.currentTimeMillis() - start;
            if (log.isDebugEnabled()) {
                log.debug("executeQuery successful in {} ms", (Object)queryTime);
            } else if (queryTime >= this.longRunndingStmtThreshold) {
                log.warn("Long running query took {} seconds for statement {}.", (Object)(queryTime / 1000L), (Object)sqlCmd);
            }
            return rs;
        }
        catch (SQLException sqle) {
            throw new QueryFailedException(this.dbms, sqlCmd, sqle);
        }
    }

    public Object querySingleValue(String sqlCmd, Object[] sqlParams, DataType dataType, boolean failOnNoResult) {
        this.logQueryStatement(sqlCmd, sqlParams);
        long start = System.currentTimeMillis();
        Object result = this.dbms.querySingleValue(sqlCmd, sqlParams, dataType, this.context.getConnection());
        if (result == ObjectUtils.NO_VALUE) {
            if (failOnNoResult) {
                throw new QueryNoResultException(sqlCmd);
            }
            result = null;
        }
        long queryTime = System.currentTimeMillis() - start;
        if (log.isDebugEnabled()) {
            log.debug("querySingleValue successful in {} ms. Result value={}.", (Object)queryTime, result);
        } else if (queryTime >= this.longRunndingStmtThreshold) {
            log.warn("Long running query took {} seconds for statement {}.", (Object)(queryTime / 1000L), (Object)sqlCmd);
        }
        return result;
    }

    public final <T> T querySingleValue(DBCommandExpr cmd, Class<T> resultType, boolean failOnNoResult) {
        Object value = this.querySingleValue(cmd.getSelect(), cmd.getParamValues(), cmd.getDataType(), failOnNoResult);
        return ObjectUtils.convert(resultType, value);
    }

    public final Object querySingleValue(DBCommandExpr cmd, boolean failOnNoResult) {
        return this.querySingleValue(cmd.getSelect(), cmd.getParamValues(), cmd.getDataType(), failOnNoResult);
    }

    public final Object querySingleValue(DBCommandExpr cmd) {
        return this.querySingleValue(cmd, true);
    }

    public final int querySingleInt(String sqlCmd, Object[] sqlParams, int defaultValue) {
        Object value = this.querySingleValue(sqlCmd, sqlParams, DataType.INTEGER, false);
        return ObjectUtils.getInteger(value, defaultValue);
    }

    public final int querySingleInt(DBCommandExpr cmd, int defaultValue) {
        Object value = this.querySingleValue(cmd.getSelect(), cmd.getParamValues(), DataType.INTEGER, false);
        return ObjectUtils.getInteger(value, defaultValue);
    }

    public final int querySingleInt(DBCommandExpr cmd) {
        Object value = this.querySingleValue(cmd.getSelect(), cmd.getParamValues(), DataType.INTEGER, true);
        return ObjectUtils.getInteger(value);
    }

    public final long querySingleLong(String sqlCmd, Object[] sqlParams, long defaultValue) {
        Object value = this.querySingleValue(sqlCmd, sqlParams, DataType.INTEGER, false);
        return ObjectUtils.getLong(value, defaultValue);
    }

    public final long querySingleLong(DBCommandExpr cmd, long defaultValue) {
        Object value = this.querySingleValue(cmd.getSelect(), cmd.getParamValues(), DataType.INTEGER, false);
        return ObjectUtils.getLong(value, defaultValue);
    }

    public final long querySingleLong(DBCommandExpr cmd) {
        Object value = this.querySingleValue(cmd.getSelect(), cmd.getParamValues(), DataType.INTEGER, true);
        return ObjectUtils.getLong(value);
    }

    public final String querySingleString(DBCommandExpr cmd, String defaultValue) {
        Object value = this.querySingleValue(cmd.getSelect(), cmd.getParamValues(), DataType.VARCHAR, false);
        return StringUtils.toString(value, defaultValue);
    }

    public final String querySingleString(DBCommandExpr cmd) {
        Object value = this.querySingleValue(cmd.getSelect(), cmd.getParamValues(), DataType.VARCHAR, true);
        return StringUtils.toString(value);
    }

    public int queryRowCount(DBCommand cmd) {
        if (cmd == null || !cmd.isValid()) {
            return 0;
        }
        boolean aggregate = false;
        DBColumnExpr[] exprList = cmd.getSelectExprList();
        for (int i = 0; i < exprList.length; ++i) {
            if (!exprList[i].isAggregate()) continue;
            aggregate = true;
            break;
        }
        if (aggregate) {
            DBCommand subCmd = cmd.clone();
            subCmd.clearOrderBy();
            String sql = "SELECT COUNT(*) FROM (" + subCmd.getSelect() + ") q";
            return this.querySingleInt(sql, null, 0);
        }
        DBRowSet rs = exprList[0].getSourceColumn().getRowSet();
        DBCommand countCmd = cmd.clone();
        countCmd.clearSelect();
        countCmd.clearOrderBy();
        countCmd.select(rs.count());
        return this.querySingleInt(countCmd);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> int querySimpleList(Class<T> c, String sqlCmd, Object[] sqlParams, DataType dataType, Collection<T> result, int maxRows) {
        int n;
        ResultSet rs = null;
        try {
            int count;
            this.logQueryStatement(sqlCmd, sqlParams);
            long start = System.currentTimeMillis();
            rs = this.dbms.executeQuery(sqlCmd, sqlParams, false, this.context.getConnection());
            if (rs == null) {
                throw new UnexpectedReturnValueException(rs, "dbms.executeQuery()");
            }
            for (count = 0; rs.next() && (maxRows < 0 || count < maxRows); ++count) {
                T item = ObjectUtils.convert(c, this.dbms.getResultValue(rs, 1, dataType));
                result.add(item);
            }
            long queryTime = System.currentTimeMillis() - start;
            if (log.isDebugEnabled()) {
                log.debug("querySimpleList retured {} items in {} ms.", (Object)count, (Object)queryTime);
            } else if (queryTime >= this.longRunndingStmtThreshold) {
                log.warn("Long running query took {} seconds for statement {}.", (Object)(queryTime / 1000L), (Object)sqlCmd);
            }
            n = count;
        }
        catch (ClassCastException e) {
            try {
                log.error("querySingleValue cast exception: ", (Throwable)e);
                throw new InternalException(e);
                catch (SQLException sqle) {
                    throw new QueryFailedException(this.dbms, sqlCmd, sqle);
                }
            }
            catch (Throwable throwable) {
                this.dbms.closeResultSet(rs);
                throw throwable;
            }
        }
        this.dbms.closeResultSet(rs);
        return n;
    }

    public final <T> int querySimpleList(Class<T> c, DBCommandExpr cmd, Collection<T> result) {
        return this.querySimpleList(c, cmd.getSelect(), cmd.getParamValues(), cmd.getDataType(), result, this.MAX_QUERY_ROWS);
    }

    public final <T> List<T> querySimpleList(Class<T> c, DBCommandExpr cmd) {
        ArrayList result = new ArrayList();
        if (this.querySimpleList(c, cmd, result) < 0) {
            return null;
        }
        return result;
    }

    public final List<Object> querySimpleList(DBCommandExpr cmd) {
        return this.querySimpleList(Object.class, cmd);
    }

    public int queryOptionList(String sqlCmd, Object[] sqlParams, Options options) {
        ResultSet rs = null;
        try {
            this.logQueryStatement(sqlCmd, sqlParams);
            long start = System.currentTimeMillis();
            rs = this.dbms.executeQuery(sqlCmd, sqlParams, false, this.context.getConnection());
            if (rs == null) {
                throw new UnexpectedReturnValueException(rs, "dbms.executeQuery()");
            }
            if (rs.getMetaData().getColumnCount() < 2) {
                throw new InvalidArgumentException("sqlCmd", sqlCmd);
            }
            int count = 0;
            while (rs.next()) {
                Object value = rs.getObject(1);
                String text = rs.getString(2);
                options.add(value, text, true);
                ++count;
            }
            long queryTime = System.currentTimeMillis() - start;
            if (log.isDebugEnabled()) {
                log.debug("queryOptionList retured {} items in {} ms.", (Object)count, (Object)queryTime);
            } else if (queryTime >= this.longRunndingStmtThreshold) {
                log.warn("Long running query took {} seconds for statement {}.", (Object)(queryTime / 1000L), (Object)sqlCmd);
            }
            int n = count;
            this.dbms.closeResultSet(rs);
            return n;
        }
        catch (SQLException sqle) {
            try {
                throw new QueryFailedException(this.dbms, sqlCmd, sqle);
            }
            catch (Throwable throwable) {
                this.dbms.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    public final int queryOptionList(DBCommandExpr cmd, Options options) {
        return this.queryOptionList(cmd.getSelect(), cmd.getParamValues(), options);
    }

    public final Options queryOptionList(DBCommandExpr cmd) {
        Options options = new Options();
        this.queryOptionList(cmd.getSelect(), cmd.getParamValues(), options);
        return options;
    }

    public int queryObjectList(String sqlCmd, Object[] sqlParams, Collection<Object[]> result, int maxRows) {
        ResultSet rs = null;
        try {
            int count;
            this.logQueryStatement(sqlCmd, sqlParams);
            long start = System.currentTimeMillis();
            rs = this.dbms.executeQuery(sqlCmd, sqlParams, false, this.context.getConnection());
            if (rs == null) {
                throw new UnexpectedReturnValueException(rs, "dbms.executeQuery()");
            }
            int colCount = rs.getMetaData().getColumnCount();
            for (count = 0; rs.next() && (maxRows < 0 || count < maxRows); ++count) {
                Object[] item = new Object[colCount];
                for (int i = 0; i < colCount; ++i) {
                    item[i] = this.dbms.getResultValue(rs, i + 1, DataType.UNKNOWN);
                }
                result.add(item);
            }
            long queryTime = System.currentTimeMillis() - start;
            if (log.isDebugEnabled()) {
                log.debug("queryObjectList retured {} items in {} ms.", (Object)count, (Object)queryTime);
            } else if (queryTime >= this.longRunndingStmtThreshold) {
                log.warn("Long running query took {} seconds for statement {}.", (Object)(queryTime / 1000L), (Object)sqlCmd);
            }
            int n = count;
            this.dbms.closeResultSet(rs);
            return n;
        }
        catch (SQLException sqle) {
            try {
                throw new QueryFailedException(this.dbms, sqlCmd, sqle);
            }
            catch (Throwable throwable) {
                this.dbms.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    public final List<Object[]> queryObjectList(DBCommandExpr cmd) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        this.queryObjectList(cmd.getSelect(), cmd.getParamValues(), result, this.MAX_QUERY_ROWS);
        return result;
    }

    public Object[] querySingleRow(String sqlCmd, Object[] sqlParams) {
        ArrayList<Object[]> result = new ArrayList<Object[]>(1);
        this.queryObjectList(sqlCmd, sqlParams, result, 1);
        if (result.size() < 1) {
            throw new QueryNoResultException(sqlCmd);
        }
        return (Object[])result.get(0);
    }

    public final Object[] querySingleRow(DBCommandExpr cmd) {
        return this.querySingleRow(cmd.getSelect(), cmd.getParamValues());
    }

    protected void queryRowLimitExeeded() {
        log.warn("********************************************************");
        log.warn("Query Result was limited to {} by MAX_QUERY_ROWS", (Object)this.MAX_QUERY_ROWS);
        log.warn("********************************************************");
    }

    protected <T extends DataListEntry> DataListFactory<T> createDefaultDataListFactory(Class<T> entryClass, DataListHead head) {
        return new DataListFactoryImpl<T>(entryClass, head);
    }

    protected DataListHead createDefaultDataListHead(DBCommandExpr cmd, Class<? extends DataListEntry> entryClass) {
        return new DataListHead(cmd.getSelectExprList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DataListEntry> List<T> queryDataList(DBCommandExpr cmd, DataListFactory<T> factory, int first, int pageSize) {
        List<T> list = null;
        DBReader r = new DBReader(this.context);
        try {
            factory.prepareQuery(cmd, this.context);
            if (pageSize == 0) {
                log.warn("PageSize must not be 0. Setting to -1 for all records!");
                pageSize = -1;
            }
            DBMSHandler dbms = this.context.getDbms();
            if (pageSize > 0 && dbms.isSupported(DBMSFeature.QUERY_LIMIT_ROWS)) {
                if (first > 0 && dbms.isSupported(DBMSFeature.QUERY_SKIP_ROWS)) {
                    cmd.skipRows(first);
                    first = 0;
                }
                cmd.limitRows(first + pageSize);
            }
            r.open(cmd);
            if (first > 0) {
                r.skipRows(first);
            }
            int maxCount = pageSize >= 0 ? pageSize : this.MAX_QUERY_ROWS;
            list = factory.newList(pageSize >= 0 ? pageSize : 10);
            int rownum = 0;
            while (r.moveNext() && maxCount != 0) {
                T entry = factory.newEntry(rownum, r);
                if (entry == null) continue;
                list.add(entry);
                ++rownum;
                if (maxCount <= 0) continue;
                --maxCount;
            }
            if (rownum == this.MAX_QUERY_ROWS) {
                this.queryRowLimitExeeded();
            }
            List<T> list2 = list;
            return list2;
        }
        finally {
            r.close();
            if (list != null) {
                factory.completeQuery(list);
            }
        }
    }

    public final <T extends DataListEntry> List<T> queryDataList(DBCommandExpr cmd, Class<T> entryClass, DataListHead head) {
        return this.queryDataList(cmd, this.createDefaultDataListFactory(entryClass, head), 0, -1);
    }

    public final <T extends DataListEntry> List<T> queryDataList(DBCommandExpr cmd, Class<T> entryClass) {
        return this.queryDataList(cmd, entryClass, this.createDefaultDataListHead(cmd, entryClass));
    }

    public final <T extends DataListEntry> List<T> queryDataList(DBCommandExpr cmd, Class<T> entryClass, int first, int maxItems) {
        return this.queryDataList(cmd, this.createDefaultDataListFactory(entryClass, this.createDefaultDataListHead(cmd, entryClass)), first, maxItems);
    }

    public final List<DataListEntry> queryDataList(DBCommandExpr cmd) {
        return this.queryDataList(cmd, DataListEntry.class);
    }

    public final List<DataListEntry> queryDataList(DBCommandExpr cmd, int first, int maxItems) {
        return this.queryDataList(cmd, DataListEntry.class, first, maxItems);
    }

    public final <T extends DataListEntry> T queryDataEntry(DBCommandExpr cmd, Class<T> entryClass, boolean failOnNoResult) {
        DataListHead head = this.createDefaultDataListHead(cmd, entryClass);
        List<T> dle = this.queryDataList(cmd, this.createDefaultDataListFactory(entryClass, head), 0, 1);
        if (dle.isEmpty()) {
            if (failOnNoResult) {
                throw new QueryNoResultException(cmd.getSelect());
            }
            return null;
        }
        return (T)((DataListEntry)dle.get(0));
    }

    public final <T extends DataListEntry> T queryDataEntry(DBCommandExpr cmd, Class<T> entryClass) {
        return this.queryDataEntry(cmd, entryClass, true);
    }

    public final DataListEntry queryDataEntry(DBCommandExpr cmd) {
        return this.queryDataEntry(cmd, DataListEntry.class);
    }

    protected <R extends DBRecordBase> DBRecordListFactory<R> createDefaultRecordListFactory(Class<R> recordClass, DBRowSet rowset) {
        return new DBRecordListFactoryImpl<R>(recordClass, this.context.getClass(), rowset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends DBRecordBase> List<R> queryRecordList(DBCommand cmd, DBRecordListFactory<R> factory, int first, int pageSize) {
        List<R> list = null;
        DBReader r = new DBReader(this.context);
        try {
            factory.prepareQuery(cmd, this.context);
            if (pageSize == 0) {
                log.warn("PageSize must not be 0. Setting to -1 for all records!");
                pageSize = -1;
            }
            DBMSHandler dbms = this.context.getDbms();
            if (pageSize > 0 && dbms.isSupported(DBMSFeature.QUERY_LIMIT_ROWS)) {
                if (first > 0 && dbms.isSupported(DBMSFeature.QUERY_SKIP_ROWS)) {
                    cmd.skipRows(first);
                    first = 0;
                }
                cmd.limitRows(first + pageSize);
            }
            r.open(cmd);
            if (first > 0) {
                r.skipRows(first);
            }
            int maxCount = pageSize >= 0 ? pageSize : this.MAX_QUERY_ROWS;
            list = factory.newList(pageSize >= 0 ? pageSize : this.DEFAULT_LIST_CAPACITY);
            int rownum = 0;
            while (r.moveNext() && maxCount != 0) {
                R entry = factory.newRecord(rownum, r);
                if (entry == null) continue;
                if (((DBRecordBase)entry).isValid()) {
                    list.add(entry);
                    ++rownum;
                } else {
                    log.trace("Record {} is not valid thus it will not be added to the RecordListQuery.", (Object)rownum);
                }
                if (maxCount <= 0) continue;
                --maxCount;
            }
            if (rownum == this.MAX_QUERY_ROWS) {
                this.queryRowLimitExeeded();
            }
            List<R> list2 = list;
            return list2;
        }
        finally {
            r.close();
            if (list != null) {
                factory.completeQuery(list);
            }
        }
    }

    public final <R extends DBRecordBase> List<R> queryRecordList(DBCommand cmd, DBRowSet rowset, Class<R> recordType) {
        DBRecordListFactory<R> factory = this.createDefaultRecordListFactory(recordType, rowset);
        return this.queryRecordList(cmd, factory, 0, -1);
    }

    public final List<DBRecord> queryRecordList(DBCommand cmd, DBRowSet rowset) {
        return this.queryRecordList(cmd, rowset, DBRecord.class);
    }

    protected <T> DBBeanListFactory<T> createDefaultBeanListFactory(Class<T> beanType, Column[] keyColumns, List<? extends DBColumnExpr> selectColumns) {
        return new DBBeanListFactoryImpl<T>(beanType, keyColumns, selectColumns);
    }

    public synchronized <T> DBBeanListFactory<T> getRowsetBeanListFactory(Class<T> beanType, DBRowSet rowset) {
        DBBeanListFactory<T> factory = DBBeanFactoryCache.getFactoryForType(beanType);
        if (factory == null) {
            log.debug("No factory found for bean type '{}' and rowset {}. Creating default", (Object)beanType.getName(), (Object)rowset.getName());
            factory = this.createDefaultBeanListFactory(beanType, rowset.getKeyColumns(), rowset.getColumns());
            DBBeanFactoryCache.setFactoryForType(beanType, factory);
        }
        return factory;
    }

    public synchronized <T> DBBeanListFactory<T> getCommandBeanListFactory(Class<T> beanType, DBCommandExpr cmd) {
        DBBeanListFactory<T> factory = DBBeanFactoryCache.getFactoryForType(beanType);
        if (factory == null) {
            if (!cmd.hasSelectExpr()) {
                throw new CommandWithoutSelectException(cmd);
            }
            log.debug("No factory found for bean type '{}'. Creating default", (Object)beanType.getName());
            factory = this.createDefaultBeanListFactory(beanType, null, cmd.getSelectExpressions());
            DBBeanFactoryCache.setFactoryForType(beanType, factory);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> queryBeanList(DBCommandExpr cmd, DBBeanListFactory<T> factory, Object parent, int first, int pageSize) {
        List<T> list = null;
        DBReader r = new DBReader(this.context);
        try {
            factory.prepareQuery(cmd, this.context);
            if (pageSize == 0) {
                log.warn("PageSize must not be 0. Setting to -1 for all records!");
                pageSize = -1;
            }
            DBMSHandler dbms = this.context.getDbms();
            if (pageSize > 0 && dbms.isSupported(DBMSFeature.QUERY_LIMIT_ROWS)) {
                if (first > 0 && dbms.isSupported(DBMSFeature.QUERY_SKIP_ROWS)) {
                    cmd.skipRows(first);
                    first = 0;
                }
                cmd.limitRows(first + pageSize);
            }
            r.open(cmd);
            if (first > 0) {
                r.skipRows(first);
            }
            int maxCount = pageSize >= 0 ? pageSize : this.MAX_QUERY_ROWS;
            list = factory.newList(pageSize >= 0 ? pageSize : this.DEFAULT_LIST_CAPACITY);
            int rownum = 0;
            while (r.moveNext() && maxCount != 0) {
                T item = factory.newItem(rownum, r);
                if (item == null) continue;
                list.add(item);
                if (item instanceof DataBean) {
                    ((DataBean)item).initialize(r.getDatabase(), this.context, rownum, parent);
                }
                ++rownum;
                if (maxCount <= 0) continue;
                --maxCount;
            }
            if (rownum == this.MAX_QUERY_ROWS) {
                this.queryRowLimitExeeded();
            }
            List<T> list2 = list;
            return list2;
        }
        finally {
            r.close();
            if (list != null) {
                factory.completeQuery(list);
            }
        }
    }

    public final <T> List<T> queryBeanList(DBCommandExpr cmd, DBBeanListFactory<T> factory, Object parent) {
        return this.queryBeanList(cmd, factory, parent, 0, -1);
    }

    public <T> List<T> queryBeanList(DBCommandExpr cmd, Class<T> beanType, DBRowSet rowset, Object parent) {
        return this.queryBeanList(cmd, this.getRowsetBeanListFactory(beanType, rowset), parent, 0, -1);
    }

    public <T> List<T> queryBeanList(DBCommandExpr cmd, Class<T> beanType, Object parent) {
        return this.queryBeanList(cmd, this.getCommandBeanListFactory(beanType, cmd), parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T queryBean(DBCommandExpr cmd, DBBeanListFactory<T> factory) {
        DBReader r = new DBReader(this.context);
        try {
            factory.prepareQuery(cmd, this.context);
            r.getRecordData(cmd);
            T item = factory.newItem(-1, r);
            if (item instanceof DataBean) {
                ((DataBean)item).initialize(r.getDatabase(), this.context, -1, null);
            }
            T t = item;
            return t;
        }
        finally {
            r.close();
            factory.completeQuery(null);
        }
    }

    public <T> T queryBean(DBCommandExpr cmd, Class<T> beanType) {
        return this.queryBean(cmd, this.getCommandBeanListFactory(beanType, cmd));
    }

    public final <T> T queryBean(Class<T> beanType, DBRowSet rowset, DBCompareExpr whereConstraints) {
        DBObject.checkParamNull("rowset", rowset);
        DBObject.checkParamNull("whereConstraints", whereConstraints);
        DBCommand cmd = this.context.createCommand();
        cmd.where(whereConstraints);
        return this.queryBean((DBCommandExpr)cmd, this.getRowsetBeanListFactory(beanType, rowset));
    }

    public final <T> T queryBean(Class<T> beanType, DBCompareExpr whereConstraints) {
        DBObject.checkParamNull("whereConstraints", whereConstraints);
        DBBeanListFactory<T> factory = DBBeanFactoryCache.getFactoryForType(beanType);
        if (factory == null) {
            throw new UnknownBeanTypeException(beanType);
        }
        DBCommand cmd = this.context.createCommand();
        cmd.where(whereConstraints);
        return this.queryBean((DBCommandExpr)cmd, factory);
    }

    public final <T> T queryBean(Class<T> beanType, DBRowSet rowset, Object[] key) {
        DBObject.checkParamNull("rowset", rowset);
        DBObject.checkParamNull("key", key);
        DBCommand cmd = this.context.createCommand();
        cmd.where(rowset.getKeyConstraints(key));
        return this.queryBean((DBCommandExpr)cmd, this.getRowsetBeanListFactory(beanType, rowset));
    }
}

