/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBIndex;
import org.apache.empire.exceptions.InvalidArgumentException;

public class DBExpressionIndex
extends DBIndex {
    private DBExpr[] columnExpressions;

    public DBExpressionIndex(String name, DBIndex.DBIndexType type, DBExpr ... columnExpressions) {
        super(name, type, null);
        if (columnExpressions == null || columnExpressions.length == 0) {
            throw new InvalidArgumentException("columnExpressions", columnExpressions);
        }
        this.columnExpressions = columnExpressions;
    }

    public DBExpressionIndex(String name, boolean unique, DBExpr ... columnExpressions) {
        this(name, unique ? DBIndex.DBIndexType.UNIQUE : DBIndex.DBIndexType.STANDARD, columnExpressions);
    }

    @Override
    public final DBDatabase getDatabase() {
        return this.columnExpressions[0].getDatabase();
    }

    @Override
    public DBExpr[] getExpressions() {
        return this.columnExpressions;
    }

    @Override
    public boolean contains(DBColumn col) {
        for (DBExpr columnExpression : this.columnExpressions) {
            if (!(columnExpression instanceof DBColumnExpr) || !col.equals(((DBColumnExpr)columnExpression).getUpdateColumn())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnPos(DBColumn col) {
        return -1;
    }
}

