/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.Collection;
import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBExpr
extends DBObject {
    private static final Logger log = LoggerFactory.getLogger(DBExpr.class);
    public static final long CTX_DEFAULT = 7L;
    public static final long CTX_ALL = 15L;
    public static final long CTX_NAME = 1L;
    public static final long CTX_FULLNAME = 2L;
    public static final long CTX_VALUE = 4L;
    public static final long CTX_ALIAS = 8L;
    public static final long CTX_NOPARENTHESES = 16L;

    public abstract void addSQL(StringBuilder var1, long var2);

    public abstract void addReferencedColumns(Set<DBColumn> var1);

    protected String getObjectValue(DataType dataType, Object value, long context, String arraySep) {
        if (value instanceof DBExpr) {
            StringBuilder buf = new StringBuilder();
            ((DBExpr)value).addSQL(buf, context);
            return buf.toString();
        }
        if (value instanceof OptionEntry) {
            value = ((OptionEntry)value).getValue();
        }
        if (value instanceof Enum) {
            value = ObjectUtils.getEnumValue((Enum)value, dataType.isNumeric());
        } else if (value instanceof Collection) {
            value = ((Collection)value).toArray();
        }
        if (value != null && value.getClass().isArray()) {
            StringBuilder buf = new StringBuilder();
            Object[] array = value;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0 && arraySep != null) {
                    buf.append(arraySep);
                }
                buf.append(this.getObjectValue(dataType, array[i], context, arraySep));
            }
            return buf.toString();
        }
        Object dbms = ((DBDatabase)this.getDatabase()).getDbms();
        if (dbms == null) {
            log.warn("No dbms set for getting object value. Using default!");
            return String.valueOf(value);
        }
        return dbms.getValueString(value, dataType);
    }
}

