/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.data.bean;

import java.util.Collections;
import java.util.Set;
import org.apache.empire.commons.Attributes;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataType;
import org.apache.empire.data.bean.BeanClass;
import org.apache.empire.db.exceptions.FieldNotNullException;

public class BeanProperty
implements Column {
    private final String name;
    private final DataType dataType;
    private final double size;
    private final boolean required;
    private String controlType;
    private String title;
    private Options options;
    private Attributes attributes;
    private boolean readOnly;
    protected BeanClass beanClass;

    public BeanProperty(String name, DataType dataType, double size, boolean required, String controlType, boolean readOnly) {
        this.name = name;
        this.dataType = dataType;
        this.size = size;
        this.required = required;
        this.controlType = controlType;
        this.readOnly = readOnly;
    }

    public BeanProperty(String name, DataType dataType, double size, boolean required, String controlType) {
        this(name, dataType, size, required, controlType, false);
    }

    public BeanProperty(String name, DataType dataType, double size, boolean required) {
        this(name, dataType, size, required, "text", false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : null;
    }

    @Override
    public Set<Attributes.Attribute> getAttributes() {
        return this.attributes != null ? Collections.unmodifiableSet(this.attributes) : Collections.EMPTY_SET;
    }

    @Override
    public String getTitle() {
        if (this.title == null) {
            return this.name;
        }
        return this.title;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return this.attributes != null ? (Class)this.getAttribute("enumType") : null;
    }

    @Override
    public String getControlType() {
        return this.controlType;
    }

    @Override
    public String getBeanPropertyName() {
        return this.name;
    }

    @Override
    public Column getSourceColumn() {
        return this;
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly || this.dataType == DataType.AUTOINC;
    }

    @Override
    public boolean isAutoGenerated() {
        return this.dataType == DataType.AUTOINC;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public Object validateValue(Object value) {
        if (ObjectUtils.isEmpty(value) && this.isRequired()) {
            throw new FieldNotNullException(this);
        }
        return value;
    }

    public BeanClass getBeanClass() {
        return this.beanClass;
    }

    public void setControlType(String controlType) {
        this.controlType = controlType;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        this.attributes.set(name, value);
    }
}

