/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.empire.commons.DateUtils;
import org.apache.empire.commons.EnumValue;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.commons.Unwrappable;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidValueException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectUtils {
    public static final NoValue NO_VALUE = new NoValue();
    private static final Logger log = LoggerFactory.getLogger(ObjectUtils.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final ThreadLocal<SimpleDateFormat> dateOnlyFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(ObjectUtils.DATE_FORMAT);
        }
    };
    private static final ThreadLocal<SimpleDateFormat> dateTimeFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(ObjectUtils.DATETIME_FORMAT);
        }
    };
    private static final String NULL = "NULL";

    private ObjectUtils() {
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o == NO_VALUE) {
            throw new InvalidValueException(o);
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        if (o instanceof Object[] && ((Object[])o).length == 0) {
            return true;
        }
        return o instanceof Collection && ((Collection)o).isEmpty();
    }

    public static boolean isNotEmpty(Object o) {
        return !ObjectUtils.isEmpty(o);
    }

    public static boolean isZero(Number value) {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return BigDecimal.ZERO.compareTo((BigDecimal)value) == 0;
        }
        if (value instanceof Float) {
            return ((Float)value).compareTo(Float.valueOf(0.0f)) == 0;
        }
        if (value instanceof Double) {
            return ((Float)value).compareTo(Float.valueOf(0.0f)) == 0;
        }
        if (value instanceof Long) {
            return value.longValue() == 0L;
        }
        return value.intValue() == 0;
    }

    public static boolean isNonZero(Number value) {
        return !ObjectUtils.isZero(value);
    }

    public static int lengthOf(Object o) {
        if (o == null || o == NO_VALUE) {
            return 0;
        }
        if (o instanceof String) {
            return ((String)o).length();
        }
        return o.toString().length();
    }

    public static boolean compareEqual(Object o1, Object o2) {
        String strVal;
        if (o1 == o2) {
            return true;
        }
        if (ObjectUtils.isEmpty(o1)) {
            return ObjectUtils.isEmpty(o2);
        }
        if (ObjectUtils.isEmpty(o2)) {
            return ObjectUtils.isEmpty(o1);
        }
        if (o1.getClass().equals(o2.getClass())) {
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2) == 0;
            }
            return o1.equals(o2);
        }
        if (o1.equals(o2) || o2.equals(o1)) {
            return true;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            double d2;
            double d1 = ((Number)o1).doubleValue();
            return d1 == (d2 = ((Number)o2).doubleValue());
        }
        if (o1 instanceof Temporal && o2 instanceof java.util.Date) {
            Object tmp = o2;
            o2 = o1;
            o1 = tmp;
        }
        if (o1 instanceof java.util.Date && o2 instanceof LocalDate) {
            return o1.equals(DateUtils.toDate((LocalDate)o2));
        }
        if (o1 instanceof java.util.Date && o2 instanceof LocalDateTime) {
            return o1.equals(DateUtils.toDate((LocalDateTime)o2));
        }
        if (o1 instanceof Enum) {
            if (o2 instanceof Number) {
                return ((Enum)o1).ordinal() == ((Number)o2).intValue();
            }
            strVal = StringUtils.coalesce(ObjectUtils.getString((Enum)o1), NULL);
            return strVal.equals(ObjectUtils.getString(o2));
        }
        if (o2 instanceof Enum) {
            if (o1 instanceof Number) {
                return ((Enum)o2).ordinal() == ((Number)o1).intValue();
            }
            strVal = StringUtils.coalesce(ObjectUtils.getString((Enum)o2), NULL);
            return strVal.equals(ObjectUtils.getString(o1));
        }
        return o1.toString().equals(o2.toString());
    }

    public static boolean compareEqual(Object[] array1, Object[] array2) {
        int len2;
        int len1 = array1 != null ? array1.length : 0;
        int n = len2 = array2 != null ? array2.length : 0;
        if (len1 != len2) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (ObjectUtils.compareEqual(array1[i], array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean compareEqual(ColumnExpr expr, ColumnExpr other) {
        if (ObjectUtils.isWrapper(other) && !ObjectUtils.isWrapper(expr)) {
            return expr.equals(ObjectUtils.unwrap(other));
        }
        if (!ObjectUtils.isWrapper(other) && ObjectUtils.isWrapper(expr)) {
            return ObjectUtils.unwrap(expr).equals(other);
        }
        return expr.equals(other);
    }

    public static <T> T coalesce(T preferred, T alternative) {
        return preferred != null ? preferred : alternative;
    }

    public static int toInteger(Object v) {
        if (ObjectUtils.isEmpty(v)) {
            return 0;
        }
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        String str = v.toString();
        return Integer.parseInt(str);
    }

    public static int getInteger(Object v, int defValue) {
        if (ObjectUtils.isEmpty(v)) {
            return defValue;
        }
        try {
            return ObjectUtils.toInteger(v);
        }
        catch (NumberFormatException e) {
            log.error(String.format("Cannot convert value [%s] to int", v));
            return defValue;
        }
    }

    public static int getInteger(Object v) {
        return ObjectUtils.getInteger(v, 0);
    }

    public static long toLong(Object v) {
        if (ObjectUtils.isEmpty(v)) {
            return 0L;
        }
        if (v instanceof Number) {
            return ((Number)v).longValue();
        }
        String str = v.toString();
        return Long.parseLong(str);
    }

    public static long getLong(Object v, long defValue) {
        if (ObjectUtils.isEmpty(v)) {
            return defValue;
        }
        try {
            return ObjectUtils.toLong(v);
        }
        catch (NumberFormatException e) {
            log.error(String.format("Cannot convert value [%s] to long", v));
            return defValue;
        }
    }

    public static long getLong(Object v) {
        return ObjectUtils.getLong(v, 0L);
    }

    public static double toDouble(Object v) {
        if (ObjectUtils.isEmpty(v)) {
            return 0.0;
        }
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        String val = v.toString();
        return Double.parseDouble(val);
    }

    public static double getDouble(Object v, double defValue) {
        if (ObjectUtils.isEmpty(v)) {
            return defValue;
        }
        try {
            return ObjectUtils.toDouble(v);
        }
        catch (NumberFormatException e) {
            log.error(String.format("Cannot convert value [%s] to double", v));
            return defValue;
        }
    }

    public static double getDouble(Object v) {
        return ObjectUtils.getDouble(v, 0.0);
    }

    public static BigDecimal toDecimal(Object v) {
        if (ObjectUtils.isEmpty(v)) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        if (v instanceof Number) {
            if (v instanceof BigInteger) {
                return new BigDecimal((BigInteger)v);
            }
            if (v instanceof Integer) {
                return BigDecimal.valueOf(((Number)v).intValue());
            }
            if (v instanceof Long) {
                return BigDecimal.valueOf(((Number)v).longValue());
            }
            return BigDecimal.valueOf(((Number)v).doubleValue());
        }
        return new BigDecimal(v.toString());
    }

    public static BigDecimal getDecimal(Object v, BigDecimal defValue) {
        if (ObjectUtils.isEmpty(v)) {
            return defValue;
        }
        try {
            return ObjectUtils.toDecimal(v);
        }
        catch (NumberFormatException e) {
            log.error(String.format("Cannot convert value [%s] to BigDecimal", v));
            return defValue;
        }
    }

    public static BigDecimal getDecimal(Object v) {
        return ObjectUtils.getDecimal(v, BigDecimal.ZERO);
    }

    public static boolean getBoolean(Object v) {
        if (ObjectUtils.isEmpty(v)) {
            return false;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof Number) {
            return ((Number)v).intValue() != 0;
        }
        String val = v.toString();
        return val.equalsIgnoreCase("Y") || val.equalsIgnoreCase("true");
    }

    public static <T extends Enum<?>> T getEnum(Class<T> enumType, Object value) {
        if (ObjectUtils.isEmpty(value)) {
            return null;
        }
        if (value instanceof Enum) {
            if (value.getClass().equals(enumType)) {
                return (T)((Enum)value);
            }
            value = ((Enum)value).name();
        }
        boolean numeric = value instanceof Number;
        Enum[] items = (Enum[])enumType.getEnumConstants();
        if (items.length > 0 && items[0] instanceof EnumValue) {
            for (Enum e : items) {
                Object eVal = ((EnumValue)((Object)e)).toValue(numeric);
                if (!ObjectUtils.compareEqual(eVal, value)) continue;
                return (T)e;
            }
            throw new ItemNotFoundException((Object)StringUtils.toString(value));
        }
        if (numeric) {
            int ordinal = ((Number)value).intValue();
            if (ordinal < 0 || ordinal >= items.length) {
                throw new ItemNotFoundException((Object)String.valueOf(ordinal));
            }
            return (T)items[ordinal];
        }
        String name = StringUtils.toString(value);
        for (Enum e : items) {
            if (!e.name().equals(name)) continue;
            return (T)e;
        }
        throw new ItemNotFoundException((Object)name);
    }

    public static <T extends Enum<?>> T getEnumByName(Class<T> enumType, String name) {
        Enum[] items;
        if (ObjectUtils.isEmpty(name)) {
            return null;
        }
        for (Enum e : items = (Enum[])enumType.getEnumConstants()) {
            if (!e.name().equals(name)) continue;
            return (T)e;
        }
        throw new ItemNotFoundException((Object)name);
    }

    public static Object getEnumValue(Enum<?> enumValue, boolean isNumeric) {
        if (enumValue instanceof EnumValue) {
            return ((EnumValue)((Object)enumValue)).toValue(isNumeric);
        }
        return isNumeric ? Integer.valueOf(enumValue.ordinal()) : ObjectUtils.getString(enumValue);
    }

    public static String getString(Enum<?> enumValue) {
        if (enumValue instanceof EnumValue) {
            return StringUtils.toString(((EnumValue)((Object)enumValue)).toValue(false));
        }
        if (enumValue == null || enumValue.name().equals(NULL)) {
            return null;
        }
        return enumValue.name();
    }

    public static String getString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value == NO_VALUE) {
            throw new InvalidValueException(value);
        }
        if (value instanceof Enum) {
            return ObjectUtils.getString((Enum)value);
        }
        if (value instanceof java.util.Date) {
            return ObjectUtils.formatDate((java.util.Date)value, true);
        }
        return value.toString();
    }

    public static java.util.Date toDate(Object v) throws ParseException {
        if (ObjectUtils.isEmpty(v)) {
            return null;
        }
        if (v instanceof java.util.Date) {
            return (java.util.Date)v;
        }
        if (v instanceof LocalDate) {
            return DateUtils.toDate((LocalDate)v);
        }
        if (v instanceof LocalDateTime) {
            return DateUtils.toDate((LocalDateTime)v);
        }
        String str = v.toString();
        if (str.length() > 10) {
            return dateTimeFormatter.get().parse(str);
        }
        return dateOnlyFormatter.get().parse(str);
    }

    public static java.util.Date getDate(Object v, Locale locale) {
        if (ObjectUtils.isEmpty(v)) {
            return null;
        }
        if (v instanceof java.util.Date) {
            return (java.util.Date)v;
        }
        if (v instanceof LocalDate) {
            return DateUtils.toDate((LocalDate)v);
        }
        if (v instanceof LocalDateTime) {
            return DateUtils.toDate((LocalDateTime)v);
        }
        if (v instanceof Number) {
            long l = ((Number)v).longValue();
            if (l == 0L) {
                return DateUtils.getDateNow();
            }
            return new java.util.Date(l);
        }
        return DateUtils.parseDate(v.toString(), locale);
    }

    public static java.util.Date getDate(Object v) {
        if (ObjectUtils.isEmpty(v)) {
            return null;
        }
        if (v instanceof java.util.Date) {
            return (java.util.Date)v;
        }
        if (v instanceof LocalDate) {
            return DateUtils.toDate((LocalDate)v);
        }
        if (v instanceof LocalDateTime) {
            return DateUtils.toDate((LocalDateTime)v);
        }
        String str = v.toString();
        try {
            if (str.length() > 10) {
                return dateTimeFormatter.get().parse(str);
            }
            return dateOnlyFormatter.get().parse(str);
        }
        catch (ParseException e) {
            log.error(String.format("Cannot convert value [%s] to Date", str), (Throwable)e);
            return null;
        }
    }

    public static LocalDate getLocalDate(Object v) {
        if (ObjectUtils.isEmpty(v)) {
            return null;
        }
        if (v instanceof LocalDate) {
            return (LocalDate)v;
        }
        if (v instanceof LocalDateTime) {
            return ((LocalDateTime)v).toLocalDate();
        }
        if (v instanceof Timestamp) {
            return ((Timestamp)v).toLocalDateTime().toLocalDate();
        }
        if (v instanceof Date) {
            return ((Date)v).toLocalDate();
        }
        if (v instanceof java.util.Date) {
            return DateUtils.toLocalDate((java.util.Date)v);
        }
        String str = v.toString();
        try {
            return LocalDate.parse(str);
        }
        catch (DateTimeParseException e) {
            log.error(String.format("Cannot convert value [%s] to LocalDate", str), (Throwable)e);
            return null;
        }
    }

    public static LocalDateTime getLocalDateTime(Object v) {
        if (ObjectUtils.isEmpty(v)) {
            return null;
        }
        if (v instanceof LocalDate) {
            return ((LocalDate)v).atStartOfDay();
        }
        if (v instanceof LocalDateTime) {
            return (LocalDateTime)v;
        }
        if (v instanceof Timestamp) {
            return ((Timestamp)v).toLocalDateTime();
        }
        if (v instanceof Date) {
            return ((Date)v).toLocalDate().atStartOfDay();
        }
        if (v instanceof java.util.Date) {
            return DateUtils.toLocalDateTime((java.util.Date)v);
        }
        String str = v.toString();
        try {
            return LocalDateTime.parse(str);
        }
        catch (DateTimeParseException e) {
            log.error(String.format("Cannot convert value [%s] to LocalDateTime", str), (Throwable)e);
            return null;
        }
    }

    public static String formatDate(java.util.Date date, boolean withTime) {
        if (date == null) {
            return null;
        }
        if (withTime) {
            return dateTimeFormatter.get().format(date);
        }
        return dateOnlyFormatter.get().format(date);
    }

    public static <T> T convert(Class<T> c, Object v) throws ClassCastException {
        if (v == null || c.isInstance(v)) {
            return (T)v;
        }
        if (v == NO_VALUE) {
            throw new InvalidValueException(v);
        }
        if (c.isPrimitive()) {
            c = MethodUtils.getPrimitiveWrapper(c);
        }
        if (c.isEnum()) {
            T ev = ObjectUtils.getEnum(c, v);
            return ev;
        }
        if (c.isAssignableFrom(Boolean.class)) {
            return c.cast(ObjectUtils.getBoolean(v));
        }
        if (c.isAssignableFrom(Integer.class)) {
            return c.cast(ObjectUtils.getInteger(v));
        }
        if (c.isAssignableFrom(Long.class)) {
            return c.cast(ObjectUtils.getLong(v));
        }
        if (c.isAssignableFrom(Double.class)) {
            return c.cast(ObjectUtils.getDouble(v));
        }
        if (c.isAssignableFrom(BigDecimal.class)) {
            return c.cast(ObjectUtils.getDecimal(v));
        }
        if (c.isAssignableFrom(String.class)) {
            return c.cast(v.toString());
        }
        return c.cast(v);
    }

    public static boolean isAssignmentCompatible(Class<?> target, Class<?> source) {
        Class<Number> numberClass;
        if (target.isAssignableFrom(source)) {
            return true;
        }
        if (source.isPrimitive()) {
            if ((source = MethodUtils.getPrimitiveWrapper(source)) == null) {
                return false;
            }
            if (target.isAssignableFrom(source)) {
                return true;
            }
        }
        if (target.isPrimitive()) {
            if ((target = MethodUtils.getPrimitiveWrapper(target)) == null) {
                return false;
            }
            if (target.isAssignableFrom(source)) {
                return true;
            }
        }
        if ((numberClass = Number.class).isAssignableFrom(target) && numberClass.isAssignableFrom(source)) {
            return true;
        }
        return source == Character.class && target == String.class;
    }

    public static <T> List<T> convert(Class<T> t, Collection<? extends T> source) {
        if (source == null) {
            return null;
        }
        ArrayList<T> target = new ArrayList<T>(source.size());
        target.addAll(source);
        return target;
    }

    @SafeVarargs
    public static <T> T[] toArray(Class<T> t, T ... values) {
        if (values.length == 0) {
            throw new InvalidArgumentException("values", values);
        }
        return values;
    }

    public static <T> List<T> arrayToList(Class<T> t, T[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static String[] toStringArray(Object[] objArray, String defValue) {
        if (objArray == null) {
            return null;
        }
        String[] strArray = new String[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            strArray[i] = objArray[i] != null ? objArray[i].toString() : defValue;
        }
        return strArray;
    }

    public static boolean isWrapper(Object object) {
        return object instanceof Unwrappable && ((Unwrappable)object).isWrapper();
    }

    public static <T> T unwrap(T object) {
        if (object instanceof Unwrappable && ((Unwrappable)object).isWrapper()) {
            return ObjectUtils.unwrap(((Unwrappable)object).unwrap());
        }
        return object;
    }

    public static <T> int indexOf(T[] array, T item) {
        int i;
        if (array == null) {
            return -1;
        }
        for (i = 0; i < array.length; ++i) {
            if (array[i] != item) continue;
            return i;
        }
        for (i = 0; i < array.length; ++i) {
            Object unwrapped;
            if (array[i] == null) continue;
            if (array[i].equals(item)) {
                return i;
            }
            if (!(array[i] instanceof Unwrappable) || !((Unwrappable)array[i]).isWrapper() || (unwrapped = ((Unwrappable)array[i]).unwrap()) != item && !unwrapped.equals(item)) continue;
            return i;
        }
        if (item instanceof Unwrappable && ((Unwrappable)item).isWrapper()) {
            return ObjectUtils.indexOf(array, ((Unwrappable)item).unwrap());
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T item) {
        return ObjectUtils.indexOf(array, item) >= 0;
    }

    private static final class NoValue {
        private NoValue() {
        }

        public String toString() {
            return "[NO-VALUE]";
        }
    }
}

