/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.components;

import com.opensymphony.xwork2.util.ValueStack;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.struts2.action.ActionErrorProvider;
import org.apache.empire.struts2.action.ErrorInfo;
import org.apache.empire.struts2.html.HtmlTagDictionary;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.components.ControlComponent;
import org.apache.empire.struts2.jsp.controls.InputControl;

public class InputControlComponent
extends ControlComponent
implements InputControl.ControlInfo {
    private int hSize;
    private int vSize;
    private boolean readOnly;
    private String labelClass;
    private String labelStyle;
    private RenderType renderType = RenderType.ALL;
    private DisabledMode disabledMode = DisabledMode.DEFAULT;

    public InputControlComponent(InputControl control, ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        super(control, stack, req, res);
    }

    @Override
    protected void render(HtmlWriter writer, String body, InputControl control) {
        HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
        if (this.renderType == RenderType.HIDDEN) {
            this.renderHiddenValue(writer);
        } else if (this.renderType == RenderType.LABEL) {
            HtmlWriter.HtmlTag label = writer.startTag("label");
            label.addAttribute("class", StringUtils.coalesce((String)this.labelClass, (String)this.cssClass));
            label.addAttribute("style", StringUtils.coalesce((String)this.labelStyle, (String)this.cssStyle));
            if (control.useLabelId()) {
                label.addAttribute("for", this.getId());
            }
            label.beginBody(this.label);
            label.endTag();
        } else if (this.renderType == RenderType.CONTROL) {
            if (this.renderControlAsData(dic)) {
                control.renderText(writer, this);
            } else {
                control.renderInput(writer, this);
            }
            if (this.renderHidden()) {
                this.renderHiddenValue(writer);
            }
        } else {
            boolean renderWrapper = this.renderType == RenderType.ALL;
            HtmlWriter.HtmlTag wrapper = writer.startTag(renderWrapper ? dic.InputWrapperTag() : null);
            wrapper.addAttribute("class", dic.InputWrapperClass());
            wrapper.beginBody(true);
            if (this.renderType != RenderType.INPUTCONTROL) {
                HtmlWriter.HtmlTag wrapLabel = writer.startTag(dic.InputLabelTag());
                wrapLabel.addAttribute("class", dic.InputLabelClass());
                wrapLabel.beginBody();
                HtmlWriter.HtmlTag label = writer.startTag("label");
                if (control.useLabelId()) {
                    label.addAttribute("for", this.getId());
                }
                label.addAttribute("class", this.labelClass);
                label.addAttribute("style", this.labelStyle);
                label.beginBody(this.label);
                label.endTag(":");
                if ("true".equals(this.required) && !this.readOnly) {
                    HtmlWriter.HtmlTag required = writer.startTag(dic.InputRequiredTag());
                    required.addAttribute("class", dic.InputRequiredClass());
                    required.beginBody("*");
                    required.endTag();
                }
                wrapLabel.endTag(this.renderType != RenderType.INPUTLABEL);
            }
            if (this.renderType != RenderType.INPUTLABEL) {
                HtmlWriter.HtmlTag wrapCtrl = writer.startTag(dic.InputControlTag());
                if (this.renderControlAsData(dic)) {
                    wrapCtrl.addAttribute("class", dic.InputReadOnlyClass());
                    wrapCtrl.beginBody();
                    this.readOnly = true;
                    control.renderText(writer, this);
                } else {
                    String wrapClass = this.getDisabled() ? dic.InputReadOnlyClass() : dic.InputControlClass();
                    wrapCtrl.addAttribute("class", wrapClass);
                    wrapCtrl.beginBody();
                    control.renderInput(writer, this);
                }
                if (this.renderHidden()) {
                    this.renderHiddenValue(writer);
                }
                wrapCtrl.endTag(renderWrapper);
            }
            String wrapperBody = wrapper.isValid() ? dic.InputWrapperBody() : null;
            wrapper.endTag(wrapperBody);
        }
    }

    private boolean renderHidden() {
        if (!this.readOnly) {
            return false;
        }
        return this.disabledMode == DisabledMode.CONTROLHIDDEN || this.disabledMode == DisabledMode.TEXTHIDDEN;
    }

    private boolean renderControlAsData(HtmlTagDictionary dic) {
        if (!this.readOnly) {
            return false;
        }
        if (this.disabledMode == DisabledMode.DEFAULT) {
            return dic.InputReadOnlyAsData();
        }
        return this.disabledMode == DisabledMode.TEXT || this.disabledMode == DisabledMode.TEXTHIDDEN;
    }

    private void renderHiddenValue(HtmlWriter writer) {
        String value;
        HtmlWriter.HtmlTag input = writer.startTag("input");
        input.addAttribute("type", "hidden");
        input.addAttribute("name", this.getName() + "!");
        if (this.recordValue instanceof Date) {
            String format = this.column != null && this.column.getDataType() == DataType.DATE ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss.S";
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            value = sdf.format(this.recordValue);
        } else {
            value = StringUtils.valueOf((Object)this.recordValue);
        }
        if (value.length() > 0) {
            input.addAttribute("value", value);
        } else {
            writer.print("value=\"\"");
        }
        input.endTag();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setRenderType(String type) {
        this.renderType = type == null ? RenderType.ALL : (type.equalsIgnoreCase("label") ? RenderType.LABEL : (type.equalsIgnoreCase("control") ? RenderType.CONTROL : (type.equalsIgnoreCase("inputlabel") ? RenderType.INPUTLABEL : (type.equalsIgnoreCase("inputcontrol") ? RenderType.INPUTCONTROL : (type.equalsIgnoreCase("hidden") ? RenderType.HIDDEN : RenderType.ALL)))));
    }

    public void setDisabledMode(String type) {
        this.disabledMode = type == null ? DisabledMode.DEFAULT : (type.equalsIgnoreCase("text") ? DisabledMode.TEXT : (type.equalsIgnoreCase("textHidden") ? DisabledMode.TEXTHIDDEN : (type.equalsIgnoreCase("control") ? DisabledMode.CONTROL : (type.equalsIgnoreCase("controlHidden") ? DisabledMode.CONTROLHIDDEN : DisabledMode.DEFAULT))));
    }

    public void setHSize(String size) {
        this.hSize = ObjectUtils.getInteger((Object)size, (int)0);
    }

    public void setVSize(String size) {
        this.vSize = ObjectUtils.getInteger((Object)size, (int)0);
    }

    @Override
    public String getId() {
        return this.id == null ? this.name : this.id;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean getDisabled() {
        return this.readOnly;
    }

    @Override
    public final String getTabindex() {
        return this.tabindex;
    }

    public final String getAccesskey() {
        return this.accesskey;
    }

    @Override
    public final String getOnchange() {
        return this.onchange;
    }

    @Override
    public final String getOnfocus() {
        return this.onfocus;
    }

    @Override
    public final String getOnblur() {
        return this.onblur;
    }

    @Override
    public final boolean hasError() {
        Object action = this.getAction();
        if (action instanceof ActionErrorProvider) {
            Map<String, ErrorInfo> map = ((ActionErrorProvider)action).getItemErrors();
            return map != null && map.containsKey(this.getName());
        }
        return false;
    }

    @Override
    public int getHSize() {
        if (this.hSize == 0) {
            this.hSize = HtmlTagDictionary.getInstance().InputMaxCharSize();
        }
        return this.hSize;
    }

    @Override
    public int getVSize() {
        return this.vSize;
    }

    public void setLabelClass(String labelClass) {
        this.labelClass = labelClass;
    }

    public void setLabelStyle(String labelStyle) {
        this.labelStyle = labelStyle;
    }

    public static enum DisabledMode {
        DEFAULT,
        TEXT,
        TEXTHIDDEN,
        CONTROL,
        CONTROLHIDDEN;

    }

    public static enum RenderType {
        ALL,
        LABEL,
        CONTROL,
        INPUTLABEL,
        INPUTCONTROL,
        HIDDEN;

    }
}

