/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.utils;

import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueExpressionUnwrapper {
    private static final Logger log = LoggerFactory.getLogger(ValueExpressionUnwrapper.class);
    private static ValueExpressionUnwrapper instance = null;

    public static synchronized ValueExpressionUnwrapper getInstance() {
        if (instance == null) {
            instance = new ValueExpressionUnwrapper();
        }
        return instance;
    }

    public static synchronized void setInstance(ValueExpressionUnwrapper instance) {
        ValueExpressionUnwrapper.instance = instance;
    }

    protected ValueExpressionUnwrapper() {
        log.debug("Instance of {} created", (Object)this.getClass().getName());
    }

    public ValueExpression unwrap(ValueExpression ve) {
        String expression;
        if (ve != null && !ve.isLiteralText() && (expression = ve.getExpressionString()).startsWith("${")) {
            if (ve.getClass().getName().equals("org.apache.el.ValueExpressionImpl")) {
                Object node = ObjectUtils.invokeSimplePrivateMethod((Object)ve, (String)"getNode");
                if (node != null) {
                    String image = StringUtils.toString((Object)ObjectUtils.invokeSimpleMethod((Object)node, (String)"getImage"));
                    if (StringUtils.isNotEmpty((String)image)) {
                        VariableMapper varMapper = (VariableMapper)ObjectUtils.getPrivateFieldValue((Object)ve, (String)"varMapper");
                        if (varMapper != null) {
                            ve = varMapper.resolveVariable(image);
                            log.debug("EL-Expression \"{}\" has been resolved to variable \"{}\"", (Object)expression, (Object)(ve != null ? ve.getExpressionString() : null));
                        } else {
                            log.debug("EL-Expression \"{}\" has been resolved to NULL.", (Object)expression);
                            ve = null;
                        }
                    } else {
                        log.info("EL-Expression \"{}\" has unsupported Node type {}", (Object)expression, (Object)node.getClass().getName());
                    }
                } else {
                    log.warn("Unexpected: ValueExpressionImpl has no Node. Expression \"{}\" remains unchanged.");
                }
            } else {
                log.warn("Unexpected ValueExpression-Implementation: {}", (Object)ve.getClass().getName());
                log.warn("ValueExpression unwrapping does not work!");
            }
        }
        return ve;
    }
}

