/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.servlet.ServletContext;
import org.apache.empire.jsf2.app.WebApplication;
import org.apache.empire.jsf2.impl.FacesImplementation;
import org.apache.empire.jsf2.impl.MojarraImplementation;
import org.apache.empire.jsf2.impl.MyFacesImplementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppStartupListener
implements SystemEventListener {
    private static final Logger log = LoggerFactory.getLogger(WebAppStartupListener.class);

    public boolean isListenerForSource(Object source) {
        return source instanceof Application;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        log.info("ApplicationStartupListener:processEvent");
        if (event instanceof PostConstructApplicationEvent) {
            FacesContext startupContext = FacesContext.getCurrentInstance();
            FacesImplementation facesImplementation = this.detectFacesImplementation();
            Object app = facesImplementation.getManagedBean(WebApplication.APPLICATION_BEAN_NAME, startupContext);
            if (!(app instanceof WebApplication)) {
                throw new AbortProcessingException("Error: Application is not a " + WebApplication.class.getName() + " instance. Please create a ApplicationFactory!");
            }
            WebApplication facesApp = (WebApplication)app;
            facesApp.init(facesImplementation, startupContext);
            ServletContext servletContext = (ServletContext)startupContext.getExternalContext().getContext();
            if (servletContext.getAttribute(WebApplication.APPLICATION_BEAN_NAME) != facesApp) {
                log.warn("WARNING: Ambiguous application definition. An object of name '{}' already exists on application scope!", (Object)WebApplication.APPLICATION_BEAN_NAME);
            }
        } else if (event instanceof PreDestroyApplicationEvent) {
            log.info("Processing PreDestroyApplicationEvent");
        }
    }

    protected FacesImplementation detectFacesImplementation() {
        log.debug("Detecting JSF-Implementation...");
        try {
            Class.forName("org.apache.myfaces.application.ApplicationFactoryImpl");
            return new MyFacesImplementation();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("com.sun.faces.application.ApplicationFactoryImpl");
                return new MojarraImplementation();
            }
            catch (ClassNotFoundException classNotFoundException2) {
                log.error("JSF-Implementation missing or unknown. Please make sure either Apache MyFaces or Sun Mojarra implementation is provided");
                throw new UnsupportedOperationException();
            }
        }
    }
}

