/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.exceptions;

import org.apache.empire.commons.ErrorType;
import org.apache.empire.exceptions.EmpireException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalException
extends EmpireException {
    private static final Logger log = LoggerFactory.getLogger(InternalException.class);
    private static final long serialVersionUID = 1L;
    public static final ErrorType errorType = new ErrorType("error.exception", "An Exception of type {0} occurred.\n-->Message is: {1}\n-->at Position: {2}");

    private static String[] paramsFromThrowable(Throwable exptn) {
        String type = exptn.getClass().getName();
        if (type.startsWith("java.lang.")) {
            type = type.substring("java.lang.".length());
        }
        String msg = exptn.getMessage();
        StackTraceElement[] stack = exptn.getStackTrace();
        String pos = stack != null && stack.length > 0 ? stack[0].toString() : "{unknown}";
        return new String[]{type, msg, pos};
    }

    public InternalException(Throwable cause) {
        super(errorType, InternalException.paramsFromThrowable(cause));
    }

    public InternalException(EmpireException other) {
        super(other.getErrorType(), other.getErrorParams());
        log.warn("InternalException used to wrap an EmpireException! Type and params will be copied.");
    }
}

