/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.postgresql;

import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.postgresql.DBDatabaseDriverPostgreSQL;

public class PostgreDDLGenerator
extends DBDDLGenerator<DBDatabaseDriverPostgreSQL> {
    public PostgreDDLGenerator(DBDatabaseDriverPostgreSQL driver) {
        super(driver);
        this.initDataTypes();
    }

    private void initDataTypes() {
        this.DATATYPE_BOOLEAN = "BOOLEAN";
        this.DATATYPE_CLOB = "TEXT";
        this.DATATYPE_BLOB = "BYTEA";
    }

    @Override
    protected boolean appendColumnDataType(DataType type, double size, DBTableColumn c, StringBuilder sql) {
        switch (type) {
            case AUTOINC: {
                int bytes = Math.abs((int)size);
                if (bytes >= 8) {
                    sql.append("BIGSERIAL");
                    break;
                }
                sql.append("SERIAL");
                break;
            }
            case FLOAT: {
                sql.append("DOUBLE PRECISION");
                break;
            }
            case BLOB: {
                sql.append(this.DATATYPE_BLOB);
                break;
            }
            default: {
                return super.appendColumnDataType(type, size, c, sql);
            }
        }
        return true;
    }

    @Override
    protected void createDatabase(DBDatabase db, DBSQLScript script) {
        for (DBTable table : db.getTables()) {
            for (DBColumn dbColumn : table.getColumns()) {
                DBTableColumn c = (DBTableColumn)dbColumn;
                if (c.getDataType() != DataType.AUTOINC) continue;
                this.createSequence(db, c, script);
            }
        }
        super.createDatabase(db, script);
    }

    protected void createSequence(DBDatabase db, DBTableColumn c, DBSQLScript script) {
        String seqName = c.getSequenceName();
        StringBuilder sql = new StringBuilder();
        sql.append("-- creating sequence for column ");
        sql.append(c.getFullName());
        sql.append(" --\r\n");
        sql.append("CREATE SEQUENCE ");
        db.appendQualifiedName(sql, seqName, this.detectQuoteName(seqName));
        sql.append(" INCREMENT BY 1 START WITH 1 MINVALUE 0");
        script.addStmt(sql);
    }

    @Override
    protected void appendColumnDesc(DBTableColumn c, boolean alter, StringBuilder sql) {
        c.addSQL(sql, 1L);
        if (alter) {
            sql.append(" TYPE ");
        } else {
            sql.append(" ");
        }
        if (!this.appendColumnDataType(c.getDataType(), c.getSize(), c, sql)) {
            return;
        }
        if (((DBDatabaseDriverPostgreSQL)this.driver).isDDLColumnDefaults() && !c.isAutoGenerated() && c.getDefaultValue() != null) {
            sql.append(" DEFAULT ");
            sql.append(((DBDatabaseDriverPostgreSQL)this.driver).getValueString(c.getDefaultValue(), c.getDataType()));
        }
        if (c.isRequired() || c.isAutoGenerated()) {
            sql.append(" NOT NULL");
        }
    }
}

