/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.oracle;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.expr.column.DBAliasExpr;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.db.expr.compare.DBCompareColExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.join.DBColumnJoinExpr;
import org.apache.empire.db.expr.join.DBJoinExpr;
import org.apache.empire.db.expr.set.DBSetExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ObjectNotValidException;

public class DBCommandOracle
extends DBCommand {
    private static final long serialVersionUID = 1L;
    protected DBCompareExpr connectBy = null;
    protected DBCompareExpr startWith = null;
    protected String optimizerHint = null;
    protected int limitRows = -1;
    protected int skipRows = 0;

    public DBCommandOracle(DBDatabase db) {
        super(db);
    }

    public String getOptimizerHint() {
        return this.optimizerHint;
    }

    public void setOptimizerHint(String optimizerHint) {
        this.optimizerHint = optimizerHint;
    }

    public void setOptimizerIndexHint(DBIndex index) {
        if (index == null || index.getTable() == null) {
            throw new InvalidArgumentException("index", index);
        }
        String tableAlias = index.getTable().getAlias();
        String indexName = index.getName();
        String indexHint = "INDEX (" + tableAlias + " " + indexName + ")";
        this.optimizerHint = StringUtils.isNotEmpty(this.optimizerHint) && this.optimizerHint.indexOf(indexHint) < 0 ? this.optimizerHint + " " + indexHint : indexHint;
    }

    @Override
    public void clear() {
        super.clear();
        this.clearConnectBy();
        this.optimizerHint = null;
    }

    public void clearConnectBy() {
        this.startWith = null;
        this.connectBy = null;
    }

    public void connectByPrior(DBCompareExpr expr) {
        this.connectBy = expr;
    }

    public void startWith(DBCompareExpr expr) {
        this.startWith = expr;
    }

    @Override
    public void limitRows(int limitRows) {
        this.limitRows = limitRows;
    }

    @Override
    public void skipRows(int skipRows) {
        if (skipRows < 0) {
            throw new InvalidArgumentException("skipRows", skipRows);
        }
        this.skipRows = skipRows;
    }

    @Override
    public void clearLimit() {
        this.limitRows = -1;
        this.skipRows = 0;
    }

    @Override
    public synchronized void getSelect(StringBuilder buf) {
        this.resetParamUsage();
        if (this.select == null) {
            throw new ObjectNotValidException(this);
        }
        boolean usePreparedStatements = this.isPreparedStatementsEnabled();
        if (this.limitRows >= 0) {
            buf.append("SELECT * FROM (");
            if (this.skipRows > 0) {
                buf.append("SELECT row_.*, rownum rownum_ FROM (");
            }
        }
        buf.append("SELECT ");
        if (StringUtils.isNotEmpty(this.optimizerHint)) {
            buf.append("/*+ ").append(this.optimizerHint).append(" */ ");
        }
        if (this.selectDistinct) {
            buf.append("DISTINCT ");
        }
        this.addListExpr(buf, this.select, 15L, ", ");
        this.addFrom(buf);
        this.addWhere(buf);
        if (this.connectBy != null) {
            buf.append("\r\nCONNECT BY PRIOR ");
            this.connectBy.addSQL(buf, 23L);
            if (this.startWith != null) {
                buf.append("\r\nSTART WITH ");
                this.startWith.addSQL(buf, 7L);
            }
        }
        this.addGrouping(buf);
        if (this.orderBy != null) {
            if (this.connectBy != null) {
                buf.append("\r\nORDER SIBLINGS BY ");
            } else {
                buf.append("\r\nORDER BY ");
            }
            this.addListExpr(buf, this.orderBy, 7L, ", ");
        }
        if (this.limitRows >= 0) {
            buf.append(") row_ WHERE rownum<=");
            buf.append(usePreparedStatements ? "?" : String.valueOf(this.skipRows + this.limitRows));
            if (this.skipRows > 0) {
                buf.append(") WHERE rownum_>");
                buf.append(usePreparedStatements ? "?" : String.valueOf(this.skipRows));
            }
        }
    }

    @Override
    public Object[] getParamValues() {
        Object[] params = super.getParamValues();
        if (this.limitRows < 0 || !this.getDatabase().isPreparedStatementsEnabled()) {
            return params;
        }
        int newSize = (params != null ? params.length : 0) + (this.skipRows > 0 ? 2 : 1);
        Object[] newParams = new Object[newSize];
        for (int i = 0; params != null && i < params.length; ++i) {
            newParams[i] = params[i];
        }
        if (this.skipRows > 0) {
            newParams[--newSize] = this.skipRows;
        }
        newParams[--newSize] = this.skipRows + this.limitRows;
        return newParams;
    }

    @Override
    public synchronized String getUpdate() {
        if (this.joins == null || this.set == null) {
            return this.getSimpleUpdate();
        }
        return this.getUpdateWithJoins();
    }

    protected String getSimpleUpdate() {
        this.resetParamUsage();
        if (this.set == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder("UPDATE ");
        DBRowSet table = ((DBSetExpr)this.set.get(0)).getTable();
        long context = 2L;
        if (StringUtils.isNotEmpty(this.optimizerHint)) {
            buf.append("/*+ ").append(this.optimizerHint).append(" */ ");
            if (this.optimizerHint.contains(table.getAlias())) {
                context |= 8L;
            }
        }
        table.addSQL(buf, context);
        context = 5L;
        buf.append("\r\nSET ");
        this.addListExpr(buf, this.set, context, ", ");
        this.addWhere(buf, context);
        return buf.toString();
    }

    protected String getUpdateWithJoins() {
        this.resetParamUsage();
        StringBuilder buf = new StringBuilder("MERGE INTO ");
        DBRowSet table = ((DBSetExpr)this.set.get(0)).getTable();
        table.addSQL(buf, 10L);
        DBColumnJoinExpr updateJoin = null;
        for (DBJoinExpr jex : this.joins) {
            if (!(jex instanceof DBColumnJoinExpr) || !jex.isJoinOn(table)) continue;
            updateJoin = (DBColumnJoinExpr)jex;
            break;
        }
        if (updateJoin == null) {
            throw new ObjectNotValidException(this);
        }
        HashSet<DBColumn> joinColumns = new HashSet<DBColumn>();
        updateJoin.addReferencedColumns(joinColumns);
        buf.append("\r\nUSING ");
        DBCommand inner = this.clone();
        inner.clearSelect();
        inner.clearOrderBy();
        DBRowSet outerTable = updateJoin.getOuterTable();
        if (outerTable == null) {
            outerTable = table;
        }
        for (DBColumn jcol : joinColumns) {
            if (jcol.getRowSet().equals(outerTable)) continue;
            inner.select((DBColumnExpr)jcol);
        }
        DBColumnExpr left = updateJoin.getLeft();
        DBColumnExpr right = updateJoin.getRight();
        DBRowSet source = right.getUpdateColumn().getRowSet();
        if (source == table) {
            source = left.getUpdateColumn().getRowSet();
        }
        String sourceAliasPrefix = source.getAlias() + ".";
        ArrayList<DBSetExpr> mergeSet = new ArrayList<DBSetExpr>(this.set.size());
        for (DBSetExpr sex : this.set) {
            Object val = sex.getValue();
            if (val instanceof DBColumnExpr) {
                DBColumnExpr expr = (DBColumnExpr)val;
                if (!(expr instanceof DBColumn) && !(expr instanceof DBAliasExpr)) {
                    String name = "COL_" + String.valueOf(mergeSet.size());
                    expr = expr.as(name);
                }
                inner.select(expr);
                DBValueExpr NAME_EXPR = this.getDatabase().getValueExpr(sourceAliasPrefix + expr.getName(), DataType.UNKNOWN);
                mergeSet.add(sex.getColumn().to(NAME_EXPR));
                continue;
            }
            mergeSet.add(sex);
        }
        if (!inner.hasConstraintOn(table)) {
            inner.removeJoinsOn(table);
        }
        inner.addSQL(buf, 7L);
        buf.append(" ");
        buf.append(source.getAlias());
        buf.append("\r\nON (");
        left.addSQL(buf, 7L);
        buf.append(" = ");
        right.addSQL(buf, 7L);
        if (updateJoin.getWhere() != null) {
            buf.append(" AND ");
            updateJoin.getWhere().addSQL(buf, 7L);
        }
        for (DBCompareExpr we : this.where) {
            DBCompareColExpr cce = (DBCompareColExpr)we;
            DBColumn ccecol = cce.getColumnExpr().getUpdateColumn();
            if (!table.isKeyColumn(ccecol) || this.isSetColumn(ccecol)) continue;
            buf.append(" AND ");
            cce.addSQL(buf, 7L);
        }
        buf.append(")\r\nWHEN MATCHED THEN UPDATE ");
        buf.append("\r\nSET ");
        this.addListExpr(buf, mergeSet, 7L, ", ");
        return buf.toString();
    }

    protected boolean isSetColumn(DBColumn col) {
        for (DBSetExpr se : this.set) {
            if (!se.getColumn().equals(col)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized String getDelete(DBTable table) {
        this.resetParamUsage();
        StringBuilder buf = new StringBuilder("DELETE ");
        if (this.optimizerHint != null) {
            buf.append("/*+ ").append(this.optimizerHint).append(" */ ");
        }
        buf.append("FROM ");
        table.addSQL(buf, 2L);
        if (this.where != null || this.having != null) {
            buf.append("\r\nWHERE ");
            if (this.where != null) {
                this.addListExpr(buf, this.where, 5L, " AND ");
            }
        }
        return buf.toString();
    }
}

