/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.expr.column.DBAbstractFuncExpr;

public class DBFuncExpr
extends DBAbstractFuncExpr {
    private static final long serialVersionUID = 1L;
    protected final int phrase;
    protected final Object[] params;
    protected String template;

    public DBFuncExpr(DBColumnExpr expr, int phrase, Object[] params, DBColumn updateColumn, boolean isAggregate, DataType dataType) {
        super(expr, updateColumn, isAggregate, dataType);
        this.phrase = phrase;
        this.params = params;
        this.template = null;
    }

    public DBFuncExpr(DBColumnExpr expr, String template, Object[] params, DBColumn updateColumn, boolean isAggregate, DataType dataType) {
        super(expr, updateColumn, isAggregate, dataType);
        this.phrase = 0;
        this.params = params;
        this.template = template;
    }

    @Override
    protected String getFunctionName() {
        if (this.template == null && this.getDatabaseDriver() != null) {
            this.template = this.getDatabaseDriver().getSQLPhrase(this.phrase);
        }
        if (this.template != null) {
            int i;
            String s = this.template.trim();
            for (i = 0; i < s.length() && s.charAt(i) >= 'A'; ++i) {
            }
            if (i > 0) {
                return s.substring(0, i);
            }
        }
        return "func_" + String.valueOf(this.phrase);
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        super.addReferencedColumns(list);
        if (this.params == null) {
            return;
        }
        for (int i = 0; i < this.params.length; ++i) {
            if (!(this.params[i] instanceof DBExpr)) continue;
            ((DBExpr)this.params[i]).addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(StringBuilder sql, long context) {
        if (this.template == null) {
            this.template = this.getDatabaseDriver().getSQLPhrase(this.phrase);
        }
        super.addSQL(sql, this.template, this.params, context);
    }
}

