/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.exceptions;

import java.sql.SQLException;
import org.apache.empire.commons.ErrorType;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.exceptions.EmpireSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintViolationException
extends EmpireSQLException {
    private static final Logger log = LoggerFactory.getLogger(ConstraintViolationException.class);
    private static final long serialVersionUID = 1L;
    public static final ErrorType errorType = new ErrorType("error.db.statementFailed", "Error executing statement {0}.\r\nNative error is: {1}");

    public ConstraintViolationException(DBObject obj, String sqlCmd, SQLException cause) {
        super(errorType, new String[]{sqlCmd, ConstraintViolationException.messageFromSQLException(ConstraintViolationException.driverFromObject(obj), cause)}, 1, cause);
    }

    @Override
    protected void log() {
        if (log.isErrorEnabled()) {
            log.error(this.getMessage());
        } else {
            super.log();
        }
    }
}

