/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.RecordData;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.exceptions.FieldIllegalValueException;
import org.apache.empire.exceptions.BeanPropertySetException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class DBRecordData
extends DBObject
implements RecordData {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBRecordData.class);

    @Override
    public abstract int getFieldCount();

    @Override
    public abstract int getFieldIndex(ColumnExpr var1);

    @Override
    public abstract int getFieldIndex(String var1);

    @Override
    public abstract ColumnExpr getColumnExpr(int var1);

    public abstract int addColumnDesc(Element var1);

    public abstract int addRowValues(Element var1);

    public abstract Document getXmlDocument();

    public abstract void close();

    @Override
    public abstract Object getValue(int var1);

    @Override
    public final Object getValue(ColumnExpr column) {
        int index = this.getFieldIndex(column);
        if (index < 0) {
            throw new ItemNotFoundException((Object)column.getName());
        }
        return this.getValue(index);
    }

    public final Object[] getValues(ColumnExpr[] columns) {
        Object[] values = new Object[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int index = this.getFieldIndex(columns[i]);
            if (index < 0) {
                throw new ItemNotFoundException((Object)columns[i].getName());
            }
            values[i] = this.getValue(index);
        }
        return values;
    }

    public int getInt(int index) {
        Object value = this.getValue(index);
        return ObjectUtils.getInteger(value);
    }

    public final int getInt(ColumnExpr column) {
        return this.getInt(this.getFieldIndex(column));
    }

    public long getLong(int index) {
        Object value = this.getValue(index);
        return ObjectUtils.getLong(value);
    }

    public final long getLong(ColumnExpr column) {
        return this.getLong(this.getFieldIndex(column));
    }

    public double getDouble(int index) {
        Object value = this.getValue(index);
        return ObjectUtils.getDouble(value);
    }

    public final double getDouble(ColumnExpr column) {
        return this.getDouble(this.getFieldIndex(column));
    }

    public BigDecimal getDecimal(int index) {
        Object value = this.getValue(index);
        return ObjectUtils.getDecimal(value);
    }

    public final BigDecimal getDecimal(ColumnExpr column) {
        return this.getDecimal(this.getFieldIndex(column));
    }

    public boolean getBoolean(int index) {
        Object value = this.getValue(index);
        return ObjectUtils.getBoolean(value);
    }

    public final boolean getBoolean(ColumnExpr column) {
        return this.getBoolean(this.getFieldIndex(column));
    }

    public String getString(int index) {
        Object value = this.getValue(index);
        return StringUtils.toString(value);
    }

    public final String getString(ColumnExpr column) {
        return this.getString(this.getFieldIndex(column));
    }

    public Date getDateTime(int index) {
        Object value = this.getValue(index);
        return ObjectUtils.getDate(value);
    }

    public final Date getDateTime(ColumnExpr column) {
        return this.getDateTime(this.getFieldIndex(column));
    }

    public <T extends Enum<?>> T getEnum(int index, Class<T> enumType) {
        if (this.isNull(index)) {
            return null;
        }
        ColumnExpr col = this.getColumnExpr(index);
        try {
            boolean numeric = col.getDataType().isNumeric();
            return ObjectUtils.getEnum(enumType, numeric ? Integer.valueOf(this.getInt(index)) : this.getValue(index));
        }
        catch (Exception e) {
            String value = StringUtils.valueOf(this.getValue(index));
            log.error("Unable to resolve enum value of '{}' for type {}", (Object)value, (Object)enumType.getName());
            throw new FieldIllegalValueException(col.getSourceColumn(), value, (Throwable)e);
        }
    }

    public final <T extends Enum<?>> T getEnum(ColumnExpr column, Class<T> enumType) {
        return this.getEnum(this.getFieldIndex(column), enumType);
    }

    public final <T extends Enum<?>> T getEnum(Column column) {
        Class<Enum<?>> enumType = column.getEnumType();
        if (enumType == null) {
            throw new InvalidArgumentException("column", column);
        }
        return (T)this.getEnum(this.getFieldIndex(column), enumType);
    }

    public final <T> T getAs(int index, Class<T> wrapperType) {
        return ObjectUtils.convert(wrapperType, this.getValue(index));
    }

    public final <T> T getAs(Column column, Class<T> wrapperType) {
        return ObjectUtils.convert(wrapperType, this.getValue(column));
    }

    @Override
    public boolean isNull(int index) {
        return this.getValue(index) == null;
    }

    @Override
    public final boolean isNull(ColumnExpr column) {
        return this.isNull(this.getFieldIndex(column));
    }

    protected void setBeanProperty(ColumnExpr column, Object bean, String property, Object value) {
        if (StringUtils.isEmpty(property)) {
            property = column.getBeanPropertyName();
        }
        try {
            if (bean == null) {
                throw new InvalidArgumentException("bean", bean);
            }
            if (StringUtils.isEmpty(property)) {
                throw new InvalidArgumentException("property", property);
            }
            Class enumType = (Class)column.getAttribute("enumType");
            if (enumType != null && value != null) {
                value = ObjectUtils.getEnum(enumType, value);
            }
            if (value != null) {
                BeanUtils.setProperty((Object)bean, (String)property, (Object)value);
            } else {
                PropertyUtils.setProperty((Object)bean, (String)property, null);
            }
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (NullPointerException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
    }

    @Override
    public int setBeanProperties(Object bean, Collection<? extends ColumnExpr> ignoreList) {
        int count = 0;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            ColumnExpr column = this.getColumnExpr(i);
            if (ignoreList != null && ignoreList.contains(column)) continue;
            String property = column.getBeanPropertyName();
            if (property != null) {
                this.setBeanProperty(column, bean, property, this.getValue(i));
            }
            ++count;
        }
        return count;
    }

    @Override
    public final int setBeanProperties(Object bean) {
        return this.setBeanProperties(bean, null);
    }
}

