/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.empire.commons.DateUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBBlobData;
import org.apache.empire.db.DBClobData;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBCmdType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCombinedCmd;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDriverFeature;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.exceptions.EmpireSQLException;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotImplementedException;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBDatabaseDriver
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBDatabaseDriver.class);
    public static final int SQL_NULL_VALUE = 1;
    public static final int SQL_PARAMETER = 2;
    public static final int SQL_RENAME_TABLE = 3;
    public static final int SQL_RENAME_COLUMN = 4;
    public static final int SQL_DATABASE_LINK = 5;
    public static final int SQL_QUOTES_OPEN = 6;
    public static final int SQL_QUOTES_CLOSE = 7;
    public static final int SQL_CONCAT_EXPR = 8;
    public static final int SQL_PSEUDO_TABLE = 9;
    public static final int SQL_BOOLEAN_TRUE = 10;
    public static final int SQL_BOOLEAN_FALSE = 11;
    public static final int SQL_CURRENT_DATE = 20;
    public static final int SQL_DATE_PATTERN = 21;
    public static final int SQL_DATE_TEMPLATE = 22;
    public static final int SQL_DATETIME_PATTERN = 23;
    public static final int SQL_DATETIME_TEMPLATE = 24;
    public static final int SQL_CURRENT_TIMESTAMP = 25;
    public static final int SQL_TIMESTAMP_PATTERN = 26;
    public static final int SQL_TIMESTAMP_TEMPLATE = 27;
    public static final int SQL_FUNC_COALESCE = 100;
    public static final int SQL_FUNC_SUBSTRING = 101;
    public static final int SQL_FUNC_SUBSTRINGEX = 102;
    public static final int SQL_FUNC_REPLACE = 103;
    public static final int SQL_FUNC_REVERSE = 104;
    public static final int SQL_FUNC_STRINDEX = 105;
    public static final int SQL_FUNC_STRINDEXFROM = 106;
    public static final int SQL_FUNC_LENGTH = 107;
    public static final int SQL_FUNC_UPPER = 110;
    public static final int SQL_FUNC_LOWER = 111;
    public static final int SQL_FUNC_TRIM = 112;
    public static final int SQL_FUNC_LTRIM = 113;
    public static final int SQL_FUNC_RTRIM = 114;
    public static final int SQL_FUNC_ESCAPE = 119;
    public static final int SQL_FUNC_ABS = 120;
    public static final int SQL_FUNC_ROUND = 121;
    public static final int SQL_FUNC_TRUNC = 122;
    public static final int SQL_FUNC_FLOOR = 123;
    public static final int SQL_FUNC_CEILING = 124;
    public static final int SQL_FUNC_MODULO = 125;
    public static final int SQL_FUNC_FORMAT = 126;
    public static final int SQL_FUNC_DAY = 132;
    public static final int SQL_FUNC_MONTH = 133;
    public static final int SQL_FUNC_YEAR = 134;
    public static final int SQL_FUNC_SUM = 140;
    public static final int SQL_FUNC_MAX = 142;
    public static final int SQL_FUNC_MIN = 143;
    public static final int SQL_FUNC_AVG = 144;
    public static final int SQL_FUNC_DECODE = 150;
    public static final int SQL_FUNC_DECODE_SEP = 151;
    public static final int SQL_FUNC_DECODE_PART = 152;
    public static final int SQL_FUNC_DECODE_ELSE = 153;
    protected boolean ddlColumnDefaults = false;
    protected static final char[] ILLEGAL_NAME_CHARS = new char[]{'@', '?', '>', '=', '<', ';', ':', '/', '.', '-', ',', '+', '*', ')', '(', '\'', '&', '%', '!', ' '};
    protected static final String[] GENERAL_SQL_KEYWORDS = new String[]{"user", "group", "table", "column", "view", "index", "constraint", "select", "udpate", "insert", "alter", "delete", "order"};
    protected final Set<String> reservedSQLKeywords = new HashSet<String>(GENERAL_SQL_KEYWORDS.length);

    public DBDatabaseDriver() {
        for (String keyWord : GENERAL_SQL_KEYWORDS) {
            this.reservedSQLKeywords.add(keyWord);
        }
    }

    public abstract DBCommand createCommand(DBDatabase var1);

    public DBCommandExpr createCombinedCommand(DBCommandExpr left, String keyWord, DBCommandExpr right) {
        return new DBCombinedCmd(left, keyWord, right);
    }

    public abstract boolean isSupported(DBDriverFeature var1);

    protected boolean detectQuoteName(String name) {
        if (this.reservedSQLKeywords.contains(name.toLowerCase())) {
            return true;
        }
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ic;
            char c = name.charAt(i);
            for (int j = 0; j < ILLEGAL_NAME_CHARS.length && c <= (ic = ILLEGAL_NAME_CHARS[j]); ++j) {
                if (c != ic) continue;
                return true;
            }
        }
        return false;
    }

    public void appendElementName(StringBuilder sql, String name, boolean useQuotes) {
        if (useQuotes) {
            sql.append(this.getSQLPhrase(6));
        }
        sql.append(name);
        if (useQuotes) {
            sql.append(this.getSQLPhrase(7));
        }
    }

    public final void appendElementName(StringBuilder sql, String name) {
        this.appendElementName(sql, name, this.detectQuoteName(name));
    }

    public abstract String getSQLPhrase(int var1);

    public abstract String getConvertPhrase(DataType var1, DataType var2, Object var3);

    public abstract Object getNextSequenceValue(DBDatabase var1, String var2, int var3, Connection var4);

    public abstract DBColumnExpr getNextSequenceValueExpr(DBTableColumn var1);

    public Object getColumnAutoValue(DBDatabase db, DBTableColumn column, Connection conn) {
        DataType type = column.getDataType();
        if (type == DataType.AUTOINC) {
            if (!this.isSupported(DBDriverFeature.SEQUENCES)) {
                return null;
            }
            String SeqName = column.getSequenceName();
            return db.getNextSequenceValue(SeqName, conn);
        }
        if (type == DataType.UNIQUEID) {
            return UUID.randomUUID();
        }
        if (type == DataType.DATE || type == DataType.DATETIME || type == DataType.TIMESTAMP) {
            Timestamp ts = db.getUpdateTimestamp(conn);
            return type == DataType.DATE ? DateUtils.getDateOnly(ts) : ts;
        }
        throw new NotSupportedException(this, "getColumnAutoValue() for " + (Object)((Object)type));
    }

    protected void prepareStatement(PreparedStatement pstmt, Object[] sqlParams) throws SQLException {
        for (int i = 0; i < sqlParams.length; ++i) {
            Object value = sqlParams[i];
            try {
                this.addStatementParam(pstmt, i + 1, value);
                continue;
            }
            catch (SQLException e) {
                log.error("SQLException: Unable to set prepared statement parameter {} to '{}'", (Object)(i + 1), (Object)StringUtils.toString(value));
                throw e;
            }
        }
    }

    protected void addStatementParam(PreparedStatement pstmt, int paramIndex, Object value) throws SQLException {
        if (value instanceof DBBlobData) {
            DBBlobData blobData = (DBBlobData)value;
            pstmt.setBinaryStream(paramIndex, blobData.getInputStream(), blobData.getLength());
            if (log.isDebugEnabled()) {
                log.debug("Statement param {} set to BLOB data", (Object)paramIndex);
            }
        } else if (value instanceof DBClobData) {
            DBClobData clobData = (DBClobData)value;
            pstmt.setCharacterStream(paramIndex, clobData.getReader(), clobData.getLength());
            if (log.isDebugEnabled()) {
                log.debug("Statement param {} set to CLOB data", (Object)paramIndex);
            }
        } else if (value instanceof Date && !(value instanceof Timestamp)) {
            Timestamp ts = new Timestamp(((Date)value).getTime());
            pstmt.setObject(paramIndex, ts);
            if (log.isDebugEnabled()) {
                log.debug("Statement param {} set to date '{}'", (Object)paramIndex, (Object)ts);
            }
        } else if (value instanceof Character || value instanceof Enum) {
            String strval = value.toString();
            pstmt.setObject(paramIndex, strval);
            if (log.isDebugEnabled()) {
                log.debug("Statement param {} set to '{}'", (Object)paramIndex, (Object)strval);
            }
        } else {
            pstmt.setObject(paramIndex, value);
            if (log.isDebugEnabled()) {
                log.debug("Statement param {} set to '{}'", (Object)paramIndex, value);
            }
        }
    }

    public String extractErrorMessage(SQLException e) {
        return e.getMessage();
    }

    public Object getResultValue(ResultSet rset, int columnIndex, DataType dataType) throws SQLException {
        if (dataType == DataType.DATETIME || dataType == DataType.TIMESTAMP) {
            return rset.getTimestamp(columnIndex);
        }
        if (dataType == DataType.CLOB) {
            Clob clob = rset.getClob(columnIndex);
            return clob != null ? clob.getSubString(1L, (int)clob.length()) : null;
        }
        if (dataType == DataType.BLOB) {
            Blob blob = rset.getBlob(columnIndex);
            return blob != null ? blob.getBytes(1L, (int)blob.length()) : null;
        }
        return rset.getObject(columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeSQL(String sqlCmd, Object[] sqlParams, Connection conn, DBSetGenKeys genKeys) throws SQLException {
        Statement stmt = null;
        try {
            int count = 0;
            if (sqlParams != null) {
                PreparedStatement pstmt = genKeys != null ? conn.prepareStatement(sqlCmd, 1) : conn.prepareStatement(sqlCmd);
                stmt = pstmt;
                this.prepareStatement(pstmt, sqlParams);
                count = pstmt.executeUpdate();
            } else {
                stmt = conn.createStatement();
                int n = count = genKeys != null ? stmt.executeUpdate(sqlCmd, 1) : stmt.executeUpdate(sqlCmd);
            }
            if (genKeys != null && count > 0) {
                ResultSet rs = stmt.getGeneratedKeys();
                try {
                    while (rs.next()) {
                        genKeys.set(rs.getObject(1));
                    }
                }
                finally {
                    rs.close();
                }
            }
            int n = count;
            this.close(stmt);
            return n;
        }
        catch (Throwable throwable) {
            this.close(stmt);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(String[] sqlCmd, Object[][] sqlCmdParams, Connection conn) throws SQLException {
        if (sqlCmdParams != null) {
            Statement pstmt = null;
            try {
                int pos = 0;
                String lastCmd = null;
                int[] result = new int[sqlCmd.length];
                for (int i = 0; i <= sqlCmd.length; ++i) {
                    String cmd;
                    String string = cmd = i < sqlCmd.length ? sqlCmd[i] : null;
                    if (!StringUtils.compareEqual(cmd, lastCmd, true)) {
                        if (pstmt != null) {
                            log.debug("Executing batch containing {} statements", (Object)(i - pos));
                            int[] res = pstmt.executeBatch();
                            for (int j = 0; j < res.length; ++j) {
                                result[pos + j] = res[j];
                            }
                            pos += res.length;
                            this.close(pstmt);
                            pstmt = null;
                        }
                        if (cmd == null) break;
                        log.debug("Creating prepared statement for batch: " + cmd);
                        pstmt = conn.prepareStatement(cmd);
                        lastCmd = cmd;
                    }
                    if (sqlCmdParams[i] != null) {
                        this.prepareStatement((PreparedStatement)pstmt, sqlCmdParams[i]);
                    }
                    log.debug("Adding batch with {} params.", (Object)(sqlCmdParams[i] != null ? sqlCmdParams[i].length : 0));
                    pstmt.addBatch();
                }
                int[] nArray = result;
                return nArray;
            }
            finally {
                this.close(pstmt);
            }
        }
        Statement stmt = conn.createStatement();
        try {
            int[] result;
            for (int i = 0; i < sqlCmd.length; ++i) {
                String cmd = sqlCmd[i];
                log.debug("Adding statement to batch: " + cmd);
                stmt.addBatch(cmd);
            }
            log.debug("Executing batch containing {} statements", (Object)sqlCmd.length);
            int[] nArray = result = stmt.executeBatch();
            return nArray;
        }
        finally {
            this.close(stmt);
        }
    }

    public ResultSet executeQuery(String sqlCmd, Object[] sqlParams, boolean scrollable, Connection conn) throws SQLException {
        Statement stmt = null;
        try {
            int type;
            int n = type = scrollable ? 1004 : 1003;
            if (sqlParams != null) {
                PreparedStatement pstmt = conn.prepareStatement(sqlCmd, type, 1007);
                stmt = pstmt;
                this.prepareStatement(pstmt, sqlParams);
                return pstmt.executeQuery();
            }
            stmt = conn.createStatement(type, 1007);
            return stmt.executeQuery(sqlCmd);
        }
        catch (SQLException e) {
            log.error("Error executing query '" + sqlCmd + "' --> " + e.getMessage(), (Throwable)e);
            this.close(stmt);
            throw e;
        }
    }

    protected void close(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            log.error("close statement:" + sqle.toString());
        }
    }

    public String getValueString(Object value, DataType type) {
        if (value instanceof Enum) {
            log.warn("Enum of type {} supplied for getValueString. Converting value...", (Object)value.getClass().getName());
            value = ObjectUtils.getEnumValue((Enum)value, type.isNumeric());
        }
        if (ObjectUtils.isEmpty(value)) {
            return this.getSQLPhrase(1);
        }
        switch (type) {
            case DATE: {
                return this.getSQLDateTimeString(value, 22, 21, 20);
            }
            case DATETIME: {
                if (!DBDatabase.SYSDATE.equals(value) && !(value instanceof Date) && ObjectUtils.lengthOf(value) <= 10) {
                    return this.getSQLDateTimeString(value, 22, 21, 25);
                }
                return this.getSQLDateTimeString(value, 24, 23, 25);
            }
            case TIMESTAMP: {
                return this.getSQLDateTimeString(value, 27, 26, 25);
            }
            case TEXT: 
            case VARCHAR: 
            case CHAR: 
            case CLOB: 
            case UNIQUEID: {
                return this.getSQLTextString(type, value);
            }
            case BOOL: {
                boolean boolVal = false;
                boolVal = value instanceof Boolean ? ((Boolean)value).booleanValue() : this.stringToBoolean(value.toString());
                return this.getSQLPhrase(boolVal ? 10 : 11);
            }
            case INTEGER: 
            case DECIMAL: 
            case FLOAT: {
                return this.getSQLNumberString(value, type);
            }
            case BLOB: {
                throw new NotSupportedException(this, "getValueString(?, DataType.BLOB)");
            }
            case AUTOINC: 
            case UNKNOWN: {
                return value.toString();
            }
        }
        log.warn("Unknown DataType {} for getValueString().", (Object)type);
        return value.toString();
    }

    protected String getSQLNumberString(Object value, DataType type) {
        if (value instanceof Number) {
            return value.toString();
        }
        String s = value.toString();
        boolean integerOnly = type == DataType.INTEGER;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c == '-' || c == '+') continue;
            if (c == ' ' && i > 0) {
                return s.substring(0, i);
            }
            if (!integerOnly && (c == '.' || c == ',')) continue;
            throw new NumberFormatException(s);
        }
        return s;
    }

    protected String getSQLDateTimeString(Object value, int sqlTemplate, int sqlPattern, int sqlCurrentDate) {
        Timestamp ts;
        if (DBDatabase.SYSDATE.equals(value)) {
            return this.getSQLPhrase(sqlCurrentDate);
        }
        if (value instanceof Timestamp) {
            ts = (Timestamp)value;
        } else if (value instanceof Date) {
            ts = new Timestamp(((Date)value).getTime());
        } else {
            String dtValue = value.toString().trim();
            try {
                ts = Timestamp.valueOf(dtValue);
            }
            catch (Throwable e) {
                log.error("Unable to parse date value " + dtValue, e);
                throw new InvalidArgumentException("value", value);
            }
        }
        String pattern = this.getSQLPhrase(sqlPattern);
        SimpleDateFormat sqlFormat = new SimpleDateFormat(this.getSQLPhrase(sqlPattern));
        String datetime = sqlFormat.format(ts);
        int nanos = ts.getNanos() % 1000000;
        if (pattern.endsWith(".SSS") && nanos > 0) {
            datetime = nanos % 100 > 0 ? datetime + String.format("%06d", nanos) : datetime + String.format("%04d", nanos / 100);
        }
        String template = this.getSQLPhrase(sqlTemplate);
        return StringUtils.replace(template, "{0}", datetime);
    }

    protected String getSQLTextString(DataType type, Object value) {
        StringBuilder valBuf = new StringBuilder();
        valBuf.append("'");
        if (!"\u0000".equals(value)) {
            this.appendSQLTextValue(valBuf, value.toString());
        }
        valBuf.append("'");
        return valBuf.toString();
    }

    protected void appendSQLTextValue(StringBuilder buf, String value) {
        if (value.indexOf(39) >= 0) {
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                if (value.charAt(i) == '\'') {
                    buf.append("''");
                    continue;
                }
                buf.append(value.charAt(i));
            }
        } else {
            buf.append(value);
        }
    }

    protected boolean stringToBoolean(String value) {
        return "1".equals(value) || "true".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value);
    }

    protected void attachDatabase(DBDatabase db, Connection conn) {
    }

    protected void detachDatabase(DBDatabase db, Connection conn) {
    }

    public void checkDatabase(DBDatabase db, String owner, Connection conn) {
        throw new NotImplementedException(this, "checkDatabase");
    }

    public void getDDLScript(DBCmdType type, DBObject dbo, DBSQLScript script) {
        throw new NotImplementedException(this, "getDDLScript");
    }

    public void addEnableRelationStmt(DBRelation r, boolean enable, DBSQLScript script) {
        if (enable) {
            this.getDDLScript(DBCmdType.CREATE, r, script);
        } else {
            this.getDDLScript(DBCmdType.DROP, r, script);
        }
    }

    public boolean isDDLColumnDefaults() {
        return this.ddlColumnDefaults;
    }

    public void setDDLColumnDefaults(boolean ddlColumnDefaults) {
        this.ddlColumnDefaults = ddlColumnDefaults;
    }

    public Timestamp getUpdateTimestamp(Connection conn) {
        Date date = new Date();
        return new Timestamp(date.getTime());
    }

    public static class DBSeqTable
    extends DBTable {
        private static final long serialVersionUID = 1L;
        public DBColumn C_SEQNAME = this.addColumn("SeqName", DataType.VARCHAR, 40.0, true);
        public DBColumn C_SEQVALUE = this.addColumn("SeqValue", DataType.INTEGER, 0.0, true);
        public DBColumn C_TIMESTAMP = this.addColumn("SeqTime", DataType.DATETIME, 0.0, true);

        public DBSeqTable(String tableName, DBDatabase db) {
            super(tableName, db);
            this.setPrimaryKey(this.C_SEQNAME);
        }

        public Object getNextValue(String SeqName, long minValue, Connection conn) {
            DBDatabaseDriver driver = this.db.getDriver();
            PreparedStatement stmt = null;
            try {
                DBCommand cmd = driver.createCommand(this.db);
                DBCmdParam nameParam = cmd.addParam(SeqName);
                cmd.select((DBColumnExpr)this.C_SEQVALUE);
                cmd.select((DBColumnExpr)this.C_TIMESTAMP);
                cmd.where((DBCompareExpr)this.C_SEQNAME.is(nameParam));
                String selectCmd = cmd.getSelect();
                long seqValue = 0L;
                while (seqValue == 0L) {
                    stmt = conn.prepareStatement(selectCmd, 1004, 1007);
                    stmt.setString(1, SeqName);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        seqValue = Math.max(rs.getLong(1) + 1L, minValue);
                        Timestamp current = rs.getTimestamp(2);
                        this.db.closeResultSet(rs);
                        cmd.clear();
                        DBCmdParam name = cmd.addParam(SeqName);
                        DBCmdParam time = cmd.addParam(current);
                        cmd.set(this.C_SEQVALUE.to(seqValue));
                        cmd.set(this.C_TIMESTAMP.to(DBDatabase.SYSDATE));
                        cmd.where((DBCompareExpr)this.C_SEQNAME.is(name));
                        cmd.where((DBCompareExpr)this.C_TIMESTAMP.is(time));
                        if (driver.executeSQL(cmd.getUpdate(), cmd.getParamValues(), conn, null) < 1) {
                            seqValue = 0L;
                        }
                    } else {
                        this.db.closeResultSet(rs);
                        seqValue = minValue;
                        log.warn("Sequence {} does not exist! Creating sequence with start-value of {}", (Object)SeqName, (Object)seqValue);
                        cmd.clear();
                        cmd.set(this.C_SEQNAME.to(SeqName));
                        cmd.set(this.C_SEQVALUE.to(seqValue));
                        cmd.set(this.C_TIMESTAMP.to(DBDatabase.SYSDATE));
                        if (driver.executeSQL(cmd.getInsert(), cmd.getParamValues(), conn, null) < 1) {
                            seqValue = 0L;
                        }
                    }
                    if (seqValue == 0L) {
                        log.warn("Failed to increment sequence {}. Trying again!", (Object)SeqName);
                    }
                    this.db.closeStatement(stmt);
                    cmd.clear();
                    rs = null;
                }
                if (log.isInfoEnabled()) {
                    log.info("Sequence {} incremented to {}.", (Object)SeqName, (Object)seqValue);
                }
                Long l = new Long(seqValue);
                this.db.closeStatement(stmt);
                return l;
            }
            catch (SQLException e) {
                try {
                    throw new EmpireSQLException(this, e);
                }
                catch (Throwable throwable) {
                    this.db.closeStatement(stmt);
                    throw throwable;
                }
            }
        }
    }

    public static interface DBSetGenKeys {
        public void set(Object var1);
    }
}

