/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.empire.commons.Options;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.expr.order.DBOrderByExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class DBCommandExpr
extends DBExpr {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBCommandExpr.class);
    protected DBCmdQuery cmdQuery = null;
    protected List<DBOrderByExpr> orderBy = null;

    public abstract boolean isValid();

    public abstract void getSelect(StringBuilder var1);

    public abstract DBColumnExpr[] getSelectExprList();

    public abstract Object[] getParamValues();

    protected DBColumnExpr getCmdColumn(DBColumnExpr col) {
        if (col instanceof DBCmdColumn) {
            DBCmdColumn c = (DBCmdColumn)col;
            if (c.getRowSet() == this.cmdQuery) {
                return col;
            }
            col = c.expr;
        }
        if (this.cmdQuery == null) {
            this.cmdQuery = new DBCmdQuery(this, this.getSelectExprList());
        }
        return new DBCmdColumn((DBRowSet)this.cmdQuery, col);
    }

    public final String getSelect() {
        StringBuilder sql = new StringBuilder();
        this.getSelect(sql);
        return sql.toString();
    }

    protected void addListExpr(StringBuilder buf, List<? extends DBExpr> list, long context, String separator) {
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            list.get(i).addSQL(buf, context);
        }
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        buf.append("(");
        buf.append(this.getSelect());
        buf.append(")");
    }

    public DBCommandExpr union(DBCommandExpr other) {
        DBDatabaseDriver driver = this.getDatabase().getDriver();
        return driver.createCombinedCommand(this, "UNION", other);
    }

    public DBCommandExpr unionAll(DBCommandExpr other) {
        DBDatabaseDriver driver = this.getDatabase().getDriver();
        return driver.createCombinedCommand(this, "UNION ALL", other);
    }

    public DBCommandExpr intersect(DBCommandExpr other) {
        DBDatabaseDriver driver = this.getDatabase().getDriver();
        return driver.createCombinedCommand(this, "INTERSECT", other);
    }

    public boolean hasOrderBy() {
        return this.orderBy != null ? !this.orderBy.isEmpty() : false;
    }

    public List<DBOrderByExpr> getOrderBy() {
        return this.orderBy != null ? Collections.unmodifiableList(this.orderBy) : null;
    }

    public void clearOrderBy() {
        this.orderBy = null;
    }

    public void orderBy(DBOrderByExpr ... exprs) {
        if (this.orderBy == null) {
            this.orderBy = new ArrayList<DBOrderByExpr>();
        }
        for (DBOrderByExpr expr : exprs) {
            for (DBOrderByExpr ob : this.orderBy) {
                if (!ob.getColumnExpr().equals(expr.getColumnExpr())) continue;
                ob.setDescending(expr.isDescending());
                expr = null;
                break;
            }
            if (expr == null) continue;
            this.orderBy.add(expr);
        }
    }

    public void limitRows(int numRows) {
        throw new NotSupportedException(this, "limitRows");
    }

    public void skipRows(int numRows) {
        throw new NotSupportedException(this, "skipRows");
    }

    public void clearLimit() {
    }

    public final void orderBy(DBColumnExpr ... exprs) {
        for (DBColumnExpr expr : exprs) {
            this.orderBy(new DBOrderByExpr(expr, false));
        }
    }

    public final void orderBy(DBColumnExpr expr, boolean desc) {
        this.orderBy(new DBOrderByExpr(expr, desc));
    }

    protected String getInsertInto(DBTable table, DBColumnExpr[] select, List<DBColumnExpr> columns) {
        if (select == null) {
            throw new ObjectNotValidException(this);
        }
        StringBuilder buf = new StringBuilder("INSERT INTO ");
        table.addSQL(buf, 2L);
        if (columns != null && columns.size() > 0) {
            if (columns.size() != select.length) {
                throw new InvalidArgumentException("columns", "size()!=select.length");
            }
            buf.append(" (");
            this.addListExpr(buf, columns, 1L, ", ");
            buf.append(")");
        }
        buf.append("\r\n");
        this.getSelect(buf);
        return buf.toString();
    }

    public final String getInsertInto(DBTable table, List<DBColumnExpr> columns) {
        return this.getInsertInto(table, this.getSelectExprList(), columns);
    }

    public final String getInsertInto(DBTable table) {
        DBColumnExpr[] select = this.getSelectExprList();
        if (select == null || select.length < 1) {
            throw new ObjectNotValidException(this);
        }
        ArrayList<DBColumnExpr> inscols = new ArrayList<DBColumnExpr>(select.length);
        for (int i = 0; i < select.length; ++i) {
            DBColumnExpr expr = select[i];
            DBColumn col = table.getColumn(expr.getName());
            if (col == null) {
                log.warn("InsertInto: Column " + expr.getName() + " not found!");
                col = table.getColumn(i);
            }
            inscols.add(col);
        }
        return this.getInsertInto(table, select, inscols);
    }

    protected static class DBCmdColumn
    extends DBColumn {
        private static final long serialVersionUID = 1L;
        private DBColumnExpr expr;

        public DBCmdColumn(DBRowSet query, DBColumnExpr expr) {
            super(query, expr.getName());
            this.expr = expr;
        }

        @Override
        public void addSQL(StringBuilder buf, long context) {
            buf.append(this.expr.getName());
        }

        @Override
        public DataType getDataType() {
            return this.expr.getDataType();
        }

        @Override
        public double getSize() {
            return 0.0;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public boolean isAutoGenerated() {
            return false;
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public Object getAttribute(String name) {
            if (this.attributes != null && this.attributes.indexOf(name) >= 0) {
                return this.attributes.get(name);
            }
            DBColumn column = this.expr.getUpdateColumn();
            if (column != null) {
                return column.getAttribute(name);
            }
            return null;
        }

        @Override
        public Options getOptions() {
            if (this.options != null) {
                return this.options;
            }
            DBColumn column = this.expr.getUpdateColumn();
            if (column != null) {
                return column.getOptions();
            }
            return null;
        }

        @Override
        public Object validate(Object value) {
            return value;
        }

        @Override
        public Element addXml(Element parent, long flags) {
            return this.expr.addXml(parent, flags);
        }
    }

    protected static class DBCmdQuery
    extends DBRowSet {
        private static final long serialVersionUID = 1L;
        private DBCommandExpr cmd;

        public DBCmdQuery(DBCommandExpr cmd, DBColumnExpr[] colList) {
            super(cmd.getDatabase());
            this.cmd = cmd;
            for (int i = 0; i < colList.length; ++i) {
                this.columns.add(colList[i].getUpdateColumn());
            }
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getAlias() {
            return null;
        }

        @Override
        public boolean isUpdateable() {
            return false;
        }

        @Override
        public void addReferencedColumns(Set<DBColumn> list) {
            list.addAll(this.columns);
        }

        @Override
        public void addSQL(StringBuilder buf, long context) {
            buf.append("(");
            buf.append(this.cmd.getSelect());
            buf.append(")");
        }

        @Override
        public DBColumn[] getKeyColumns() {
            throw new NotSupportedException(this, "getKeyColumns");
        }

        @Override
        public Object[] getRecordKey(DBRecord rec) {
            throw new NotSupportedException(this, "getRecordKey");
        }

        @Override
        public void initRecord(DBRecord rec, Object[] keyValues, boolean insert) {
            throw new NotSupportedException(this, "initRecord");
        }

        @Override
        public void createRecord(DBRecord rec, Connection conn) {
            throw new NotSupportedException(this, "addRecord");
        }

        @Override
        public void readRecord(DBRecord rec, Object[] keys, Connection conn) {
            throw new NotSupportedException(this, "getRecord");
        }

        @Override
        public void updateRecord(DBRecord rec, Connection conn) {
            throw new NotSupportedException(this, "updateRecord");
        }

        @Override
        public void deleteRecord(Object[] keys, Connection conn) {
            throw new NotSupportedException(this, "deleteRecord");
        }
    }
}

