/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Set;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.DatabaseNotOpenException;
import org.apache.empire.db.expr.set.DBSetExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class DBColumn
extends DBColumnExpr
implements Column {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBColumn.class);
    public static final String DBCOLATTR_SINGLEBYTECHARS = "singleByteChars";
    protected final transient DBRowSet rowset;
    protected final String name;
    protected String comment;
    private Boolean quoteName = null;

    protected DBColumn(DBRowSet rowset, String name) {
        this.rowset = rowset;
        this.name = name;
        this.comment = null;
    }

    public String getId() {
        return this.rowset.getId() + "." + this.name;
    }

    public static DBColumn findById(String columnId) {
        String colname;
        int i = columnId.lastIndexOf(46);
        if (i < 0) {
            throw new InvalidArgumentException("columnId", columnId);
        }
        String rsid = columnId.substring(0, i);
        DBRowSet rset = DBRowSet.findById(rsid);
        DBColumn col = rset.getColumn(colname = columnId.substring(i + 1));
        if (col == null) {
            throw new ItemNotFoundException((Object)columnId);
        }
        return col;
    }

    private void writeObject(ObjectOutputStream strm) throws IOException {
        if (this.rowset == null) {
            strm.writeObject("");
            strm.defaultWriteObject();
            return;
        }
        String dbid = this.rowset.getDatabase().getId();
        String rsname = this.rowset.getName();
        strm.writeObject(dbid);
        strm.writeObject(rsname);
        if (log.isDebugEnabled()) {
            log.debug("Serialization: writing DBColumn " + dbid + "." + rsname);
        }
        strm.defaultWriteObject();
    }

    private void readObject(ObjectInputStream strm) throws IOException, ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String dbid = String.valueOf(strm.readObject());
        if (StringUtils.isNotEmpty(dbid)) {
            DBDatabase db;
            String rsname = String.valueOf(strm.readObject());
            if (log.isDebugEnabled()) {
                log.debug("Serialization: reading DBColumn " + dbid + "." + rsname);
            }
            if ((db = DBDatabase.findById(dbid)) == null) {
                throw new ClassNotFoundException(dbid);
            }
            DBRowSet srs = db.getRowSet(rsname);
            if (srs == null) {
                throw new ClassNotFoundException(dbid + "." + rsname);
            }
            Field f = DBColumn.class.getDeclaredField("rowset");
            f.setAccessible(true);
            f.set(this, srs);
            f.setAccessible(false);
        }
        strm.defaultReadObject();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (this.rowset == null) {
            return super.equals(other);
        }
        if (other instanceof DBColumn) {
            DBColumn c = (DBColumn)other;
            if (!this.rowset.equals(c.getRowSet())) {
                return false;
            }
            return StringUtils.compareEqual(this.name, c.getName(), true);
        }
        return false;
    }

    public int hashCode() {
        if (this.rowset == null || this.name == null) {
            return super.hashCode();
        }
        return this.rowset.hashCode() + this.name.hashCode();
    }

    @Override
    public abstract double getSize();

    @Override
    public abstract boolean isRequired();

    @Override
    public abstract boolean isAutoGenerated();

    @Override
    public abstract boolean isReadOnly();

    @Override
    public abstract Object validate(Object var1);

    @Deprecated
    public final void checkValue(Object value) {
        this.validate(value);
    }

    @Override
    public abstract Element addXml(Element var1, long var2);

    @Override
    public DBDatabase getDatabase() {
        return this.rowset != null ? this.rowset.getDatabase() : null;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        list.add(this);
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        DBDatabaseDriver driver;
        if ((context & 2L) != 0L) {
            buf.append(this.rowset.getAlias());
            buf.append(".");
        }
        if ((driver = this.getDatabase().getDriver()) == null) {
            throw new DatabaseNotOpenException(this.getDatabase());
        }
        if (this.quoteName == null) {
            this.quoteName = driver.detectQuoteName(this.name);
        }
        driver.appendElementName(buf, this.name, this.quoteName);
    }

    @Override
    public DBColumn getUpdateColumn() {
        return this;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    public DBRowSet getRowSet() {
        return this.rowset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        return this.rowset.getFullName() + "." + this.name;
    }

    public String getAlias() {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        String rsName = this.rowset.getName();
        if (StringUtils.isEmpty(rsName)) {
            return this.name;
        }
        return rsName + "_" + this.name;
    }

    public DBColumnExpr qualified() {
        return this.as(this.getAlias());
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : null;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    public final boolean isEnum() {
        return this.getEnumType() != null;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return this.attributes != null ? (Class)this.getAttribute("enumType") : null;
    }

    public DBColumnExpr decodeEnum() {
        return super.decodeEnum(this.getEnumType(), null);
    }

    public DBColumnExpr decodeSort(boolean defaultToEnd) {
        if (this.getDataType().isNumeric()) {
            log.warn("Unnecessary decode for numeric column");
            return this;
        }
        return super.decodeSort(this.getEnumType(), defaultToEnd);
    }

    public DBSetExpr to(Object value) {
        return new DBSetExpr(this, value);
    }

    public String toString() {
        if (this.rowset == null) {
            return this.name;
        }
        return this.rowset.getName() + "." + this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

