/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.spring;

import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class DBDatabaseFactoryBean
implements FactoryBean<DBDatabase>,
InitializingBean {
    private boolean singleton = true;
    private DBDatabase singletonInstance;
    private String schema;
    private String linkName;
    private DBDatabaseDriver driver;
    private boolean preparedStatementsEnabled = true;
    private Class<? extends DBDatabase> databaseClass = null;
    private boolean earlyOpen = true;
    private Class<DBDatabaseDriver> driverClass;

    public final void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setDatabaseClass(Class<? extends DBDatabase> databaseClass) {
        this.databaseClass = databaseClass;
    }

    public void setEarlyOpen(boolean earlyOpen) {
        this.earlyOpen = earlyOpen;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public void setDriver(DBDatabaseDriver driver) {
        this.driver = driver;
    }

    public void setDriverClass(Class<DBDatabaseDriver> driverClass) {
        this.driverClass = driverClass;
    }

    public void setPreparedStatementsEnabled(boolean preparedStatementsEnabled) {
        this.preparedStatementsEnabled = preparedStatementsEnabled;
    }

    public DBDatabase getObject() throws Exception {
        if (this.singleton) {
            return this.singletonInstance;
        }
        return this.createInstance();
    }

    public Class<?> getObjectType() {
        return DBDatabase.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.driver == null && this.driverClass == null) {
            throw new RuntimeException("driver or driverClass must be set");
        }
        if (this.driver == null) {
            this.driver = this.driverClass.newInstance();
        }
        if (this.singleton) {
            this.singletonInstance = this.createInstance();
        }
    }

    protected DBDatabase createInstance() {
        DefaultDb database = null;
        if (this.databaseClass == null) {
            database = new DefaultDb();
        } else {
            try {
                database = this.databaseClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create database: " + this.databaseClass, e);
            }
        }
        if (this.schema != null && this.schema.trim().length() > 0) {
            database.setSchema(this.schema);
        }
        if (this.linkName != null && this.linkName.trim().length() > 0) {
            database.setLinkName(this.linkName);
        }
        database.setPreparedStatementsEnabled(this.preparedStatementsEnabled);
        if (this.earlyOpen) {
            database.open(this.driver, null);
        }
        return database;
    }

    public static class DefaultDb
    extends DBDatabase {
        private static final long serialVersionUID = 1L;
    }
}

