/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.validation;

import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBView;
import org.apache.empire.db.validation.DBModelErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBModelErrorLogger
implements DBModelErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(DBModelErrorLogger.class);

    @Override
    public void itemNotFound(DBObject dbo) {
        if (dbo instanceof DBTable) {
            DBTable table = (DBTable)dbo;
            log.error("The table {} does not exist in the target database.", (Object)table.getName());
        } else if (dbo instanceof DBColumn) {
            DBColumn column = (DBColumn)dbo;
            log.error("The column {} does not exist in the target database.", (Object)column.getFullName());
        } else if (dbo instanceof DBIndex) {
            DBIndex dbi = (DBIndex)dbo;
            log.error("The primary key {} for table{} does not exist in the target database.", (Object)dbi.getName(), (Object)dbi.getTable().getName());
        } else if (dbo instanceof DBView) {
            DBView view = (DBView)dbo;
            log.error("The view {} does not exist in the target database.", (Object)view.getName());
        } else if (dbo instanceof DBRelation) {
            DBRelation relation = (DBRelation)dbo;
            log.error("The foreing key relation " + relation.getName() + " from table {} to table {} does not exist in the target database.", (Object)relation.getForeignKeyTable().getName(), (Object)relation.getReferencedTable().getName());
        } else {
            log.error("The object {} does not exist in the target database.", (Object)dbo.toString());
        }
    }

    @Override
    public void columnTypeMismatch(DBColumn col, DataType type) {
        if (col instanceof DBView.DBViewColumn && col.getDataType() == DataType.DECIMAL && type == DataType.INTEGER) {
            return;
        }
        log.error("The column " + col.getFullName() + " type of {} does not match the database type of {}.", (Object)col.getDataType(), (Object)type);
    }

    @Override
    public void columnSizeMismatch(DBColumn col, int size, int scale) {
        if (size > 0 && (double)size < col.getSize()) {
            log.error("The column " + col.getFullName() + " size of {} does not match the database size of {}.", (Object)col.getSize(), (Object)size);
        } else if (col.getDataType() != DataType.INTEGER) {
            log.warn("The column " + col.getFullName() + " size of {} does not match the database size of {}.", (Object)col.getSize(), (Object)size);
        }
    }

    @Override
    public void columnNullableMismatch(DBColumn col, boolean nullable) {
        if (nullable) {
            log.error("The column " + col.getFullName() + " must not be nullable");
        } else {
            log.error("The column " + col.getFullName() + " must be nullable");
        }
    }

    @Override
    public void primaryKeyColumnMissing(DBIndex primaryKey, DBColumn column) {
        log.error("The primary key " + primaryKey.getName() + " of table " + primaryKey.getTable().getName() + " misses the column " + column.getName());
    }
}

