/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.oracle;

import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.oracle.DBDatabaseDriverOracle;

public class OracleDDLGenerator
extends DBDDLGenerator<DBDatabaseDriverOracle> {
    public OracleDDLGenerator(DBDatabaseDriverOracle driver) {
        super(driver);
        this.databaseObjectName = "USER";
        this.alterColumnPhrase = " MODIFY ";
        this.namePrimaryKeyConstraint = true;
        this.initDataTypes(driver);
    }

    private void initDataTypes(DBDatabaseDriverOracle driver) {
        this.DATATYPE_INT_SMALL = "NUMBER(5)";
        this.DATATYPE_INT_BIG = "NUMBER(38)";
        this.DATATYPE_VARCHAR = "VARCHAR2";
        this.DATATYPE_DECIMAL = "NUMBER";
        this.DATATYPE_BOOLEAN = driver.getBooleanType() == DBDatabaseDriverOracle.BooleanType.CHAR ? "CHAR(1)" : "NUMBER(1,0)";
    }

    @Override
    protected boolean appendColumnDataType(DataType type, double size, DBTableColumn c, StringBuilder sql) {
        switch (type) {
            case TEXT: 
            case VARCHAR: 
            case CHAR: {
                sql.append(type == DataType.CHAR ? this.DATATYPE_CHAR : this.DATATYPE_VARCHAR);
                int len = Math.abs((int)size);
                if (len == 0) {
                    len = type == DataType.CHAR ? 1 : 100;
                }
                sql.append("(");
                sql.append(String.valueOf(len));
                sql.append(c.isSingleByteChars() ? " BYTE)" : " CHAR)");
                break;
            }
            case BOOL: {
                if (((DBDatabaseDriverOracle)this.driver).getBooleanType() == DBDatabaseDriverOracle.BooleanType.CHAR) {
                    sql.append("CHAR(1)");
                    break;
                }
                sql.append("NUMBER(1,0)");
                break;
            }
            default: {
                return super.appendColumnDataType(type, size, c, sql);
            }
        }
        return true;
    }

    @Override
    protected void createDatabase(DBDatabase db, DBSQLScript script) {
        for (DBTable table : db.getTables()) {
            for (DBColumn dbColumn : table.getColumns()) {
                DBTableColumn c = (DBTableColumn)dbColumn;
                if (c.getDataType() != DataType.AUTOINC) continue;
                this.createSequence(db, c, script);
            }
        }
        super.createDatabase(db, script);
    }

    @Override
    protected void dropDatabase(DBDatabase db, DBSQLScript script) {
        this.dropObject(null, db.getSchema(), "USER", script);
    }

    @Override
    public void getDDLScript(DBCmdType type, DBObject dbo, DBSQLScript script) {
        super.getDDLScript(type, dbo, script);
        if (type == DBCmdType.DROP && dbo instanceof DBTable) {
            for (DBColumn c : ((DBTable)dbo).getColumns()) {
                if (c.getDataType() != DataType.AUTOINC || !(c instanceof DBTableColumn)) continue;
                DBTableColumn column = (DBTableColumn)c;
                script.addStmt("DROP SEQUENCE " + column.getSequenceName());
            }
        }
    }

    protected void createSequence(DBDatabase db, DBTableColumn c, DBSQLScript script) {
        String seqName = c.getSequenceName();
        StringBuilder sql = new StringBuilder();
        sql.append("-- creating sequence for column ");
        sql.append(c.getFullName());
        sql.append(" --\r\n");
        sql.append("CREATE SEQUENCE ");
        db.appendQualifiedName(sql, seqName, this.detectQuoteName(seqName));
        sql.append(" INCREMENT BY 1 START WITH 1 MINVALUE 0 NOCYCLE NOCACHE NOORDER");
        script.addStmt(sql);
    }

    @Override
    protected void createTable(DBTable t, DBSQLScript script) {
        super.createTable(t, script);
        DBDatabase db = t.getDatabase();
        this.createComment(db, "TABLE", t, t.getComment(), script);
        for (DBColumn c : t.getColumns()) {
            String com = c.getComment();
            if (com == null) continue;
            this.createComment(db, "COLUMN", c, com, script);
        }
    }

    protected void createComment(DBDatabase db, String type, DBExpr expr, String comment, DBSQLScript script) {
        if (comment == null || comment.length() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("COMMENT ON ");
        sql.append(type);
        sql.append(" ");
        if (expr instanceof DBColumn) {
            DBColumn c = (DBColumn)expr;
            c.getRowSet().addSQL(sql, 1L);
            sql.append(".");
        }
        expr.addSQL(sql, 1L);
        sql.append(" IS '");
        sql.append(comment);
        sql.append("'");
        script.addStmt(sql);
    }
}

