/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBDriverFeature;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBReader;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.DBView;
import org.apache.empire.db.exceptions.EmpireSQLException;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.oracle.DBCommandOracle;
import org.apache.empire.db.oracle.OracleDDLGenerator;
import org.apache.empire.db.oracle.OracleDataDictionnary;
import org.apache.empire.db.oracle.OracleSYSDatabase;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBDatabaseDriverOracle
extends DBDatabaseDriver {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBDatabaseDriverOracle.class);
    private boolean oracle8Compatibilty = false;
    private BooleanType booleanType = BooleanType.NUMBER;
    private DBDDLGenerator<?> ddlGenerator = null;

    public DBDatabaseDriverOracle() {
        log.info("DBDatabaseDriverOracle created. Boolean Type is " + (Object)((Object)this.booleanType));
        this.reservedSQLKeywords.add("date");
        this.reservedSQLKeywords.add("number");
    }

    public boolean isOracle8Compatibilty() {
        return this.oracle8Compatibilty;
    }

    public void setOracle8Compatibilty(boolean oracle8Compatibilty) {
        this.oracle8Compatibilty = oracle8Compatibilty;
    }

    public BooleanType getBooleanType() {
        return this.booleanType;
    }

    public void setBooleanType(BooleanType booleanType) {
        this.booleanType = booleanType;
        log.info("DBDatabaseDriverOracle Boolean Type set to " + (Object)((Object)booleanType));
    }

    @Override
    public boolean isSupported(DBDriverFeature type) {
        switch (type) {
            case CREATE_SCHEMA: {
                return false;
            }
            case SEQUENCES: {
                return true;
            }
            case SEQUENCE_NEXTVAL: {
                return true;
            }
            case QUERY_LIMIT_ROWS: {
                return true;
            }
            case QUERY_SKIP_ROWS: {
                return true;
            }
        }
        return false;
    }

    @Override
    public DBCommand createCommand(DBDatabase db) {
        if (db == null) {
            return null;
        }
        return new DBCommandOracle(db);
    }

    @Override
    public String getSQLPhrase(int phrase) {
        switch (phrase) {
            case 1: {
                return "null";
            }
            case 2: {
                return " ? ";
            }
            case 3: {
                return " ";
            }
            case 4: {
                return " AS ";
            }
            case 5: {
                return "@";
            }
            case 6: {
                return "\"";
            }
            case 7: {
                return "\"";
            }
            case 8: {
                return " || ";
            }
            case 9: {
                return "DUAL";
            }
            case 10: {
                return this.booleanType == BooleanType.CHAR ? "'Y'" : "1";
            }
            case 11: {
                return this.booleanType == BooleanType.CHAR ? "'N'" : "0";
            }
            case 20: {
                return "sysdate";
            }
            case 21: {
                return "yyyy-MM-dd";
            }
            case 22: {
                return "TO_DATE('{0}', 'YYYY-MM-DD')";
            }
            case 25: {
                return "systimestamp";
            }
            case 23: 
            case 26: {
                return "yyyy-MM-dd HH:mm:ss.SSS";
            }
            case 24: 
            case 27: {
                return "TO_TIMESTAMP('{0}', 'YYYY.MM.DD HH24:MI:SS.FF')";
            }
            case 100: {
                return "nvl(?, {0})";
            }
            case 101: {
                return "substr(?, {0})";
            }
            case 102: {
                return "substr(?, {0}, {1})";
            }
            case 103: {
                return "replace(?, {0}, {1})";
            }
            case 104: {
                return "reverse(?)";
            }
            case 105: {
                return "instr(?, {0})";
            }
            case 106: {
                return "instr(?, {0}, {1})";
            }
            case 107: {
                return "length(?)";
            }
            case 110: {
                return "upper(?)";
            }
            case 111: {
                return "lower(?)";
            }
            case 112: {
                return "trim(?)";
            }
            case 113: {
                return "ltrim(?)";
            }
            case 114: {
                return "rtrim(?)";
            }
            case 119: {
                return "? escape '{0}'";
            }
            case 120: {
                return "abs(?)";
            }
            case 121: {
                return "round(?,{0})";
            }
            case 122: {
                return "trunc(?,{0})";
            }
            case 124: {
                return "ceil(?)";
            }
            case 123: {
                return "floor(?)";
            }
            case 125: {
                return "mod(?,{0})";
            }
            case 126: {
                return "TO_CHAR(?, {0:VARCHAR})";
            }
            case 132: {
                return this.oracle8Compatibilty ? "to_number(to_char(?,'DD'))" : "extract(day from ?)";
            }
            case 133: {
                return this.oracle8Compatibilty ? "to_number(to_char(?,'MM'))" : "extract(month from ?)";
            }
            case 134: {
                return this.oracle8Compatibilty ? "to_number(to_char(?,'YYYY'))" : "extract(year from ?)";
            }
            case 140: {
                return "sum(?)";
            }
            case 142: {
                return "max(?)";
            }
            case 143: {
                return "min(?)";
            }
            case 144: {
                return "avg(?)";
            }
            case 150: {
                return "decode(? {0})";
            }
            case 151: {
                return ",";
            }
            case 152: {
                return "{0}, {1}";
            }
            case 153: {
                return "{0}";
            }
        }
        log.error("SQL phrase " + phrase + " is not defined!");
        return "";
    }

    @Override
    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case TEXT: 
            case VARCHAR: 
            case CHAR: 
            case CLOB: {
                if (format != null) {
                    return "to_char(?, '" + format.toString() + "')";
                }
                return "to_char(?)";
            }
            case INTEGER: 
            case FLOAT: 
            case DECIMAL: {
                if (format != null) {
                    return "to_number(?, '" + format.toString() + "')";
                }
                return "to_number(?)";
            }
            case DATE: 
            case DATETIME: {
                if (format != null) {
                    return "to_date(?, '" + format.toString() + "')";
                }
                return "to_date(?)";
            }
            case TIMESTAMP: {
                if (format != null) {
                    return "to_timestamp(?, '" + format.toString() + "')";
                }
                return "to_timestamp(?)";
            }
        }
        log.error("getConvertPhrase: unknown type " + (Object)((Object)destType));
        return "?";
    }

    @Override
    public String extractErrorMessage(SQLException sqle) {
        String msg = sqle.getMessage();
        int end = (msg = msg.substring(msg.indexOf(58) + 1)).indexOf("ORA");
        if (end >= 0) {
            msg = msg.substring(0, end - 1);
        }
        return msg;
    }

    @Override
    public Object getResultValue(ResultSet rset, int columnIndex, DataType dataType) throws SQLException {
        if (dataType == DataType.BOOL) {
            String val = rset.getString(columnIndex);
            if (val == null || rset.wasNull()) {
                return null;
            }
            if (val.equalsIgnoreCase("Y") || val.equals("1")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return super.getResultValue(rset, columnIndex, dataType);
    }

    @Override
    public Object getNextSequenceValue(DBDatabase db, String seqName, int minValue, Connection conn) {
        StringBuilder sql = new StringBuilder(80);
        sql.append("SELECT ");
        db.appendQualifiedName(sql, seqName, this.detectQuoteName(seqName));
        sql.append(".NEXTVAL FROM DUAL");
        Object val = db.querySingleValue(sql.toString(), null, conn);
        if (val == null) {
            log.error("getNextSequenceValue: Invalid sequence value for sequence " + seqName);
        }
        return val;
    }

    @Override
    public DBColumnExpr getNextSequenceValueExpr(DBTableColumn column) {
        String seqName = StringUtils.toString(column.getDefaultValue());
        if (StringUtils.isEmpty(seqName)) {
            throw new InvalidArgumentException("column", column);
        }
        StringBuilder sql = new StringBuilder(80);
        column.getDatabase().appendQualifiedName(sql, seqName, this.detectQuoteName(seqName));
        sql.append(".NEXTVAL");
        return new DBValueExpr(column.getDatabase(), sql.toString(), DataType.UNKNOWN);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Timestamp getUpdateTimestamp(Connection conn) {
        Timestamp timestamp;
        ResultSet rs = null;
        try {
            rs = this.executeQuery("SELECT systimestamp FROM DUAL", null, false, conn);
            timestamp = rs.next() ? rs.getTimestamp(1) : null;
        }
        catch (SQLException e) {
            try {
                throw new EmpireSQLException(this, e);
            }
            catch (Throwable throwable) {
                try {
                    Statement stmt;
                    Statement statement = stmt = rs != null ? rs.getStatement() : null;
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw new EmpireSQLException(this, e2);
                }
            }
        }
        try {
            Statement stmt;
            Statement statement = stmt = rs != null ? rs.getStatement() : null;
            if (rs != null) {
                rs.close();
            }
            if (stmt == null) return timestamp;
            stmt.close();
            return timestamp;
        }
        catch (SQLException e) {
            throw new EmpireSQLException(this, e);
        }
    }

    @Override
    public void getDDLScript(DBCmdType type, DBObject dbo, DBSQLScript script) {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new OracleDDLGenerator(this);
        }
        this.ddlGenerator.getDDLScript(type, dbo, script);
    }

    @Override
    public void addEnableRelationStmt(DBRelation r, boolean enable, DBSQLScript script) {
        StringBuilder b = new StringBuilder();
        b.append("ALTER TABLE ");
        r.getForeignKeyTable().addSQL(b, 2L);
        b.append(enable ? " ENABLE " : " DISABLE ");
        b.append("CONSTRAINT ");
        b.append(r.getName());
        script.addStmt(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkDatabase(DBDatabase db, String owner, Connection conn) {
        if (owner == null || owner.length() == 0) {
            throw new InvalidArgumentException("owner", owner);
        }
        OracleSYSDatabase sysDB = new OracleSYSDatabase(this);
        DBCommand sysDBCommand = sysDB.createCommand();
        sysDBCommand.select(sysDB.CI.getColumns());
        sysDBCommand.where((DBCompareExpr)sysDB.CI.C_OWNER.is(owner));
        OracleDataDictionnary dataDictionnary = new OracleDataDictionnary();
        DBReader rd = new DBReader();
        try {
            rd.open(sysDBCommand, conn);
            log.info("---------------------------------------------------------------------------------");
            log.info("checkDatabase start: " + db.getClass().getName());
            String skipTable = "";
            while (rd.moveNext()) {
                String tableName = rd.getString(sysDB.CI.C_TABLE_NAME);
                if (tableName.equals(skipTable)) continue;
                String columnName = rd.getString(sysDB.CI.C_COLUMN_NAME);
                DBTable dbTable = db.getTable(tableName);
                DBView dbView = db.getView(tableName);
                String dataType = rd.getString(sysDB.CI.C_DATA_TYPE);
                int charLength = rd.getInt(sysDB.CI.C_CHAR_LENGTH);
                int dataLength = rd.getInt(sysDB.CI.C_DATA_LENGTH);
                int dataPrecision = rd.getInt(sysDB.CI.C_DATA_PRECISION);
                int dataScale = rd.getInt(sysDB.CI.C_DATA_SCALE);
                String nullable = rd.getString(sysDB.CI.C_NULLABLE);
                dataDictionnary.fillDataDictionnary(tableName, columnName, dataType, charLength, dataLength, dataPrecision, dataScale, nullable);
                if (dbTable != null) {
                    DBColumn col = dbTable.getColumn(columnName);
                    if (col != null) continue;
                    log.warn("COLUMN NOT FOUND IN " + db.getClass().getName() + "\t: [" + tableName + "][" + columnName + "][" + dataType + "][" + dataLength + "]");
                    continue;
                }
                if (dbView != null) {
                    log.debug("Column check for view " + tableName + " not yet implemented.");
                    continue;
                }
                log.debug("TABLE OR VIEW NOT FOUND IN " + db.getClass().getName() + "\t: [" + tableName + "]");
                skipTable = tableName;
            }
            dataDictionnary.checkDBTableDefinition(db.getTables());
            dataDictionnary.checkDBViewDefinition(db.getViews());
            log.info("checkDatabase end: " + db.getClass().getName());
            log.info("---------------------------------------------------------------------------------");
        }
        finally {
            rd.close();
        }
    }

    public static enum BooleanType {
        CHAR,
        NUMBER;

    }
}

