/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.join;

import java.util.Set;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBJoinType;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.expr.join.DBJoinExpr;

public class DBCrossJoinExpr
extends DBJoinExpr {
    private static final long serialVersionUID = 1L;
    protected DBRowSet left;
    protected DBRowSet right;

    public DBCrossJoinExpr(DBRowSet left, DBRowSet right) {
        super(DBJoinType.FULL);
        this.left = left;
        this.right = right;
    }

    @Override
    public DBDatabase getDatabase() {
        return this.left.getDatabase();
    }

    @Override
    public DBRowSet getLeftTable() {
        return this.left;
    }

    @Override
    public DBRowSet getRightTable() {
        return this.right;
    }

    @Override
    public boolean isJoinOn(DBRowSet rowset) {
        if (rowset == null) {
            return false;
        }
        return rowset.equals(this.left) || rowset.equals(this.right);
    }

    @Override
    public boolean isJoinOn(DBColumn column) {
        return false;
    }

    @Override
    public DBRowSet getOuterTable() {
        return null;
    }

    @Override
    public void reverse() {
        DBRowSet swap = this.left;
        this.left = this.right;
        this.right = swap;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        if ((context & 1L) != 0L) {
            this.left.addSQL(buf, 15L);
        }
        if ((context & 4L) != 0L) {
            buf.append(" CROSS JOIN ");
            this.right.addSQL(buf, 15L);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBCrossJoinExpr)) {
            return super.equals(obj);
        }
        DBCrossJoinExpr other = (DBCrossJoinExpr)obj;
        if (this.left.equals(other.left) && this.right.equals(other.right)) {
            return true;
        }
        return this.left.equals(other.right) && this.right.equals(other.left);
    }
}

