/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.join;

import java.util.HashSet;
import java.util.Set;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBJoinType;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.join.DBJoinExpr;
import org.apache.empire.exceptions.InvalidPropertyException;

public class DBColumnJoinExpr
extends DBJoinExpr {
    private static final long serialVersionUID = 1L;
    protected DBColumnExpr left;
    protected DBColumnExpr right;
    public DBCompareExpr compExpr = null;

    public DBColumnJoinExpr(DBColumnExpr left, DBColumnExpr right, DBJoinType type) {
        super(type);
        this.left = left;
        this.right = right;
    }

    @Override
    public DBDatabase getDatabase() {
        return this.left.getDatabase();
    }

    public DBColumnExpr getLeft() {
        return this.left;
    }

    public DBColumnExpr getRight() {
        return this.right;
    }

    @Override
    public DBRowSet getLeftTable() {
        DBColumn col = this.left.getUpdateColumn();
        if (col == null) {
            throw new InvalidPropertyException("left", this.left);
        }
        return col.getRowSet();
    }

    @Override
    public DBRowSet getRightTable() {
        DBColumn col = this.right.getUpdateColumn();
        if (col == null) {
            throw new InvalidPropertyException("right", this.right);
        }
        return col.getRowSet();
    }

    @Override
    public boolean isJoinOn(DBRowSet rowset) {
        if (rowset == null) {
            return false;
        }
        return rowset.equals(this.getLeftTable()) || rowset.equals(this.getRightTable());
    }

    @Override
    public boolean isJoinOn(DBColumn column) {
        if (column == null) {
            return false;
        }
        if (column.equals(this.left.getUpdateColumn()) || column.equals(this.right.getUpdateColumn())) {
            return true;
        }
        if (this.compExpr != null) {
            HashSet<DBColumn> set = new HashSet<DBColumn>();
            this.compExpr.addReferencedColumns(set);
            return set.contains(column);
        }
        return false;
    }

    @Override
    public DBRowSet getOuterTable() {
        switch (this.type) {
            case LEFT: {
                return this.getRightTable();
            }
            case RIGHT: {
                return this.getLeftTable();
            }
        }
        return null;
    }

    @Override
    public void reverse() {
        DBColumnExpr swap = this.left;
        this.left = this.right;
        this.right = swap;
        this.type = DBJoinType.reversed(this.type);
    }

    public DBCompareExpr getWhere() {
        return this.compExpr;
    }

    public void where(DBCompareExpr expr) {
        this.compExpr = expr;
    }

    public DBJoinExpr and(DBColumnExpr c1, DBColumnExpr c2) {
        this.compExpr = this.compExpr == null ? c1.is(c2) : this.compExpr.and(c1.is(c2));
        return this;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.left.addReferencedColumns(list);
        this.right.addReferencedColumns(list);
        if (this.compExpr != null) {
            this.compExpr.addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        if ((context & 1L) != 0L) {
            this.getLeftTable().addSQL(buf, 15L);
        }
        if ((context & 4L) != 0L) {
            switch (this.type) {
                case LEFT: {
                    buf.append(" LEFT JOIN ");
                    break;
                }
                case INNER: {
                    buf.append(" INNER JOIN ");
                    break;
                }
                case RIGHT: {
                    buf.append(" RIGHT JOIN ");
                    break;
                }
                case FULL: {
                    buf.append(" FULL JOIN ");
                    break;
                }
                default: {
                    buf.append(" JOIN ");
                }
            }
            this.getRightTable().addSQL(buf, 15L);
            buf.append(" ON ");
            this.right.addSQL(buf, 7L);
            buf.append(" = ");
            this.left.addSQL(buf, 7L);
            if (this.compExpr != null) {
                buf.append(" AND ");
                this.compExpr.addSQL(buf, 7L);
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBColumnJoinExpr)) {
            return super.equals(obj);
        }
        DBColumnJoinExpr other = (DBColumnJoinExpr)obj;
        if (this.left.equals(other.left) && this.right.equals(other.right) && this.type == other.type) {
            return true;
        }
        return this.left.equals(other.right) && this.right.equals(other.left) && this.type == DBJoinType.reversed(other.type);
    }
}

