/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public class DBScalarExpr
extends DBColumnExpr {
    private static final long serialVersionUID = 1L;
    public final DBDatabase db;
    public final DataType dataType;
    public final String template;
    protected Object[] params;

    public DBScalarExpr(DBDatabase db, String template, Object[] params, DataType dataType) {
        this.db = db;
        this.dataType = dataType;
        this.template = template;
        this.params = params;
    }

    public DBScalarExpr(DBDatabase db, String template, Object param, DataType dataType) {
        this.db = db;
        this.dataType = dataType;
        this.template = template;
        this.params = new Object[]{param};
    }

    public Object[] getParams() {
        return this.params;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    @Override
    public DBDatabase getDatabase() {
        return this.db;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        String name = this.getName();
        if (name != null) {
            elem.setAttribute("name", this.getName());
        }
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        elem.setAttribute("function", this.template);
        return elem;
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        String text = this.template;
        if (this.params != null) {
            for (int i = 0; i < this.params.length; ++i) {
                String value = this.getObjectValue(this.dataType, this.params[i], 7L, ",");
                text = StringUtils.replaceAll(this.template, "{" + String.valueOf(i) + "}", value);
            }
        }
        buf.append(text);
    }
}

