/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBDriverFeature;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBReader;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRecordData;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.exceptions.FieldNotNullException;
import org.apache.empire.db.exceptions.InvalidKeyException;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.exceptions.QueryNoResultException;
import org.apache.empire.db.exceptions.RecordNotFoundException;
import org.apache.empire.db.exceptions.RecordUpdateFailedException;
import org.apache.empire.db.exceptions.RecordUpdateInvalidException;
import org.apache.empire.db.expr.column.DBCountExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBRowSet
extends DBExpr {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(DBRowSet.class);
    protected final transient DBDatabase db;
    protected String comment = null;
    protected DBIndex primaryKey = null;
    protected DBColumn timestampColumn = null;
    protected Map<DBColumn, DBColumn> columnReferences = null;
    protected List<DBColumn> columns = new ArrayList<DBColumn>();

    public DBRowSet(DBDatabase db) {
        this.db = db;
    }

    public String getId() {
        return this.db.getId() + "." + this.getName();
    }

    public static DBRowSet findById(String rowsetId) {
        int i = rowsetId.lastIndexOf(46);
        if (i < 0) {
            throw new InvalidArgumentException("rowsetId", rowsetId);
        }
        String dbid = rowsetId.substring(0, i);
        DBDatabase db = DBDatabase.findById(dbid);
        if (db == null) {
            throw new ItemNotFoundException((Object)dbid);
        }
        String rsname = rowsetId.substring(i + 1);
        DBRowSet rset = db.getRowSet(rsname);
        if (rset == null) {
            throw new ItemNotFoundException((Object)rowsetId);
        }
        return rset;
    }

    private void writeObject(ObjectOutputStream strm) throws IOException {
        if (this.db == null) {
            strm.writeObject("");
            strm.defaultWriteObject();
            return;
        }
        String dbid = this.db.getId();
        strm.writeObject(dbid);
        if (log.isDebugEnabled()) {
            log.debug("Serialization: writing DBRowSet " + dbid);
        }
        strm.defaultWriteObject();
    }

    private void readObject(ObjectInputStream strm) throws IOException, ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String dbid = String.valueOf(strm.readObject());
        if (StringUtils.isNotEmpty(dbid)) {
            DBDatabase sdb;
            if (log.isDebugEnabled()) {
                log.debug("Serialization: reading DBRowSet " + dbid);
            }
            if ((sdb = DBDatabase.findById(dbid)) == null) {
                throw new ClassNotFoundException(dbid);
            }
            Field f = DBRowSet.class.getDeclaredField("db");
            f.setAccessible(true);
            f.set(this, sdb);
            f.setAccessible(false);
        }
        strm.defaultReadObject();
    }

    public int hashCode() {
        String nameWithAlias = this.getFullName() + "_" + this.getAlias();
        return nameWithAlias.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (this.db == null) {
            return super.equals(other);
        }
        if (other instanceof DBRowSet) {
            DBRowSet r = (DBRowSet)other;
            if (!this.db.equals(r.getDatabase())) {
                return false;
            }
            if (this.getAlias() == null) {
                return super.equals(other);
            }
            return StringUtils.compareEqual(this.getAlias(), r.getAlias(), true);
        }
        return false;
    }

    public abstract String getName();

    public abstract String getAlias();

    public abstract boolean isUpdateable();

    public abstract void createRecord(DBRecord var1, Connection var2);

    public abstract void deleteRecord(Object[] var1, Connection var2);

    public String getFullName() {
        String name = this.getName();
        String schema = this.db.getSchema();
        return schema != null ? schema + "." + name : name;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        list.addAll(this.columns);
    }

    @Override
    public final DBDatabase getDatabase() {
        return this.db;
    }

    public List<DBColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public int getColumnIndex(DBColumn column) {
        return this.columns.indexOf(column);
    }

    public final int getColumnIndex(Column column) {
        return this.getColumnIndex((DBColumn)column);
    }

    public DBColumn getColumn(int iColumn) {
        if (iColumn < 0 || iColumn >= this.columns.size()) {
            return null;
        }
        return this.columns.get(iColumn);
    }

    public DBColumn getColumn(String name) {
        for (int i = 0; i < this.columns.size(); ++i) {
            DBColumn col = this.columns.get(i);
            if (!col.getName().equalsIgnoreCase(name)) continue;
            return col;
        }
        return null;
    }

    public boolean isColumnReadOnly(DBColumn col) {
        if (this.getColumnIndex(col) < 0) {
            return true;
        }
        if (col.isAutoGenerated() || col == this.timestampColumn) {
            return true;
        }
        return col.isReadOnly();
    }

    public DBColumn[] getKeyColumns() {
        return this.primaryKey != null ? this.primaryKey.getColumns() : null;
    }

    public boolean isKeyColumn(DBColumn column) {
        DBColumn[] keyColumns = this.getKeyColumns();
        if (keyColumns == null) {
            return false;
        }
        for (int i = 0; i < keyColumns.length; ++i) {
            if (keyColumns[i] != column) continue;
            return true;
        }
        return false;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public DBColumn getTimestampColumn() {
        return this.timestampColumn;
    }

    public void setTimestampColumn(DBColumn timestampColumn) {
        if (timestampColumn != null && timestampColumn.getRowSet() != this) {
            throw new InvalidArgumentException("timestampColumn", timestampColumn);
        }
        if (timestampColumn != null && this.timestampColumn != null && this.timestampColumn != timestampColumn) {
            log.warn("Timestamp column has already been set for rowset {}. Replacing with {}", (Object)this.getName(), (Object)timestampColumn.getName());
        }
        if (timestampColumn instanceof DBTableColumn) {
            ((DBTableColumn)timestampColumn).setReadOnly(true);
        }
        this.timestampColumn = timestampColumn;
    }

    public Map<DBColumn, DBColumn> getColumnReferences() {
        return this.columnReferences;
    }

    protected void addColumnReference(DBColumn source, DBColumn target) {
        if (source.getRowSet() != this) {
            throw new InvalidArgumentException("column", source.getFullName());
        }
        if (this.columnReferences == null) {
            this.columnReferences = new HashMap<DBColumn, DBColumn>();
        }
        this.columnReferences.put(source, target);
    }

    public DBColumnExpr count() {
        return new DBCountExpr(this);
    }

    protected String getRenameTablePhrase() {
        if (this.db == null || this.db.driver == null) {
            return " ";
        }
        return this.db.driver.getSQLPhrase(3);
    }

    public Object[] getRecordKey(DBRecord rec) {
        if (rec.getRowSet() != this) {
            return null;
        }
        if (this.primaryKey == null) {
            return null;
        }
        DBColumn[] keyColumns = this.primaryKey.getColumns();
        Object[] keys = new Object[keyColumns.length];
        for (int i = 0; i < keyColumns.length; ++i) {
            keys[i] = rec.getValue(keyColumns[i]);
            if (keys[i] != null) continue;
            log.warn("getRecordKey: " + this.getName() + " primary key value is null!");
        }
        return keys;
    }

    protected DBColumnExpr getColumnExprAt(int index) {
        return this.columns.get(index);
    }

    protected void prepareInitRecord(DBRecord rec, Object rowSetData, boolean insert) {
        if (rec == null) {
            throw new InvalidArgumentException("rec", rec);
        }
        if (this.columns.size() < 1) {
            throw new ObjectNotValidException(this);
        }
        rec.initData(this, rowSetData, insert);
    }

    public void initRecord(DBRecord rec, Object[] keyValues, boolean insert) {
        this.prepareInitRecord(rec, null, insert);
        Object[] fields = rec.getFields();
        if (keyValues != null && this.primaryKey != null) {
            DBColumn[] keyColumns = this.primaryKey.getColumns();
            for (int i = 0; i < keyColumns.length; ++i) {
                int field = this.getColumnIndex(keyColumns[i]);
                fields[field] = keyValues[i];
            }
        }
        this.completeInitRecord(rec);
    }

    public void initRecord(DBRecord rec, DBRecordData recData) {
        this.prepareInitRecord(rec, null, false);
        Object[] fields = rec.getFields();
        for (int i = 0; i < fields.length; ++i) {
            DBColumnExpr column = this.getColumnExprAt(i);
            int rdi = recData.getFieldIndex(column);
            if (rdi < 0) {
                if (this.primaryKey != null && column instanceof DBColumn && this.primaryKey.contains((DBColumn)column)) {
                    throw new ItemNotFoundException((Object)column.getName());
                }
                if (this.timestampColumn == column && log.isInfoEnabled()) {
                    log.info(this.getName() + "No record timestamp value has been provided. Hence concurrent changes will not be detected.");
                }
                fields[i] = ObjectUtils.NO_VALUE;
                continue;
            }
            fields[i] = recData.getValue(rdi);
        }
        this.completeInitRecord(rec);
    }

    protected void completeInitRecord(DBRecord rec) {
        rec.onRecordChanged();
    }

    protected void setKeyConstraints(DBCommand cmd, Object[] key) {
        if (this.primaryKey == null) {
            throw new NoPrimaryKeyException(this);
        }
        DBColumn[] keyColumns = this.primaryKey.getColumns();
        if (key == null || key.length != keyColumns.length) {
            throw new InvalidKeyException(this, key);
        }
        for (int i = 0; i < key.length; ++i) {
            Object value = key[i];
            if (this.db.isPreparedStatementsEnabled()) {
                value = cmd.addParam(keyColumns[i], value);
            }
            cmd.where((DBCompareExpr)keyColumns[i].is(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readRecord(DBRecord rec, DBCommand cmd, Connection conn) {
        DBReader reader = null;
        try {
            reader = new DBReader(false);
            reader.getRecordData(cmd, conn);
            this.initRecord(rec, reader);
        }
        finally {
            reader.close();
        }
    }

    public void readRecord(DBRecord rec, Object[] key, Connection conn) {
        if (conn == null || rec == null) {
            throw new InvalidArgumentException("conn|rec", null);
        }
        DBCommand cmd = this.db.createCommand();
        cmd.select(this.columns);
        this.setKeyConstraints(cmd, key);
        try {
            this.readRecord(rec, cmd, conn);
        }
        catch (QueryNoResultException e) {
            throw new RecordNotFoundException(this, key);
        }
    }

    public void readRecord(DBRecord rec, Object[] key, Connection conn, PartialMode mode, DBColumn ... columns) {
        if (conn == null || rec == null) {
            throw new InvalidArgumentException("conn|rec", null);
        }
        DBCommand cmd = this.db.createCommand();
        for (DBColumn column : this.columns) {
            if (this.isKeyColumn(column)) {
                cmd.select((DBColumnExpr)column);
                continue;
            }
            for (int i = 0; i < columns.length; ++i) {
                if (column.equals(columns[i])) {
                    if (mode != PartialMode.INCLUDE) continue;
                    cmd.select((DBColumnExpr)column);
                    continue;
                }
                if (mode != PartialMode.EXCLUDE) continue;
                cmd.select((DBColumnExpr)column);
            }
        }
        this.setKeyConstraints(cmd, key);
        try {
            this.readRecord(rec, cmd, conn);
        }
        catch (QueryNoResultException e) {
            throw new RecordNotFoundException(this, key);
        }
    }

    public boolean recordExists(Object[] key, Connection conn) {
        if (conn == null) {
            throw new InvalidArgumentException("conn", conn);
        }
        DBCommand cmd = this.db.createCommand();
        cmd.select(this.count());
        this.setKeyConstraints(cmd, key);
        return this.db.querySingleInt(cmd, 0, conn) == 1;
    }

    public final boolean recordExists(Object id, Connection conn) {
        return this.recordExists(new Object[]{id}, conn);
    }

    public void updateRecord(DBRecord rec, Connection conn) {
        int i;
        Object value;
        int i2;
        if (!this.isUpdateable()) {
            throw new NotSupportedException(this, "updateRecord");
        }
        if (rec == null) {
            throw new InvalidArgumentException("record", rec);
        }
        if (!rec.isValid()) {
            throw new ObjectNotValidException(rec);
        }
        if (conn == null) {
            throw new InvalidArgumentException("conn", conn);
        }
        String name = this.getName();
        Timestamp timestamp = this.timestampColumn != null ? this.db.getUpdateTimestamp(conn) : null;
        DBSetGenKey setGenKey = null;
        Object[] fields = rec.getFields();
        DBCommand cmd = this.db.createCommand();
        String sql = null;
        int setCount = 0;
        DBRecord.State recordState = rec.getState();
        if (recordState == DBRecord.State.New) {
            for (i2 = 0; i2 < this.columns.size(); ++i2) {
                value = fields[i2];
                DBTableColumn col = (DBTableColumn)this.columns.get(i2);
                if (this.timestampColumn == col) {
                    if (timestamp == null) continue;
                    cmd.set(col.to(timestamp));
                    continue;
                }
                boolean empty = ObjectUtils.isEmpty(value);
                if (empty && col.isAutoGenerated()) {
                    if (col.getDataType() == DataType.AUTOINC && !this.db.getDriver().isSupported(DBDriverFeature.SEQUENCES)) {
                        setGenKey = new DBSetGenKey(fields, i2);
                        continue;
                    }
                    fields[i2] = value = col.getRecordDefaultValue(conn);
                    empty = ObjectUtils.isEmpty(value);
                }
                if (!empty) {
                    cmd.set(col.to(value));
                    ++setCount;
                    continue;
                }
                if (this.primaryKey != null && this.primaryKey.contains(col)) {
                    throw new FieldNotNullException(col);
                }
                if (!col.isRequired()) continue;
                throw new FieldNotNullException(col);
            }
            sql = cmd.getInsert();
        } else if (recordState == DBRecord.State.Modified) {
            if (this.primaryKey == null) {
                log.error("updateRecord: " + name + " no primary key defined!");
                throw new NoPrimaryKeyException(this);
            }
            for (i2 = 0; i2 < this.columns.size(); ++i2) {
                value = fields[i2];
                boolean modified = rec.wasModified(i2);
                boolean empty = ObjectUtils.isEmpty(value);
                DBTableColumn col = (DBTableColumn)this.columns.get(i2);
                if (this.primaryKey.contains(col)) {
                    if (modified) {
                        log.warn("updateRecord: " + name + " primary has been modified!");
                    }
                    if (this.db.isPreparedStatementsEnabled()) {
                        value = cmd.addParam(col, value);
                    }
                    cmd.where((DBCompareExpr)col.is(value));
                    continue;
                }
                if (this.timestampColumn == col) {
                    if (!empty) {
                        if (this.db.isPreparedStatementsEnabled()) {
                            value = cmd.addParam(col, value);
                        }
                        cmd.where((DBCompareExpr)col.is(value));
                    } else if (value != ObjectUtils.NO_VALUE) {
                        log.warn("updateRecord has no value for timestamp column. Concurrent changes will not be detected.");
                    }
                    if (timestamp == null) continue;
                    cmd.set(col.to(timestamp));
                    continue;
                }
                if (!modified || value == ObjectUtils.NO_VALUE) continue;
                if (col.isReadOnly()) {
                    log.warn("updateRecord: Read-only column '" + col.getName() + " has been modified!");
                }
                cmd.set(col.to(value));
                ++setCount;
            }
            sql = cmd.getUpdate();
        } else {
            log.info("updateRecord: " + name + " record has not been modified! ");
            return;
        }
        if (setCount == 0) {
            log.info("updateRecord: " + name + " nothing to update or insert!");
            return;
        }
        int affected = this.db.executeSQL(sql, cmd.getParamValues(), conn, setGenKey);
        if (affected < 0) {
            throw new UnexpectedReturnValueException(affected, "db.executeSQL()");
        }
        if (affected == 0) {
            throw new RecordUpdateInvalidException(this, this.getRecordKey(rec));
        }
        if (affected > 1) {
            throw new RecordUpdateFailedException(this, this.getRecordKey(rec));
        }
        if (this.timestampColumn != null && timestamp != null && (i = rec.getFieldIndex(this.timestampColumn)) >= 0) {
            fields[i] = timestamp;
        }
        rec.updateComplete(rec.getRowSetData());
    }

    public final void deleteRecord(Object id, Connection conn) {
        this.deleteRecord(new Object[]{id}, conn);
    }

    protected final void deleteAllReferences(Object[] key, Connection conn) {
        List<DBRelation> relations = this.db.getRelations();
        DBColumn[] keyColumns = this.getKeyColumns();
        if (keyColumns == null) {
            return;
        }
        for (DBRelation rel : relations) {
            if (rel.getOnDeleteAction() != DBRelation.DBCascadeAction.CASCADE_RECORDS) continue;
            DBRelation.DBReference[] refs = rel.getReferences();
            for (int i = 0; i < refs.length; ++i) {
                if (!refs[i].getTargetColumn().equals(keyColumns[0])) continue;
                DBRowSet rs = refs[0].getSourceColumn().getRowSet();
                rs.deleteReferenceRecords(refs, key, conn);
            }
        }
    }

    protected void deleteReferenceRecords(DBRelation.DBReference[] refs, Object[] parentKey, Connection conn) {
        if (refs.length != parentKey.length) {
            throw new InvalidArgumentException("refs", refs);
        }
        DBColumnExpr[] keyColumns = this.getKeyColumns();
        if (keyColumns == null || keyColumns.length == 0) {
            DBCommand cmd = this.db.createCommand();
            for (int i = 0; i < parentKey.length; ++i) {
                cmd.where((DBCompareExpr)refs[i].getSourceColumn().is(parentKey[i]));
            }
            if (this.db.executeSQL(cmd.getDelete((DBTable)this), cmd.getParamValues(), conn) < 0) {
                throw new UnexpectedReturnValueException(-1, "db.executeSQL()");
            }
        } else {
            int i;
            DBCommand cmd = this.db.createCommand();
            cmd.select(keyColumns);
            for (i = 0; i < parentKey.length; ++i) {
                cmd.where((DBCompareExpr)refs[i].getSourceColumn().is(parentKey[i]));
            }
            for (i = 0; i < keyColumns.length; ++i) {
                cmd.orderBy(keyColumns[i], true);
            }
            List<Object[]> recKeys = this.db.queryObjectList(cmd, conn);
            for (Object[] recKey : recKeys) {
                log.info("Deleting Record " + StringUtils.valueOf(recKey) + " from table " + this.getName());
                this.deleteRecord(recKey, conn);
            }
        }
    }

    private static class DBSetGenKey
    implements DBDatabaseDriver.DBSetGenKeys {
        private Object[] fields;
        private int index;

        public DBSetGenKey(Object[] fields, int index) {
            this.fields = fields;
            this.index = index;
        }

        @Override
        public void set(Object value) {
            this.fields[this.index] = value;
        }
    }

    public static enum PartialMode {
        INCLUDE,
        EXCLUDE;

    }
}

