/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBQueryColumn;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.InvalidKeyException;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.exceptions.QueryNoResultException;
import org.apache.empire.db.exceptions.RecordNotFoundException;
import org.apache.empire.db.exceptions.RecordUpdateFailedException;
import org.apache.empire.db.exceptions.RecordUpdateInvalidException;
import org.apache.empire.db.expr.column.DBAliasExpr;
import org.apache.empire.db.expr.compare.DBCompareColExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.join.DBColumnJoinExpr;
import org.apache.empire.db.expr.join.DBJoinExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.NotImplementedException;
import org.apache.empire.exceptions.NotSupportedException;

public class DBQuery
extends DBRowSet {
    private static final long serialVersionUID = 1L;
    private static AtomicInteger queryCount = new AtomicInteger(0);
    protected final DBCommandExpr cmdExpr;
    protected final DBColumn[] keyColumns;
    protected final DBQueryColumn[] queryColumns;
    protected final String alias;

    public DBQuery(DBCommandExpr cmd, DBColumn[] keyColumns, String alias) {
        super(cmd.getDatabase());
        this.cmdExpr = cmd;
        this.alias = alias;
        DBColumnExpr[] exprList = cmd.getSelectExprList();
        this.queryColumns = new DBQueryColumn[exprList.length];
        for (int i = 0; i < exprList.length; ++i) {
            this.queryColumns[i] = this.createQueryColumn(exprList[i], i);
            DBColumn column = exprList[i].getUpdateColumn();
            if (column == null || exprList[i] instanceof DBAliasExpr) {
                column = new DBQueryExprColumn(this, this.queryColumns[i].getName(), exprList[i]);
            }
            this.columns.add(column);
        }
        this.keyColumns = keyColumns;
    }

    public DBQuery(DBCommandExpr cmd, DBColumn[] keyColumns) {
        this(cmd, keyColumns, "q" + String.valueOf(queryCount.incrementAndGet()));
    }

    public DBQuery(DBCommandExpr cmd, DBColumn keyColumn, String alias) {
        this(cmd, new DBColumn[]{keyColumn}, alias);
    }

    public DBQuery(DBCommandExpr cmd, DBColumn keyColumn) {
        this(cmd, new DBColumn[]{keyColumn});
    }

    public DBQuery(DBCommandExpr cmd, String alias) {
        this(cmd, (DBColumn[])null, alias);
    }

    public DBQuery(DBCommandExpr cmd) {
        this(cmd, (DBColumn[])null);
    }

    public DBCommandExpr getCommandExpr() {
        return this.cmdExpr;
    }

    @Override
    public String getName() {
        return this.alias;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public boolean isUpdateable() {
        return this.getKeyColumns() != null;
    }

    public DBQueryColumn[] getQueryColumns() {
        return this.queryColumns;
    }

    public DBQueryColumn findQueryColumn(DBColumnExpr expr) {
        for (int i = 0; i < this.queryColumns.length; ++i) {
            if (!this.queryColumns[i].expr.equals(expr)) continue;
            return this.queryColumns[i];
        }
        return null;
    }

    public DBQueryColumn findQueryColumn(String name) {
        for (int i = 0; i < this.queryColumns.length; ++i) {
            if (!StringUtils.compareEqual(this.queryColumns[i].getName(), name, true)) continue;
            return this.queryColumns[i];
        }
        return null;
    }

    public DBQueryColumn column(DBColumnExpr expr) {
        return this.findQueryColumn(expr);
    }

    public DBQueryColumn column(String name) {
        return this.findQueryColumn(name);
    }

    @Override
    public DBColumn[] getKeyColumns() {
        return this.keyColumns;
    }

    @Override
    public Object[] getRecordKey(DBRecord record) {
        if (record == null || record.getRowSet() != this) {
            throw new InvalidArgumentException("record", record);
        }
        return (Object[])record.getRowSetData();
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        buf.append("(");
        buf.append(this.cmdExpr.getSelect());
        buf.append(")");
        if ((context & 8L) != 0L && this.alias != null) {
            buf.append(" ");
            buf.append(this.alias);
        }
    }

    @Override
    public void initRecord(DBRecord rec, Object[] keyValues, boolean insert) {
        this.prepareInitRecord(rec, keyValues, insert);
        Object[] fields = rec.getFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = ObjectUtils.NO_VALUE;
        }
        if (keyValues != null) {
            DBColumn[] keyColumns = this.getKeyColumns();
            for (int i = 0; i < keyColumns.length; ++i) {
                if (!this.columns.contains(keyColumns[i])) continue;
                fields[this.columns.indexOf((Object)keyColumns[i])] = keyValues[i];
            }
        }
        this.completeInitRecord(rec);
    }

    @Override
    public void createRecord(DBRecord rec, Connection conn) {
        throw new NotImplementedException(this, "createRecord");
    }

    @Override
    public void readRecord(DBRecord rec, Object[] key, Connection conn) {
        if (conn == null || rec == null) {
            throw new InvalidArgumentException("conn|rec", null);
        }
        DBColumn[] keyColumns = this.getKeyColumns();
        if (key == null || keyColumns.length != key.length) {
            throw new InvalidKeyException(this, key);
        }
        DBCommand cmd = this.getCommandFromExpression();
        for (int i = 0; i < keyColumns.length; ++i) {
            Object value = key[i];
            if (this.db.isPreparedStatementsEnabled()) {
                value = cmd.addParam(keyColumns[i], value);
            }
            cmd.where((DBCompareExpr)keyColumns[i].is(value));
        }
        try {
            this.readRecord(rec, cmd, conn);
            rec.updateComplete(key.clone());
        }
        catch (QueryNoResultException e) {
            throw new RecordNotFoundException(this, key);
        }
    }

    @Override
    public void updateRecord(DBRecord rec, Connection conn) {
        DBRowSet table;
        if (!this.isUpdateable()) {
            throw new NotSupportedException(this, "updateRecord");
        }
        if (rec == null) {
            throw new InvalidArgumentException("record", null);
        }
        if (conn == null) {
            throw new InvalidArgumentException("conn", null);
        }
        if (!rec.isModified()) {
            return;
        }
        DBColumn[] keyColumns = this.getKeyColumns();
        if (keyColumns == null) {
            throw new NoPrimaryKeyException(this);
        }
        Object[] fields = rec.getFields();
        HashMap<DBRowSet, DBCommand> updCmds = new HashMap<DBRowSet, DBCommand>(3);
        for (int i = 0; i < this.columns.size(); ++i) {
            boolean modified;
            DBColumn col = (DBColumn)this.columns.get(i);
            if (col == null) continue;
            table = col.getRowSet();
            DBCommand updCmd = (DBCommand)updCmds.get(table);
            if (updCmd == null) {
                updCmd = this.db.createCommand();
                updCmds.put(table, updCmd);
            }
            if (!(modified = rec.wasModified(i))) continue;
            if (col.isReadOnly() && log.isDebugEnabled()) {
                log.debug("updateRecord: Read-only column '" + col.getName() + " has been modified!");
            }
            col.validate(fields[i]);
            updCmd.set(col.to(fields[i]));
        }
        DBCommand cmd = this.getCommandFromExpression();
        Object[] keys = (Object[])rec.getRowSetData();
        table = null;
        DBCommand upd = null;
        for (Map.Entry entry : updCmds.entrySet()) {
            int affected;
            int i = 0;
            table = (DBRowSet)entry.getKey();
            upd = (DBCommand)entry.getValue();
            if (upd.set == null) continue;
            for (i = 0; cmd.joins != null && i < cmd.joins.size(); ++i) {
                DBJoinExpr jex = cmd.joins.get(i);
                if (!(jex instanceof DBColumnJoinExpr)) continue;
                DBColumnJoinExpr join = (DBColumnJoinExpr)jex;
                DBColumn left = join.getLeft().getUpdateColumn();
                DBColumn right = join.getRight().getUpdateColumn();
                if (left.getRowSet() == table && table.isKeyColumn(left) && !this.addJoinRestriction(upd, left, right, keyColumns, rec)) {
                    throw new ItemNotFoundException((Object)left.getFullName());
                }
                if (right.getRowSet() != table || !table.isKeyColumn(right) || this.addJoinRestriction(upd, right, left, keyColumns, rec)) continue;
                throw new ItemNotFoundException((Object)right.getFullName());
            }
            for (i = 0; cmd.where != null && i < cmd.where.size(); ++i) {
                DBCompareExpr cmp = cmd.where.get(i);
                if (cmp instanceof DBCompareColExpr) {
                    DBCompareColExpr cmpExpr = (DBCompareColExpr)cmp;
                    DBColumn col = cmpExpr.getColumnExpr().getUpdateColumn();
                    if (col == null || col.getRowSet() != table) continue;
                    if (cmpExpr.getValue() instanceof DBCmdParam) {
                        DBColumnExpr colExpr = cmpExpr.getColumnExpr();
                        DBCmdParam param = (DBCmdParam)cmpExpr.getValue();
                        DBCmdParam value = upd.addParam(colExpr, param.getValue());
                        cmp = new DBCompareColExpr(colExpr, cmpExpr.getCmpop(), value);
                    }
                    upd.where(cmp);
                    continue;
                }
                throw new NotSupportedException(this, "updateRecord with " + cmp.getClass().getName());
            }
            for (i = 0; i < keyColumns.length; ++i) {
                if (keyColumns[i].getRowSet() != table) continue;
                Object value = keys[i];
                if (this.db.isPreparedStatementsEnabled()) {
                    value = upd.addParam(keyColumns[i], value);
                }
                upd.where((DBCompareExpr)keyColumns[i].is(value));
            }
            int timestampIndex = -1;
            Timestamp timestampValue = null;
            if (table.getTimestampColumn() != null) {
                DBColumn tsColumn = table.getTimestampColumn();
                timestampIndex = this.getColumnIndex(tsColumn);
                if (timestampIndex >= 0) {
                    timestampValue = this.db.getUpdateTimestamp(conn);
                    Object lastTS = fields[timestampIndex];
                    if (!ObjectUtils.isEmpty(lastTS)) {
                        if (this.db.isPreparedStatementsEnabled()) {
                            lastTS = upd.addParam(tsColumn, lastTS);
                        }
                        upd.where((DBCompareExpr)tsColumn.is(lastTS));
                    }
                    upd.set(tsColumn.to(timestampValue));
                } else {
                    upd.set(tsColumn.to(DBDatabase.SYSDATE));
                }
            }
            if ((affected = this.db.executeSQL(upd.getUpdate(), upd.getParamValues(), conn)) <= 0) {
                if (affected == 0) {
                    throw new RecordUpdateFailedException(this, keys);
                }
                this.db.rollback(conn);
                return;
            }
            if (affected > 1) {
                throw new RecordUpdateInvalidException(this, keys);
            }
            log.info("Record for table '" + table.getName() + " sucessfully updated!");
            if (timestampIndex < 0) continue;
            fields[timestampIndex] = timestampValue;
        }
        rec.updateComplete(keys);
    }

    @Override
    public void deleteRecord(Object[] keys, Connection conn) {
        throw new NotImplementedException(this, "deleteRecord()");
    }

    protected boolean addJoinRestriction(DBCommand upd, DBColumn updCol, DBColumn keyCol, DBColumn[] keyColumns, DBRecord rec) {
        Object rowsetData = rec.getRowSetData();
        for (int i = 0; i < keyColumns.length; ++i) {
            if (keyColumns[i] != keyCol || rowsetData == null) continue;
            upd.where((DBCompareExpr)updCol.is(((Object[])rowsetData)[i]));
            return true;
        }
        int index = this.getColumnIndex(updCol);
        if (index < 0) {
            index = this.getColumnIndex(keyCol);
        }
        if (index >= 0) {
            if (rec.wasModified(index)) {
                return false;
            }
            upd.where((DBCompareExpr)updCol.is(rec.getValue(index)));
            return true;
        }
        return false;
    }

    protected DBCommand getCommandFromExpression() {
        if (this.cmdExpr instanceof DBCommand) {
            return (DBCommand)this.cmdExpr;
        }
        throw new NotSupportedException(this, "getCommand");
    }

    protected DBQueryColumn createQueryColumn(DBColumnExpr expr, int index) {
        String name = expr.getName();
        if (StringUtils.isEmpty(name)) {
            name = "COL_" + String.valueOf(index);
        }
        return new DBQueryColumn(this, name, expr);
    }

    @Override
    public int getColumnIndex(DBColumn column) {
        int index = this.columns.indexOf(column);
        if (index >= 0) {
            return index;
        }
        index = 0;
        for (DBColumn c : this.columns) {
            if (c instanceof DBQueryExprColumn && column.equals(c.getUpdateColumn())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    protected DBColumnExpr getColumnExprAt(int index) {
        DBColumn column = (DBColumn)this.columns.get(index);
        if (column instanceof DBQueryColumn) {
            return ((DBQueryExprColumn)column).expr;
        }
        return column;
    }

    protected static class DBQueryExprColumn
    extends DBQueryColumn {
        private static final long serialVersionUID = 1L;

        protected DBQueryExprColumn(DBQuery q, String name, DBColumnExpr expr) {
            super(q, name, expr);
        }

        @Override
        public DBColumn getUpdateColumn() {
            return this.expr.getUpdateColumn();
        }

        @Override
        public boolean equals(Object other) {
            if (super.equals(other)) {
                return true;
            }
            if (other instanceof DBQueryColumn) {
                DBQueryColumn oc = (DBQueryColumn)other;
                return this.rowset.equals(oc.getRowSet()) && this.expr.equals(oc.getExpr());
            }
            return false;
        }
    }
}

