/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.data;

public enum DataType {
    UNKNOWN,
    INTEGER,
    AUTOINC,
    VARCHAR,
    TEXT,
    DATE,
    DATETIME,
    TIMESTAMP,
    CHAR,
    FLOAT,
    DECIMAL,
    BOOL,
    CLOB,
    BLOB,
    UNIQUEID;


    public boolean isText() {
        return this == TEXT || this == VARCHAR || this == CHAR || this == CLOB;
    }

    public boolean isNumeric() {
        return this == INTEGER || this == DECIMAL || this == FLOAT || this == AUTOINC;
    }

    public boolean isDate() {
        return this == DATE || this == DATETIME || this == TIMESTAMP;
    }

    public boolean isBoolean() {
        return this == BOOL;
    }

    public boolean isCompatible(DataType other) {
        if (this == other) {
            return true;
        }
        if (this == UNKNOWN || other == UNKNOWN) {
            return true;
        }
        if (this.isText() && other.isText()) {
            return true;
        }
        if (this.isNumeric() && other.isNumeric()) {
            return true;
        }
        return this.isDate() && other.isDate();
    }
}

