/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.tags;

import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.DataType;
import org.apache.empire.data.Record;
import org.apache.empire.data.RecordData;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRecord;
import org.apache.empire.struts2.actionsupport.ActionBase;
import org.apache.empire.struts2.html.HtmlTagDictionary;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.tags.EmpireTagSupport;
import org.apache.struts2.components.Component;

public class FormPartTag
extends EmpireTagSupport {
    public static final String DISABLEDMODE_ATTRIBUTE = "defaultDisabledMode";
    public static final String CONTROLSIZE_ATTRIBUTE = "defaultControlSize";
    public static final String NULLVALUE_ATTRIBUTE = "defaultNullValue";
    public static final String READONLY_ATTRIBUTE = "readOnly";
    protected RecordData record;
    protected Object bean;
    protected Object controlSize;
    protected Object nullValue;
    protected String disabledMode;
    protected String property;
    protected Object hiddenFields;
    protected Object wrap;
    private Object oldRecord;
    private Object oldBean;
    private Object oldControlSize;
    private Object oldDisabledMode;
    private Object oldNullValue;
    private Object oldProperty;

    @Override
    protected void resetParams() {
        this.record = null;
        this.controlSize = null;
        this.disabledMode = null;
        this.nullValue = null;
        this.property = null;
        this.hiddenFields = null;
        this.wrap = null;
        super.resetParams();
    }

    public Component getBean(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        return null;
    }

    public boolean useBean() {
        return false;
    }

    protected boolean renderReadOnlyFields() {
        return this.getBoolean(this.hiddenFields, false);
    }

    protected boolean renderWrapperTag() {
        return this.getBoolean(this.wrap, true);
    }

    public int doStartTag() throws JspException {
        int result;
        int n = result = this.useBean() ? super.doStartTag() : 1;
        if (this.property == null && this.record != null) {
            this.property = this.getActionItemPropertyName();
        }
        if (this.record != null) {
            this.oldRecord = this.putPageAttribute("record", this.record);
        }
        if (this.bean != null) {
            this.oldBean = this.putPageAttribute("bean", this.bean);
        }
        if (this.property != null) {
            this.oldProperty = this.putPageAttribute("parentPropertyName", this.property);
        }
        if (this.disabledMode != null) {
            this.oldDisabledMode = this.putPageAttribute(DISABLEDMODE_ATTRIBUTE, this.disabledMode);
        }
        if (!ObjectUtils.isEmpty((Object)this.controlSize)) {
            this.oldControlSize = this.putPageAttribute(CONTROLSIZE_ATTRIBUTE, this.getString(this.controlSize));
        }
        if (!ObjectUtils.isEmpty((Object)this.nullValue)) {
            this.oldNullValue = this.putPageAttribute(NULLVALUE_ATTRIBUTE, this.getObject(this.nullValue, null));
        }
        if (this.record != null && this.renderReadOnlyFields()) {
            HtmlWriter w = new HtmlWriter((Writer)this.pageContext.getOut());
            this.renderHiddenField(w, this.str(this.property, this.getActionItemPropertyName()), this.getRecordKey());
            this.renderReadOnlyColumns(w);
        }
        if (this.renderWrapperTag()) {
            if (this.useBean()) {
                this.setId(null);
            }
            HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
            HtmlWriter w = new HtmlWriter((Writer)this.pageContext.getOut());
            HtmlWriter.HtmlTag wrapTag = w.startTag(dic.FormPartWrapperTag());
            this.addStandardAttributes(wrapTag, dic.FormPartWrapperClass());
            wrapTag.addAttributes(dic.FormPartWrapperAttributes());
            wrapTag.beginBody(true);
        }
        return result;
    }

    @Override
    public int doEndTag() throws JspException {
        if (this.renderWrapperTag()) {
            HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
            HtmlWriter w = new HtmlWriter((Writer)this.pageContext.getOut());
            HtmlWriter.HtmlTag wrap = w.continueTag(dic.FormPartWrapperTag(), true);
            wrap.endTag();
        }
        if (this.nullValue != null) {
            this.removePageAttribute(NULLVALUE_ATTRIBUTE, this.oldNullValue);
        }
        this.oldNullValue = null;
        if (this.controlSize != null) {
            this.removePageAttribute(CONTROLSIZE_ATTRIBUTE, this.oldControlSize);
        }
        this.oldControlSize = null;
        if (this.disabledMode != null) {
            this.removePageAttribute(DISABLEDMODE_ATTRIBUTE, this.oldDisabledMode);
        }
        this.disabledMode = null;
        if (this.property != null) {
            this.removePageAttribute("parentPropertyName", this.oldProperty);
        }
        this.oldProperty = null;
        if (this.bean != null) {
            this.removePageAttribute("bean", this.oldBean);
        }
        this.oldBean = null;
        if (this.record != null) {
            this.removePageAttribute("record", this.oldRecord);
        }
        this.oldRecord = null;
        if (this.useBean()) {
            return super.doEndTag();
        }
        this.resetParams();
        return 6;
    }

    private String getRecordKey() {
        if (!(this.record instanceof Record)) {
            return null;
        }
        Record rec = (Record)this.record;
        if (!rec.isValid()) {
            log.error("Unable to detect record key. Record supplied is not valid!");
            return null;
        }
        Object action = this.pageContext.getRequest().getAttribute("action");
        if (action instanceof ActionBase) {
            return ((ActionBase)action).getRecordKeyString(rec);
        }
        StringBuffer key = new StringBuffer();
        Column[] keyCols = rec.getKeyColumns();
        for (int i = 0; i < keyCols.length; ++i) {
            if (i > 0) {
                key.append("/");
            }
            key.append(StringUtils.valueOf((Object)rec.getValue((ColumnExpr)keyCols[i])));
        }
        return key.toString();
    }

    private void renderHiddenField(HtmlWriter w, String name, String value) {
        HtmlWriter.HtmlTag item = w.startTag("input");
        item.addAttribute("type", "hidden");
        item.addAttribute("name", name);
        item.addAttribute("value", value);
        item.endTag(true);
    }

    private void renderReadOnlyColumns(HtmlWriter w) {
        if (this.record instanceof Record && ((Record)this.record).isValid()) {
            DBColumn timestamp = null;
            if (this.record instanceof DBRecord) {
                timestamp = ((DBRecord)this.record).getRowSet().getTimestampColumn();
            }
            Record rec = (Record)this.record;
            Column[] keyCols = rec.getKeyColumns();
            String sysdate = DBDatabase.SYSDATE.toString();
            int count = rec.getFieldCount();
            for (int i = 0; i < count; ++i) {
                Date date;
                Column column = rec.getColumn(i);
                if (column == null || column != timestamp && (!rec.wasModified(column) || !rec.isFieldReadOnly(column) || this.isKeyColumn(column, keyCols)) || this.record.isNull(i)) continue;
                DataType dataType = column.getDataType();
                String value = StringUtils.toString((Object)this.record.getValue(i));
                if (!(dataType != DataType.DATETIME && dataType != DataType.TIMESTAMP || sysdate.equals(value))) {
                    date = ObjectUtils.getDate((Object)this.record.getValue(i));
                    value = this.formatDate(date, "yyyy-MM-dd HH:mm:ss.S");
                } else if (column.getDataType() == DataType.DATE && !sysdate.equals(value)) {
                    date = ObjectUtils.getDate((Object)this.record.getValue(i));
                    value = this.formatDate(date, "yyyy-MM-dd");
                }
                this.renderHiddenField(w, this.getColumnPropertyName((ColumnExpr)column, this.property), value);
            }
        }
    }

    private String formatDate(Date date, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.format(date);
        }
        catch (Exception e) {
            log.error("Unable to format date", (Throwable)e);
            return StringUtils.valueOf((Object)date);
        }
    }

    private boolean isKeyColumn(Column column, Column[] keyCols) {
        if (keyCols != null) {
            for (int i = 0; i < keyCols.length; ++i) {
                if (keyCols[i] != column) continue;
                return true;
            }
        }
        return false;
    }

    private String getColumnPropertyName(ColumnExpr col, String property) {
        String name = col.getName();
        if (property == null) {
            return name + "!";
        }
        return property + "." + name + "!";
    }

    public void setControlSize(Object controlSize) {
        this.controlSize = controlSize;
    }

    public void setNullValue(Object nullValue) {
        this.nullValue = nullValue;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setRecord(RecordData record) {
        this.record = record;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public void setHiddenFields(Object hiddenFields) {
        this.hiddenFields = hiddenFields;
    }

    public void setDisabledMode(String disabledMode) {
        this.disabledMode = disabledMode;
    }

    public void setWrap(Object wrap) {
        this.wrap = wrap;
    }
}

