/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.components;

import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.xwork.StringUtils;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.components.ControlComponent;
import org.apache.struts2.components.Form;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormComponent
extends Form {
    protected static Logger log = LoggerFactory.getLogger(ControlComponent.class);
    private HtmlWriter.HtmlTag formTag = null;
    private boolean readOnly = false;

    public FormComponent(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public boolean start(Writer writer) {
        this.evaluateParams();
        try {
            HtmlWriter htmlWriter = new HtmlWriter(writer);
            if (!this.readOnly) {
                this.urlRenderer.renderFormUrl((Form)this);
                this.formTag = htmlWriter.startTag("form");
                this.formTag.addAttribute("id", this.getId());
                this.formTag.addAttribute("name", this.getName());
                this.formTag.addAttribute("onsubmit", this.onsubmit);
                this.formTag.addAttribute("action", this.getURL(this.action));
                this.formTag.addAttribute("target", this.target);
                this.formTag.addAttribute("method", this.method);
                this.formTag.addAttribute("enctype", this.enctype);
                this.formTag.beginBody(true);
            }
        }
        catch (Exception e) {
            log.error("error when rendering", (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean end(Writer writer, String body) {
        try {
            if (this.formTag != null) {
                this.formTag.endTag(true);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.error("error when rendering", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.popComponentStack();
        }
    }

    public String getId() {
        if (!StringUtils.isEmpty((String)this.id)) {
            return this.id;
        }
        Object p = this.getParameters().get("id");
        return p != null ? p.toString() : null;
    }

    public String getName() {
        if (!StringUtils.isEmpty((String)this.name)) {
            return this.name;
        }
        Object p = this.getParameters().get("name");
        return p != null ? p.toString() : null;
    }

    private String getURL(String action) {
        Object url = this.getParameters().get("action");
        return String.valueOf(url);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

