/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.actionsupport;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.LocaleProvider;
import java.sql.Connection;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.Record;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.struts2.action.ActionItemProperty;
import org.apache.empire.struts2.action.ErrorInfo;
import org.apache.empire.struts2.action.RequestParamProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActionBase
implements ActionItemProperty,
RequestParamProvider,
LocaleProvider {
    protected static Logger log = LoggerFactory.getLogger(ActionBase.class);
    private static final char KEY_SEP_CHAR = '/';
    private static final char NEW_FLAG_CHAR = '*';

    protected abstract Connection getConnection();

    public abstract void setActionError(Exception var1);

    protected abstract void addFieldError(String var1, Column var2, ErrorInfo var3);

    public abstract int getListPageSize();

    protected String getActionObjectName(ActionContext context, String name) {
        ActionProxy proxy = this.getActionProxy(context);
        if (proxy == null) {
            return null;
        }
        return proxy.getActionName() + "." + name;
    }

    protected Object getActionObject(String name) {
        ActionContext context = ActionContext.getContext();
        String key = this.getActionObjectName(context, name);
        if (key == null) {
            return null;
        }
        return context.getSession().get(key);
    }

    protected void putActionObject(String name, Object item) {
        ActionContext context = ActionContext.getContext();
        String key = this.getActionObjectName(context, name);
        if (key != null) {
            context.getSession().put(key, item);
        }
    }

    protected void removeActionObject(String name) {
        ActionContext context = ActionContext.getContext();
        String key = this.getActionObjectName(context, name);
        if (key != null) {
            context.getSession().remove(key);
        }
    }

    private ActionProxy getActionProxy(ActionContext context) {
        ActionInvocation invocation = context.getActionInvocation();
        if (invocation == null) {
            log.error("Action Invocation cannot be obtained. Calling from action constructor?");
            return null;
        }
        ActionProxy proxy = invocation.getProxy();
        if (proxy == null) {
            log.error("ActionProxy cannot be obtained. Calling from action constructor?");
            return null;
        }
        return proxy;
    }

    protected String getActionBeanName(ActionContext context, Class<?> objClass, String ownerProperty) {
        ActionProxy proxy = this.getActionProxy(context);
        if (proxy == null) {
            return null;
        }
        if (ownerProperty == null) {
            return proxy.getActionName() + "." + objClass.getName();
        }
        return proxy.getActionName() + "." + ownerProperty + "." + objClass.getName();
    }

    public Object getActionBean(Class<?> objClass, boolean create, String ownerProperty) {
        if (objClass == null) {
            return null;
        }
        ActionContext context = ActionContext.getContext();
        String key = this.getActionBeanName(context, objClass, ownerProperty);
        if (key == null) {
            return null;
        }
        Object obj = context.getSession().get(key);
        if (obj == null && create) {
            try {
                obj = objClass.newInstance();
                context.getSession().put(key, obj);
            }
            catch (Exception e) {
                log.error("Cannot create Instance of type " + objClass.getName(), (Throwable)e);
            }
        }
        return obj;
    }

    public Object getActionBean(Class<?> objClass, boolean create) {
        return this.getActionBean(objClass, create, null);
    }

    public void putActionBean(Object obj, String ownerProperty) {
        if (obj == null || obj instanceof String || obj.getClass().isPrimitive() || obj.getClass().isArray()) {
            log.error("Unable to store object on session. Object is null, a primitive type or a string!");
            return;
        }
        ActionContext context = ActionContext.getContext();
        String key = this.getActionBeanName(context, obj.getClass(), ownerProperty);
        if (key != null) {
            context.getSession().put(key, obj);
        }
    }

    public void putActionBean(Object obj) {
        this.putActionBean(obj, null);
    }

    public void removeActionBean(Class<?> objClass, String propertyName) {
        if (objClass == null) {
            return;
        }
        ActionContext context = ActionContext.getContext();
        String key = this.getActionBeanName(context, objClass, propertyName);
        if (key != null) {
            context.getSession().remove(key);
        }
    }

    public void removeActionBean(Class<?> objClass) {
        this.removeActionBean(objClass, null);
    }

    public String getRecordKeyString(Record record) {
        if (!record.isValid()) {
            return null;
        }
        Column[] keyCols = record.getKeyColumns();
        if (keyCols == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < keyCols.length; ++i) {
            if (i > 0) {
                buf.append('/');
            }
            buf.append(StringUtils.valueOf((Object)record.getValue((ColumnExpr)keyCols[i])));
        }
        if (record.isNew()) {
            buf.append('*');
        }
        return buf.toString();
    }

    public String getRecordKeyString(Object[] key, boolean isNew) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < key.length; ++i) {
            if (i > 0) {
                buf.append('/');
            }
            buf.append(StringUtils.valueOf((Object)key[i]));
        }
        if (isNew) {
            buf.append('*');
        }
        return buf.toString();
    }

    protected static DBColumnExpr getRecordKeyExpr(DBRowSet rowset, String aliasName) {
        if (rowset == null) {
            return null;
        }
        DBColumn[] keyCols = rowset.getKeyColumns();
        if (keyCols == null || keyCols.length == 0) {
            return null;
        }
        DBColumn expr = keyCols[0];
        for (int i = 1; i < keyCols.length; ++i) {
            expr = expr.append((Object)Character.valueOf('/')).append((Object)keyCols[i]);
        }
        if (aliasName == null || aliasName.length() == 0) {
            return expr;
        }
        return expr.as(aliasName);
    }

    protected Object[] getRecordKeyFromString(String s) {
        int n;
        if (s == null || s.equals("*")) {
            return null;
        }
        int count = 1;
        int i = 0;
        while ((i = s.indexOf(47, i) + 1) > 0) {
            ++count;
        }
        Object[] key = new Object[count];
        count = 0;
        int i2 = 0;
        while (true) {
            if ((n = s.indexOf(47, i2)) < i2) {
                n = s.length();
                if (n > 0 && s.charAt(n - 1) == '*') {
                    --n;
                }
                break;
            }
            key[count] = n > i2 ? s.substring(i2, n) : null;
            i2 = n + 1;
            ++count;
        }
        key[count] = n > i2 ? s.substring(i2, n) : null;
        return key;
    }

    protected boolean getRecordNewFlagFromString(String s) {
        return s != null && s.length() > 0 && s.charAt(s.length() - 1) == '*';
    }
}

