/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.sqlite;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdType;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBDriverFeature;
import org.apache.empire.db.DBJoinType;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.expr.join.DBColumnJoinExpr;
import org.apache.empire.db.expr.join.DBJoinExpr;
import org.apache.empire.db.sqlite.SQLiteDDLGenerator;
import org.apache.empire.exceptions.NotImplementedException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBDatabaseDriverSQLite
extends DBDatabaseDriver {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBDatabaseDriverSQLite.class);
    private DBDDLGenerator<?> ddlGenerator = null;

    public DBDatabaseDriverSQLite() {
        this.setReservedKeywords();
    }

    private void addReservedKeyWord(String keyWord) {
        boolean added = this.reservedSQLKeywords.add(keyWord.toLowerCase());
        if (!added) {
            log.debug("Existing keyWord added: " + keyWord);
        }
    }

    private void setReservedKeywords() {
        this.addReservedKeyWord("ABORT".toLowerCase());
        this.addReservedKeyWord("ACTION".toLowerCase());
        this.addReservedKeyWord("ADD".toLowerCase());
        this.addReservedKeyWord("AFTER".toLowerCase());
        this.addReservedKeyWord("ALL".toLowerCase());
        this.addReservedKeyWord("ALTER".toLowerCase());
        this.addReservedKeyWord("ANALYZE".toLowerCase());
        this.addReservedKeyWord("AND".toLowerCase());
        this.addReservedKeyWord("AS".toLowerCase());
        this.addReservedKeyWord("ASC".toLowerCase());
        this.addReservedKeyWord("ATTACH".toLowerCase());
        this.addReservedKeyWord("AUTOINCREMENT".toLowerCase());
        this.addReservedKeyWord("BEFORE".toLowerCase());
        this.addReservedKeyWord("BEGIN".toLowerCase());
        this.addReservedKeyWord("BETWEEN".toLowerCase());
        this.addReservedKeyWord("BY".toLowerCase());
        this.addReservedKeyWord("CASCADE".toLowerCase());
        this.addReservedKeyWord("CASE".toLowerCase());
        this.addReservedKeyWord("CAST".toLowerCase());
        this.addReservedKeyWord("CHECK".toLowerCase());
        this.addReservedKeyWord("COLLATE".toLowerCase());
        this.addReservedKeyWord("COLUMN".toLowerCase());
        this.addReservedKeyWord("COMMIT".toLowerCase());
        this.addReservedKeyWord("CONFLICT".toLowerCase());
        this.addReservedKeyWord("CONSTRAINT".toLowerCase());
        this.addReservedKeyWord("CREATE".toLowerCase());
        this.addReservedKeyWord("CROSS".toLowerCase());
        this.addReservedKeyWord("CURRENT_DATE".toLowerCase());
        this.addReservedKeyWord("CURRENT_TIME".toLowerCase());
        this.addReservedKeyWord("CURRENT_DATETIME".toLowerCase());
        this.addReservedKeyWord("DATABASE".toLowerCase());
        this.addReservedKeyWord("DEFAULT".toLowerCase());
        this.addReservedKeyWord("DEFERRABLE".toLowerCase());
        this.addReservedKeyWord("DEFERRED".toLowerCase());
        this.addReservedKeyWord("DELETE".toLowerCase());
        this.addReservedKeyWord("DESC".toLowerCase());
        this.addReservedKeyWord("DETACH".toLowerCase());
        this.addReservedKeyWord("DISTINCT".toLowerCase());
        this.addReservedKeyWord("DROP".toLowerCase());
        this.addReservedKeyWord("EACH".toLowerCase());
        this.addReservedKeyWord("ELSE".toLowerCase());
        this.addReservedKeyWord("END".toLowerCase());
        this.addReservedKeyWord("ESCAPE".toLowerCase());
        this.addReservedKeyWord("EXCEPT".toLowerCase());
        this.addReservedKeyWord("EXCLUSIVE".toLowerCase());
        this.addReservedKeyWord("EXISTS".toLowerCase());
        this.addReservedKeyWord("EXPLAIN".toLowerCase());
        this.addReservedKeyWord("FAIL".toLowerCase());
        this.addReservedKeyWord("FOR".toLowerCase());
        this.addReservedKeyWord("FOREIGN".toLowerCase());
        this.addReservedKeyWord("FROM".toLowerCase());
        this.addReservedKeyWord("FULL".toLowerCase());
        this.addReservedKeyWord("GLOB".toLowerCase());
        this.addReservedKeyWord("GROUP".toLowerCase());
        this.addReservedKeyWord("HAVING".toLowerCase());
        this.addReservedKeyWord("IF".toLowerCase());
        this.addReservedKeyWord("IGNORE".toLowerCase());
        this.addReservedKeyWord("IMMEDIATE".toLowerCase());
        this.addReservedKeyWord("IN".toLowerCase());
        this.addReservedKeyWord("INDEX".toLowerCase());
        this.addReservedKeyWord("INDEXED".toLowerCase());
        this.addReservedKeyWord("INITIALLY".toLowerCase());
        this.addReservedKeyWord("INNER".toLowerCase());
        this.addReservedKeyWord("INSERT".toLowerCase());
        this.addReservedKeyWord("INSTEAD".toLowerCase());
        this.addReservedKeyWord("INTERSECT".toLowerCase());
        this.addReservedKeyWord("INTO".toLowerCase());
        this.addReservedKeyWord("IS".toLowerCase());
        this.addReservedKeyWord("ISNULL".toLowerCase());
        this.addReservedKeyWord("JOIN".toLowerCase());
        this.addReservedKeyWord("KEY".toLowerCase());
        this.addReservedKeyWord("LEFT".toLowerCase());
        this.addReservedKeyWord("LIKE".toLowerCase());
        this.addReservedKeyWord("LIMIT".toLowerCase());
        this.addReservedKeyWord("MATCH".toLowerCase());
        this.addReservedKeyWord("NATURAL".toLowerCase());
        this.addReservedKeyWord("NO".toLowerCase());
        this.addReservedKeyWord("NOT".toLowerCase());
        this.addReservedKeyWord("NOTNULL".toLowerCase());
        this.addReservedKeyWord("NULL".toLowerCase());
        this.addReservedKeyWord("OF".toLowerCase());
        this.addReservedKeyWord("OFFSET".toLowerCase());
        this.addReservedKeyWord("ON".toLowerCase());
        this.addReservedKeyWord("OR".toLowerCase());
        this.addReservedKeyWord("ORDER".toLowerCase());
        this.addReservedKeyWord("OUTER".toLowerCase());
        this.addReservedKeyWord("PLAN".toLowerCase());
        this.addReservedKeyWord("PRAGMA".toLowerCase());
        this.addReservedKeyWord("PRIMARY".toLowerCase());
        this.addReservedKeyWord("QUERY".toLowerCase());
        this.addReservedKeyWord("RAISE".toLowerCase());
        this.addReservedKeyWord("REFERENCES".toLowerCase());
        this.addReservedKeyWord("REGEXP".toLowerCase());
        this.addReservedKeyWord("REINDEX".toLowerCase());
        this.addReservedKeyWord("RELEASE".toLowerCase());
        this.addReservedKeyWord("RENAME".toLowerCase());
        this.addReservedKeyWord("REPLACE".toLowerCase());
        this.addReservedKeyWord("RESTRICT".toLowerCase());
        this.addReservedKeyWord("RIGHT".toLowerCase());
        this.addReservedKeyWord("ROLLBACK".toLowerCase());
        this.addReservedKeyWord("ROW".toLowerCase());
        this.addReservedKeyWord("SAVEPOINT".toLowerCase());
        this.addReservedKeyWord("SELECT".toLowerCase());
        this.addReservedKeyWord("SET".toLowerCase());
        this.addReservedKeyWord("TABLE".toLowerCase());
        this.addReservedKeyWord("TEMP".toLowerCase());
        this.addReservedKeyWord("TEMPORARY".toLowerCase());
        this.addReservedKeyWord("THEN".toLowerCase());
        this.addReservedKeyWord("TO".toLowerCase());
        this.addReservedKeyWord("TRANSACTION".toLowerCase());
        this.addReservedKeyWord("TRIGGER".toLowerCase());
        this.addReservedKeyWord("UNION".toLowerCase());
        this.addReservedKeyWord("UNIQUE".toLowerCase());
        this.addReservedKeyWord("UPDATE".toLowerCase());
        this.addReservedKeyWord("USING".toLowerCase());
        this.addReservedKeyWord("VACUUM".toLowerCase());
        this.addReservedKeyWord("VALUES".toLowerCase());
        this.addReservedKeyWord("VIEW".toLowerCase());
        this.addReservedKeyWord("VIRTUAL".toLowerCase());
        this.addReservedKeyWord("WHEN".toLowerCase());
        this.addReservedKeyWord("WHERE".toLowerCase());
    }

    @Override
    public DBCommand createCommand(DBDatabase db) {
        if (db == null) {
            return null;
        }
        return new DBCommandSQLite(db);
    }

    @Override
    public boolean isSupported(DBDriverFeature type) {
        switch (type) {
            case QUERY_LIMIT_ROWS: {
                return true;
            }
            case QUERY_SKIP_ROWS: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getSQLPhrase(int phrase) {
        switch (phrase) {
            case 1: {
                return "null";
            }
            case 2: {
                return " ? ";
            }
            case 3: {
                return " ";
            }
            case 4: {
                return " AS ";
            }
            case 5: {
                return "@";
            }
            case 6: {
                return "`";
            }
            case 7: {
                return "`";
            }
            case 8: {
                return "concat(?, {0})";
            }
            case 10: {
                return "1";
            }
            case 11: {
                return "0";
            }
            case 20: {
                return "SELECT date('now','localtime');";
            }
            case 21: {
                return "yyyy-MM-dd";
            }
            case 22: {
                return "'{0}'";
            }
            case 23: {
                return "yyyy-MM-dd hh:mm:ss.sss";
            }
            case 24: {
                return "'{0}'";
            }
            case 25: {
                return "NOW()";
            }
            case 26: {
                return "yyyy-MM-dd hh:mm:ss.sss";
            }
            case 27: {
                return "'{0}'";
            }
            case 100: {
                return "coalesce(?, {0})";
            }
            case 101: {
                return "substring(?, {0})";
            }
            case 102: {
                return "substring(?, {0}, {1})";
            }
            case 103: {
                return "replace(?, {0}, {1})";
            }
            case 104: {
                return "reverse(?)";
            }
            case 105: {
                return "instr(?, {0})";
            }
            case 106: {
                return "locate({0}, ?, {1})";
            }
            case 107: {
                return "length(?)";
            }
            case 110: {
                return "upper(?)";
            }
            case 111: {
                return "lcase(?)";
            }
            case 112: {
                return "trim(?)";
            }
            case 113: {
                return "ltrim(?)";
            }
            case 114: {
                return "rtrim(?)";
            }
            case 119: {
                return "? escape '{0}'";
            }
            case 120: {
                return "abs(?)";
            }
            case 121: {
                return "round(?,{0})";
            }
            case 122: {
                return "truncate(?,{0})";
            }
            case 124: {
                return "ceiling(?)";
            }
            case 123: {
                return "floor(?)";
            }
            case 125: {
                return "mod(?,{0})";
            }
            case 126: {
                return "printf({0:VARCHAR}, ?)";
            }
            case 132: {
                return "day(?)";
            }
            case 133: {
                return "month(?)";
            }
            case 134: {
                return "year(?)";
            }
            case 140: {
                return "sum(?)";
            }
            case 142: {
                return "max(?)";
            }
            case 143: {
                return "min(?)";
            }
            case 144: {
                return "avg(?)";
            }
            case 150: {
                return "case ? {0} end";
            }
            case 151: {
                return " ";
            }
            case 152: {
                return "when {0} then {1}";
            }
            case 153: {
                return "else {0}";
            }
        }
        log.error("SQL phrase " + String.valueOf(phrase) + " is not defined!");
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeSQL(String sqlCmd, Object[] sqlParams, Connection conn, DBDatabaseDriver.DBSetGenKeys genKeys) throws SQLException {
        int count;
        block9: {
            Statement stmt = null;
            count = 0;
            try {
                if (sqlParams != null) {
                    PreparedStatement pstmt = conn.prepareStatement(sqlCmd);
                    stmt = pstmt;
                    this.prepareStatement(pstmt, sqlParams);
                    count = pstmt.executeUpdate();
                } else {
                    stmt = conn.createStatement();
                    count = stmt.executeUpdate(sqlCmd);
                }
                if (genKeys == null || count <= 0) break block9;
                ResultSet rs = stmt.getGeneratedKeys();
                try {
                    while (rs.next()) {
                        genKeys.set(rs.getObject(1));
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                this.close(stmt);
            }
        }
        return count;
    }

    @Override
    public Object getResultValue(ResultSet rset, int columnIndex, DataType dataType) throws SQLException {
        if (dataType == DataType.DATETIME || dataType == DataType.TIMESTAMP) {
            String datePattern = this.getSQLPhrase(23);
            SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
            try {
                Date timestamp = dateFormat.parse(rset.getString(columnIndex));
                return new Timestamp(timestamp.getTime());
            }
            catch (ParseException e) {
                throw new UnexpectedReturnValueException((Object)rset.getString(columnIndex), "getResultValue");
            }
        }
        if (dataType == DataType.CLOB) {
            Clob clob = rset.getClob(columnIndex);
            return clob != null ? clob.getSubString(1L, (int)clob.length()) : null;
        }
        if (dataType == DataType.BLOB) {
            Blob blob = rset.getBlob(columnIndex);
            return blob != null ? blob.getBytes(1L, (int)blob.length()) : null;
        }
        return rset.getObject(columnIndex);
    }

    @Override
    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case TEXT: 
            case VARCHAR: 
            case CHAR: {
                if (format != null) {
                    if (srcType == DataType.INTEGER || srcType == DataType.AUTOINC) {
                        log.error("getConvertPhrase: unknown type " + (Object)((Object)destType));
                        return "?";
                    }
                    return "to_char(?, '" + format.toString() + "')";
                }
                return "convert(?, CHAR)";
            }
            case INTEGER: {
                return "convert(?, BIGINT)";
            }
            case DECIMAL: {
                return "convert(?, DECIMAL)";
            }
            case FLOAT: {
                return "convert(?, DOUBLE)";
            }
        }
        log.error("getConvertPhrase: unknown type (" + String.valueOf((Object)destType));
        return "?";
    }

    @Override
    public Timestamp getUpdateTimestamp(Connection conn) {
        GregorianCalendar cal = new GregorianCalendar();
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public void getDDLScript(DBCmdType type, DBObject dbo, DBSQLScript script) {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new SQLiteDDLGenerator(this);
        }
        this.ddlGenerator.getDDLScript(type, dbo, script);
    }

    @Override
    public Object getNextSequenceValue(DBDatabase db, String SeqName, int minValue, Connection conn) {
        throw new NotImplementedException(db, " sequence values are assigned dynamicaly from sqlite ");
    }

    @Override
    public DBColumnExpr getNextSequenceValueExpr(DBTableColumn column) {
        throw new NotSupportedException(this, "getNextSequenceValueExpr");
    }

    public static class DBCommandSQLite
    extends DBCommand {
        private static final long serialVersionUID = 1L;

        public DBCommandSQLite(DBDatabase db) {
            super(db);
        }

        @Override
        public void join(DBJoinExpr join) {
            if (join.getType() != DBJoinType.LEFT) {
                throw new NotImplementedException((Object)join.getType(), join.getLeftTable().getName() + " join " + join.getRightTable().getName());
            }
            super.join(join);
        }

        @Override
        public void addJoins(List<DBJoinExpr> joinExprList) {
            for (DBJoinExpr joinExpr : joinExprList) {
                if (!(joinExpr instanceof DBColumnJoinExpr) || joinExpr.getType() == DBJoinType.LEFT) continue;
                DBColumnJoinExpr join = (DBColumnJoinExpr)joinExpr;
                throw new NotImplementedException((Object)joinExpr.getType(), join.getLeft() + " join " + join.getRight());
            }
            super.addJoins(joinExprList);
        }
    }
}

