/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.oracle;

import java.sql.Connection;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.oracle.DBDatabaseDriverOracle;
import org.apache.empire.db.validation.DBModelChecker;
import org.apache.empire.db.validation.DBModelErrorHandler;
import org.apache.empire.exceptions.InvalidPropertyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDBModelChecker
extends DBModelChecker {
    private static final Logger log = LoggerFactory.getLogger(OracleDBModelChecker.class);
    private DBDatabaseDriverOracle.BooleanType booleanType = DBDatabaseDriverOracle.BooleanType.NUMBER;

    @Override
    public void checkModel(DBDatabase db, Connection conn, String dbSchema, DBModelErrorHandler handler) {
        DBDatabaseDriver driver = db.getDriver();
        if (driver instanceof DBDatabaseDriverOracle) {
            this.booleanType = ((DBDatabaseDriverOracle)driver).getBooleanType();
        } else {
            log.warn("Provided driver is not of type DBDatabaseDriverOracle");
        }
        super.checkModel(db, conn, dbSchema, handler);
    }

    @Override
    protected void checkBoolColumn(DBColumn column, DBColumn remoteColumn, DBModelErrorHandler handler) {
        this.checkColumnNullable(column, remoteColumn, handler);
        DataType booleanDataType = null;
        switch (this.booleanType) {
            case NUMBER: {
                booleanDataType = DataType.DECIMAL;
                break;
            }
            case CHAR: {
                booleanDataType = DataType.CHAR;
                break;
            }
            default: {
                throw new InvalidPropertyException("booleanType", (Object)this.booleanType);
            }
        }
        if (remoteColumn.getDataType() != booleanDataType) {
            handler.columnTypeMismatch(column, booleanDataType);
        }
        if (remoteColumn.getSize() != 1.0) {
            handler.columnSizeMismatch(column, 1, 0);
        }
    }
}

